/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes.activities;

import oracle.bpm.data.GlobalType;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Activable;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.ScheduleFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.activities.JMSListeningInfoFeature;
import oracle.bpm.project.model.processes.activities.JMXListeningInfoFeature;
import oracle.bpm.project.model.processes.activities.ListeningInfoFeature;
import oracle.bpm.project.model.processes.activities.PollingInfoFeature;
import oracle.bpm.resources.Msg;

public class GlobalAutoFeature
extends FeatureSet {
    private ListeningType globalAutoType = new ListeningType("globalType", ProjectModelMsg.GLOBAL_AUTO_TYPE, null, GlobalType.POLLING);
    private JMSListeningInfoFeature jmsGlobalType;
    private JMXListeningInfoFeature jmxListeningGlobalTypeFeature;
    private ListeningInfoFeature listeningType;
    private PollingInfoFeature pollingFeature;
    private ScheduleInfoFeature scheduleGlobalType;
    private static final String GLOBAL_TYPE = "globalType";

    private GlobalAutoFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
        this.addFeature(this.globalAutoType);
        this.pollingFeature = PollingInfoFeature.create();
        this.addFeature(this.pollingFeature);
        this.scheduleGlobalType = ScheduleInfoFeature.create();
        this.addFeature(this.scheduleGlobalType);
        this.listeningType = ListeningInfoFeature.create();
        this.addFeature(this.listeningType);
        this.jmsGlobalType = JMSListeningInfoFeature.create();
        this.addFeature(this.jmsGlobalType);
        this.jmxListeningGlobalTypeFeature = JMXListeningInfoFeature.create();
        this.addFeature(this.jmxListeningGlobalTypeFeature);
    }

    public static GlobalAutoFeature create() {
        return new GlobalAutoFeature(GLOBAL_TYPE, ProjectModelMsg.TARGET_FOR_NON_CREATED_INSTANCES, ProjectModelMsg.TARGET_FOR_NON_CREATED_INST_DESCRIP);
    }

    public ListeningInfoFeature getListeningType() {
        return this.listeningType;
    }

    public JMSListeningInfoFeature getJmsGlobalType() {
        return this.jmsGlobalType;
    }

    public JMXListeningInfoFeature getJmxListeningGlobalType() {
        return this.jmxListeningGlobalTypeFeature;
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visitFeature(this);
    }

    @Override
    public int getSortHint() {
        return 1;
    }

    public Feature getActive() {
        switch ((GlobalType)this.globalAutoType.getValue()) {
            case SCHEDULED: {
                return this.scheduleGlobalType;
            }
            case LISTENER: {
                return this.listeningType;
            }
            case POLLING: {
                return this.pollingFeature;
            }
            case JMS: {
                return this.jmsGlobalType;
            }
            case JMX: {
                return this.jmxListeningGlobalTypeFeature;
            }
        }
        return this.jmsGlobalType;
    }

    public ListeningType getGlobalAutoType() {
        return this.globalAutoType;
    }

    public PollingInfoFeature getPollingFeature() {
        return this.pollingFeature;
    }

    public ScheduleInfoFeature getScheduleGlobalType() {
        return this.scheduleGlobalType;
    }

    public class ListeningType
    extends EnumFeature<GlobalType> {
        protected ListeningType(String featureName, Msg label, Msg description, GlobalType value) {
            super(GlobalType.class, featureName, label, description, value);
        }

        @Override
        public void setValue(GlobalType value) {
            super.setValue(value);
            if (GlobalAutoFeature.this.pollingFeature != null) {
                GlobalAutoFeature.this.pollingFeature.setActive(false);
                GlobalAutoFeature.this.scheduleGlobalType.setActive(false);
                GlobalAutoFeature.this.listeningType.setActive(false);
                GlobalAutoFeature.this.jmsGlobalType.setActive(false);
                GlobalAutoFeature.this.jmxListeningGlobalTypeFeature.setActive(false);
                ((Activable)((Object)GlobalAutoFeature.this.getActive())).setActive(true);
            }
        }
    }

    public static class ScheduleInfoFeature
    extends ScheduleFeature
    implements Activable {
        private boolean active;
        private static final String SCHEDULE = "schedule";

        private ScheduleInfoFeature(String featureName, Msg label, Msg description, Schedule value) {
            super(featureName, label, description, value);
        }

        public static ScheduleInfoFeature create() {
            return new ScheduleInfoFeature(SCHEDULE, ProjectModelMsg.SCHEDULE, null, new Schedule());
        }

        @Override
        public void visit(ProjectVisitor visitor) throws ProjectException {
            if (this.isActive()) {
                super.visit(visitor);
            }
        }

        @Override
        public int getSortHint() {
            return 1;
        }

        @Override
        public void setActive(boolean value) {
            this.active = value;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }
    }
}

