/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum TaskType implements I18nProvider
{
    METHOD(ProjectModelMsg.METHOD),
    COMPONENT(ProjectModelMsg.COMPONENT),
    PROCEDURE(LibMsg.PROCEDURE),
    SCREENFLOW(LibMsg.SCREENFLOW),
    INPUT(ProjectModelMsg.INPUT),
    DISPLAY(ProjectModelMsg.DISPLAY),
    SHOW_PROCESS_IMAGE(ProjectModelMsg.SHOW_PROCESS_IMAGE),
    SHOW_WORKLOAD(ProjectModelMsg.SHOW_WORKLOAD),
    SHOW_PROCESS_MONITOR(ProjectModelMsg.SHOW_PROCESS_MONITOR),
    SHOW_DASHBOARD(ProjectModelMsg.SHOW_DASHBOARD),
    DISPLAY_INSTANCE_VARIABLES(ProjectModelMsg.DISPLAY_INSTANCE_VARIABLES),
    EXTERNAL(ProjectModelMsg.EXTERNAL),
    BPM_OBJECT_INTERACTIVE_CALL(ProjectModelMsg.FUEGO_OBJECT_INTERACTIVE_CALL),
    DECISION(ProjectModelMsg.DECISION),
    EDIT_BUSINESS_RULES(ProjectModelMsg.EDIT_BUSINESS_RULES);

    private transient Msg msg;

    private TaskType(Msg msg) {
        this.msg = msg;
    }

    public static TaskType valueOf(int n) {
        return TaskType.values()[n];
    }

    public int intValue() {
        return this.ordinal();
    }

    public boolean isMethod() {
        return this == METHOD;
    }

    public boolean isScreenflow() {
        return this == SCREENFLOW;
    }

    public boolean isComponent() {
        return this == COMPONENT;
    }

    public boolean isInput() {
        return this == INPUT;
    }

    public boolean isDisplay() {
        return this == DISPLAY;
    }

    public boolean isDisplayInstanceVariables() {
        return this == DISPLAY_INSTANCE_VARIABLES;
    }

    public boolean isShowDashboard() {
        return this == SHOW_DASHBOARD;
    }

    public boolean isShowProcessImage() {
        return this == SHOW_PROCESS_IMAGE;
    }

    public String getString() {
        return this.getMsg().getString();
    }

    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }
}

