/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.RoutingData;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StraightRouting;
import org.jetbrains.annotations.NotNull;

public class OrthogonalRouting
extends RoutingData {
    private OrthogonalRouting(@NotNull Point ctrl) {
        super(RoutingMode.ORTHOGONAL, ctrl);
    }

    public static OrthogonalRouting create(@NotNull Point ctrl) {
        if (SequenceFlow.NULL_CONTROL_POINT.equals((Object)ctrl)) {
            throw new IllegalArgumentException("Attempting to create an Orthogonal Routing Data object with an invalid control point");
        }
        return new OrthogonalRouting(ctrl);
    }

    @Override
    public RoutingData relocate(@NotNull Point ctrl) {
        RoutingData result = SequenceFlow.NULL_CONTROL_POINT.equals((Object)ctrl) ? StraightRouting.create() : OrthogonalRouting.create(ctrl);
        return result;
    }
}

