/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.ExpressionFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.Nullable;

public class MultiInstanceFeature
extends FeatureSet {
    private CardinalityExpressionFeature cardinalityExpression;
    private CompleteConditionFeature completeCondition;
    private IsSequentialFeature isSequential = IsSequentialFeature.create();
    private InDataDeclarationFeature loopDataInputName;
    private OutDataDeclarationFeature loopDataOutputName;

    protected MultiInstanceFeature() {
        super("multiInstance", ProjectModelMsg.MULTIINSTANCE, ProjectModelMsg.MULTIINSTANCE_DESC);
        this.addFeature(this.isSequential);
        this.completeCondition = CompleteConditionFeature.create();
        this.addFeature(this.completeCondition);
        this.cardinalityExpression = CardinalityExpressionFeature.create();
        this.addFeature(this.cardinalityExpression);
        this.loopDataInputName = InDataDeclarationFeature.create();
        this.addFeature(this.loopDataInputName);
        this.loopDataOutputName = OutDataDeclarationFeature.create();
        this.addFeature(this.loopDataOutputName);
    }

    public static MultiInstanceFeature create() {
        return new MultiInstanceFeature();
    }

    public CompleteConditionFeature getCompleteCondition() {
        return this.completeCondition;
    }

    public CardinalityExpressionFeature getCardinalityExpression() {
        return this.cardinalityExpression;
    }

    public IsSequentialFeature getIsSequential() {
        return this.isSequential;
    }

    @Override
    public int getSortHint() {
        return 1;
    }

    public String getLoopDataInputName() {
        return this.loopDataInputName.getValue();
    }

    public void setLoopDataInputName(@Nullable String loopDataInputName) {
        this.loopDataInputName.setValue(loopDataInputName);
    }

    public String getLoopDataOutputName() {
        return this.loopDataOutputName.getValue();
    }

    public void setLoopDataOutputName(@Nullable String loopDataOutputName) {
        this.loopDataOutputName.setValue(loopDataOutputName);
    }

    public static class OutDataDeclarationFeature
    extends StringFeature {
        protected OutDataDeclarationFeature(String featureName, Msg label, Msg description) {
            super(featureName, label, description, null);
        }

        public static OutDataDeclarationFeature create() {
            return new OutDataDeclarationFeature("outDataDeclaration", null, null);
        }
    }

    public static class IsSequentialFeature
    extends BooleanFeature {
        protected IsSequentialFeature(String featureName, Msg label, Msg description, boolean value) {
            super(featureName, label, description, value);
        }

        public static IsSequentialFeature create() {
            return new IsSequentialFeature("isSequential", null, null, true);
        }
    }

    public static class InDataDeclarationFeature
    extends StringFeature {
        protected InDataDeclarationFeature(String featureName, Msg label, Msg description) {
            super(featureName, label, description, null);
        }

        public static InDataDeclarationFeature create() {
            return new InDataDeclarationFeature("inDataDeclaration", null, null);
        }
    }

    public static class CompleteConditionFeature
    extends ExpressionFeature {
        private CompleteConditionFeature(String name, Msg label, Msg description) {
            super(name, label, description);
        }

        public static CompleteConditionFeature create() {
            return new CompleteConditionFeature("completeCondition", null, null);
        }
    }

    public static class CardinalityExpressionFeature
    extends ExpressionFeature {
        private CardinalityExpressionFeature(String name, Msg label, Msg description) {
            super(name, label, description);
        }

        public static CardinalityExpressionFeature create() {
            return new CardinalityExpressionFeature("cardinalityExpression", null, null);
        }
    }
}

