/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.DefaultNodeFinder;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeFinder;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class FindInPath {
    private final NodeFinder comparator;
    private boolean followBoundary = false;
    private boolean foundIt = false;
    private final FlowNode from;
    private Set<FlowNode> nodeTempList = new HashSet<FlowNode>();
    private boolean run = false;
    private final FlowNode to;

    public FindInPath(FlowNode from, FlowNode to) {
        this(from, to, new DefaultNodeFinder(to));
    }

    public FindInPath(FlowNode from, FlowNode to, NodeFinder comparator) {
        this.from = from;
        this.to = to;
        this.comparator = comparator;
    }

    public boolean isFollowBoundary() {
        return this.followBoundary;
    }

    public void setFollowBoundary(boolean followBoundary) {
        this.followBoundary = followBoundary;
    }

    @NotNull
    public Sequence<FlowNode> getPath() {
        if (!this.run) {
            this.exists();
        }
        if (!this.foundIt) {
            return CollectionUtils.emptySequence();
        }
        return CollectionUtils.asSequence(this.nodeTempList);
    }

    public boolean exists() {
        this.run = true;
        this.foundIt = false;
        this.nodeTempList.clear();
        this.findIt();
        return this.foundIt;
    }

    private void findIt() {
        this.findIt(this.from);
    }

    private void findIt(FlowNode currentFrom) {
        if (this.nodeTempList.contains(currentFrom)) {
            return;
        }
        this.nodeTempList.add(currentFrom);
        ArrayList targetNodes = new ArrayList();
        if (ModelUtils.isSubprocess(currentFrom)) {
            Subprocess subprocess = currentFrom.asAnyNode(Subprocess.class);
            ModelUtils.getStartNodes(subprocess).addAllTo(targetNodes);
        }
        ModelUtils.getTargetFlowNodes(currentFrom.getOutgoingSequenceFlows()).addAllTo(targetNodes);
        if (this.isFollowBoundary()) {
            Sequence<BoundaryEvent> boundaryEventsFor = ModelUtils.getBoundaryEventsFor(currentFrom);
            for (BoundaryEvent boundaryEvent : boundaryEventsFor) {
                ModelUtils.getTargetFlowNodes(boundaryEvent.getOutgoingSequenceFlows()).addAllTo(targetNodes);
            }
        }
        for (FlowNode targetNode : targetNodes) {
            if (this.comparator.matches(targetNode)) {
                this.foundIt = true;
                break;
            }
            if (targetNode == this.to) continue;
            this.findIt(targetNode);
        }
    }
}

