/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.processes;

import java.util.Locale;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum CodeLanguage implements I18nProvider
{
    SIMPLE(ProjectModelMsg.SIMPLE){

        @Override
        public String getId() {
            return "simple";
        }
    }
    ,
    XPATH(ProjectModelMsg.XPATH){

        @Override
        public String getId() {
            return "xpath";
        }
    };

    private Msg msg;

    private CodeLanguage(Msg msg) {
        this.msg = msg;
    }

    public String getString() {
        return this.msg.getString();
    }

    public String getString(Locale locale) {
        return this.msg.getString(locale);
    }

    public abstract String getId();

    public static CodeLanguage fromId(String codeLanguage) {
        if ("simple".equalsIgnoreCase(codeLanguage)) {
            return SIMPLE;
        }
        if ("xpath".equalsIgnoreCase(codeLanguage)) {
            return XPATH;
        }
        return null;
    }
}

