/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.catalog.UpdateObject;
import oracle.bpm.project.model.features.EnumFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.features.InputArgumentsFeature;
import oracle.bpm.project.model.features.InputDataAssociationFeature;
import oracle.bpm.project.model.features.LoggableFeature;
import oracle.bpm.project.model.features.StringFeature;
import oracle.bpm.project.model.processes.AttributeExpressionFeature;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.update.UpdateDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetDefinition;
import oracle.bpm.project.model.processes.update.UpdateTargetType;
import oracle.bpm.project.model.processes.update.UpdateTask;
import oracle.bpm.project.model.processes.update.UpdateType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateFeature
extends FeatureSet {
    private TargetUserTaskFeature targetUserTaskFeature;
    private TaskIdExpressionFeature taskIdExpressionFeature;
    private UpdateDefinition updateDefinition;
    private UpdateObject updateObject;
    private UpdateTargetDefinition updateTargetDefinition;
    private UpdateTargetTypeFeature updateTargetTypeFeature;
    private UpdateTask updateTask;
    private UpdateTypeFeature updateTypeFeature;

    protected UpdateFeature(@NotNull UpdateTask updateTask) {
        super("update", null, null);
        this.updateTask = updateTask;
        this.updateTypeFeature = new UpdateTypeFeature();
        this.addFeature(this.updateTypeFeature);
        this.updateTargetTypeFeature = new UpdateTargetTypeFeature();
        this.addFeature(this.updateTargetTypeFeature);
        this.targetUserTaskFeature = new TargetUserTaskFeature(this);
        this.addFeature(this.targetUserTaskFeature);
        this.taskIdExpressionFeature = new TaskIdExpressionFeature(this);
        this.addFeature(this.taskIdExpressionFeature);
        this.addFeature(InputArgumentsFeature.create(updateTask));
        this.addFeature(InputDataAssociationFeature.create(updateTask));
        this.addFeature(LoggableFeature.create(updateTask));
    }

    public static UpdateFeature create(@NotNull UpdateTask updateTask) {
        return new UpdateFeature(updateTask);
    }

    public DataDeclarationContainer getUpdateArguments() {
        UpdateType type = this.getUpdateType();
        return this.getUpdateObject().getArguments(type);
    }

    public UpdateType getUpdateType() {
        return (UpdateType)((Object)this.updateTypeFeature.getValue());
    }

    public UpdateDefinition getUpdateDefinition() {
        if (this.updateDefinition == null) {
            this.updateUpdateDefinition();
        }
        return this.updateDefinition;
    }

    public boolean setUpdateType(@NotNull UpdateType type) {
        if (Any.equals((Object)((Object)this.getUpdateType()), (Object)((Object)type))) {
            return false;
        }
        this.updateTypeFeature.setValue(type);
        this.updateUpdateDefinition();
        return true;
    }

    public UpdateTargetType getUpdateTargetType() {
        return (UpdateTargetType)((Object)this.updateTargetTypeFeature.getValue());
    }

    public UpdateTargetDefinition getUpdateTargetDefinition() {
        if (this.updateTargetDefinition == null) {
            this.updateUpdateTargetDefinition();
        }
        return this.updateTargetDefinition;
    }

    public boolean setUpdateTargetType(@NotNull UpdateTargetType type) {
        if (Any.equals((Object)((Object)this.getUpdateTargetType()), (Object)((Object)type))) {
            return false;
        }
        this.updateTargetTypeFeature.setValue(type);
        this.updateUpdateTargetDefinition();
        return true;
    }

    public UserTask getTargetUserTask() {
        UserTask result = null;
        String targetUserTaskId = this.targetUserTaskFeature.getValue();
        if (!Str.isEmpty((String)targetUserTaskId)) {
            result = this.updateTask.getProcess().findDescendant(UserTask.class, targetUserTaskId);
        }
        return result;
    }

    public void setTargetUserTask(@Nullable UserTask targetUserTask) {
        String targetUserTaskId = targetUserTask != null ? targetUserTask.getId() : null;
        this.targetUserTaskFeature.setValue(targetUserTaskId);
    }

    public Expression getTaskId() {
        return this.taskIdExpressionFeature.getValue();
    }

    public void setTaskId(@Nullable Expression taskId) {
        this.taskIdExpressionFeature.setValue(taskId);
    }

    @Override
    public void copyFrom(Feature feature) {
        boolean mustUpdateDefinition = false;
        boolean mustUpdateTargetDefinition = false;
        if (feature instanceof UpdateFeature) {
            UpdateFeature sourceFeature = (UpdateFeature)feature;
            if (sourceFeature.getUpdateType() != this.getUpdateType()) {
                mustUpdateDefinition = true;
            }
            if (sourceFeature.getUpdateTargetType() != this.getUpdateTargetType()) {
                mustUpdateTargetDefinition = true;
            }
        }
        super.copyFrom(feature);
        if (mustUpdateDefinition) {
            this.updateUpdateDefinition();
        }
        if (mustUpdateTargetDefinition) {
            this.updateUpdateTargetDefinition();
        }
    }

    private UpdateObject getUpdateObject() {
        if (this.updateObject == null) {
            this.updateObject = this.updateTask.createUpdateObject();
        }
        return this.updateObject;
    }

    private void updateUpdateDefinition() {
        UpdateType type = this.getUpdateType();
        this.updateDefinition = this.updateTask.createUpdateDefinition(type);
    }

    private void updateUpdateTargetDefinition() {
        UpdateTargetType type = this.getUpdateTargetType();
        this.updateTargetDefinition = this.updateTask.createUpdateTargetDefinition(type);
    }

    private static final class TaskIdExpressionFeature
    extends AttributeExpressionFeature {
        private UpdateFeature updateFeature;
        public static String FEATURE_NAME = "taskId";

        private TaskIdExpressionFeature(@NotNull UpdateFeature updateFeature) {
            super(FEATURE_NAME, null, null);
            this.updateFeature = updateFeature;
        }

        @Override
        public boolean mustBeSaved() {
            return this.updateFeature.getUpdateTargetType() == UpdateTargetType.TASK_ID;
        }
    }

    public static class UpdateTypeFeature
    extends EnumFeature<UpdateType> {
        public static String FEATURE_NAME = "updateType";

        public UpdateTypeFeature() {
            super(UpdateType.class, FEATURE_NAME, null, null, UpdateType.DEFAULT);
        }
    }

    public static class UpdateTargetTypeFeature
    extends EnumFeature<UpdateTargetType> {
        public static String FEATURE_NAME = "updateTargetType";

        public UpdateTargetTypeFeature() {
            super(UpdateTargetType.class, FEATURE_NAME, null, null, UpdateTargetType.DEFAULT);
        }
    }

    public static class TargetUserTaskFeature
    extends StringFeature {
        private UpdateFeature updateFeature;
        public static String FEATURE_NAME = "targetUserTask";

        private TargetUserTaskFeature(@NotNull UpdateFeature updateFeature) {
            super(FEATURE_NAME, null, null, "");
            this.updateFeature = updateFeature;
        }

        @Override
        public boolean mustBeSaved() {
            return this.updateFeature.getUpdateTargetType() == UpdateTargetType.USER_TASK;
        }
    }
}

