/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.Map;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.resources.Msg;

public abstract class PersistentFeature<T>
extends Feature<T> {
    public PersistentFeature(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
    }

    public abstract void setValue(T var1);

    public boolean isPublic() {
        return true;
    }

    public void setValue(String value) {
    }

    public void fill(Map<String, Object> propertiesFor) {
        Object value = propertiesFor.get(this.getName());
        if (value != null) {
            this.setObjectValue(value);
        }
    }

    public void copyFrom(Feature<? extends T> feature) {
        this.setValue(feature.getValue());
    }

    public boolean mustBeSaved() {
        return true;
    }

    public boolean throwEvent() {
        return true;
    }

    protected final void setObjectValue(Object value) {
        this.setValue(value instanceof String ? (String)value : "");
    }
}

