/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.Nullable;

public abstract class FeatureSet
extends PersistentFeature<Object> {
    private Collection<Feature> features;
    private Iterable<PersistentFeature> publicFeaturesIterable;

    protected FeatureSet(String featureName, Msg label, Msg description) {
        super(featureName, label, description);
    }

    @Override
    public void addModificationListener(ModificationListener<Feature> listener) {
        super.addModificationListener(listener);
        for (Feature feature : this.getInternalSet()) {
            if (!(feature instanceof PersistentFeature)) continue;
            PersistentFeature persistentFeature = (PersistentFeature)feature;
            persistentFeature.addModificationListener(listener);
        }
    }

    @Override
    public void removeModificationListener(ModificationListener<Feature> listener) {
        super.removeModificationListener(listener);
        for (Feature feature : this.getInternalSet()) {
            if (!(feature instanceof PersistentFeature)) continue;
            PersistentFeature persistentFeature = (PersistentFeature)feature;
            persistentFeature.removeModificationListener(listener);
        }
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Object getPrevValue() {
        return null;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyFrom(Feature feature) {
        if (!feature.isSet()) {
            return;
        }
        FeatureSet set = (FeatureSet)feature;
        for (Feature sourceInnerFeature : set.getInternalSet()) {
            Object targetInnerFeature = this.getFeature(sourceInnerFeature.getClass());
            if (!(targetInnerFeature instanceof PersistentFeature)) continue;
            PersistentFeature persistentFeature = (PersistentFeature)targetInnerFeature;
            persistentFeature.copyFrom(sourceInnerFeature);
        }
    }

    @Override
    public void check(ProjectMessageListener listener) {
        for (Feature feature : this.getInternalSet()) {
            feature.check(listener);
        }
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public void fill(Map<String, Object> propertiesFor) {
        for (Feature feature : this.getInternalSet()) {
            if (!(feature instanceof PersistentFeature)) continue;
            PersistentFeature persistentFeature = (PersistentFeature)feature;
            persistentFeature.fill(propertiesFor);
        }
    }

    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.getInternalSet());
    }

    public Iterable<PersistentFeature> publicFeatures() {
        if (this.publicFeaturesIterable == null) {
            this.publicFeaturesIterable = CollectionUtils.select((Iterable)CollectionUtils.selectInstanceOf(this.getInternalSet(), PersistentFeature.class), (Predicate)new Predicate<PersistentFeature>(){

                public boolean check(@Nullable PersistentFeature value) {
                    return value != null && value.isPublic();
                }
            });
        }
        return this.publicFeaturesIterable;
    }

    public <T extends Feature> T getFeature(Class<T> aClass) {
        Feature result = null;
        for (Feature feature : this.getInternalSet()) {
            FeatureSet featureSet;
            if (feature.getClass() == aClass) {
                result = (Feature)aClass.cast(feature);
                break;
            }
            if (!(feature instanceof FeatureSet) || (result = (featureSet = (FeatureSet)feature).getFeature(aClass)) == null) continue;
            break;
        }
        return (T)result;
    }

    public void addFeature(Feature feature) {
        assert (feature != null) : "Feature should not be null";
        if (this.containsFeature(feature.getName())) {
            throw new IllegalArgumentException("Feature already exists " + feature);
        }
        this.getInternalSet().add(feature);
    }

    public void removeFeature(Feature feature) {
        this.getInternalSet().remove(feature);
    }

    public <T extends Feature> T find(Class<T> clazz) {
        Feature result = null;
        for (Feature feature : this.getInternalSet()) {
            FeatureSet set;
            if (clazz.isInstance(feature)) {
                result = (Feature)clazz.cast(feature);
                break;
            }
            if (!(feature instanceof FeatureSet) || (result = (set = (FeatureSet)feature).find(clazz)) == null) continue;
            break;
        }
        return (T)result;
    }

    public Feature findByName(String featureName) {
        Feature result = null;
        for (Feature feature : this.getInternalSet()) {
            FeatureSet set;
            if (feature.getName().equals(featureName)) {
                result = feature;
                break;
            }
            if (!(feature instanceof FeatureSet) || (result = (set = (FeatureSet)feature).findByName(featureName)) == null) continue;
            break;
        }
        return result;
    }

    public <T extends Feature> T findExact(Class<T> clazz) {
        Feature result = null;
        for (Feature feature : this.getInternalSet()) {
            FeatureSet set;
            if (feature.getClass() == clazz) {
                result = (Feature)clazz.cast(feature);
                break;
            }
            if (!(feature instanceof FeatureSet) || (result = (set = (FeatureSet)feature).findExact(clazz)) == null) continue;
            break;
        }
        return (T)result;
    }

    protected void reportError(ProjectMessageListener listener, ProjectObject object, ProjectException exception) throws ProjectException {
        if (listener == null) {
            throw exception;
        }
        listener.reportError(object, exception);
    }

    protected void reportWarning(ProjectMessageListener listener, ProjectObject object, ProjectException exception) throws ProjectException {
        if (listener == null) {
            Log.logWarning((Throwable)((Object)exception));
        } else {
            listener.reportWarning(object, exception);
        }
    }

    private boolean containsFeature(String featureName) {
        for (Feature feature : this.getInternalSet()) {
            if (!feature.getName().equals(featureName)) continue;
            return true;
        }
        return false;
    }

    private Collection<Feature> getInternalSet() {
        if (this.features == null) {
            this.features = new ArrayList<Feature>();
        }
        return this.features;
    }
}

