/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.processes.ArgumentsEnabled;
import org.jetbrains.annotations.NotNull;

public abstract class ArgumentsFeature
extends FeatureSet {
    private CustomArgumentsContainerFeature customArgumentsContainerFeature;

    protected ArgumentsFeature(String featureName, @NotNull ArgumentsEnabled argumentsEnabled) {
        super(featureName, null, null);
        this.customArgumentsContainerFeature = new CustomArgumentsContainerFeature(argumentsEnabled);
        this.addFeature(this.customArgumentsContainerFeature);
    }

    public boolean canDefineCustomArguments() {
        return this.customArgumentsContainerFeature != null;
    }

    public DataDeclarationContainer getCustomArgumentsContainer() {
        DataDeclarationContainer result = null;
        if (this.canDefineCustomArguments()) {
            result = this.customArgumentsContainerFeature.getValue();
        }
        return result;
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof ArgumentsFeature) {
            ArgumentsFeature source = (ArgumentsFeature)feature;
            if (this.canDefineCustomArguments() && source.canDefineCustomArguments()) {
                try {
                    this.getCustomArgumentsContainer().clearDeclarations();
                    for (DataDeclaration argument : source.getCustomArgumentsContainer().getLocalDeclarations()) {
                        DataDeclaration newArg = this.getCustomArgumentsContainer().createDeclaration(argument.getName(), argument.getType());
                        this.getCustomArgumentsContainer().addDeclaration(newArg);
                    }
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    abstract String getArgumentsId();

    private class CustomArgumentsContainerFeature
    extends Feature<DataDeclarationContainer> {
        private DataDeclarationContainer argumentsContainer;
        private ArgumentsEnabled argumentsEnabled;

        private CustomArgumentsContainerFeature(ArgumentsEnabled argumentsEnabled) {
            super("customArgumentsContainer", null, null);
            this.argumentsEnabled = argumentsEnabled;
        }

        @Override
        public DataDeclarationContainer getValue() {
            if (this.argumentsContainer == null) {
                this.argumentsContainer = this.argumentsEnabled.createArgumentsContainer();
                this.argumentsContainer.setId(ArgumentsFeature.this.getArgumentsId());
            }
            return this.argumentsContainer;
        }

        public void setValue(DataDeclarationContainer argumentsContainer) {
            this.argumentsContainer = argumentsContainer;
        }

        @Override
        public DataDeclarationContainer getPrevValue() {
            return null;
        }
    }
}

