/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.PersistentFeature;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractServicePropertySetFeature
extends PersistentFeature<ServicePropertySet> {
    ServicePropertiesEnabled servicePropertiesEnabled;
    ServicePropertySet servicePropertySet;

    protected AbstractServicePropertySetFeature(@NotNull String name, @NotNull ServicePropertiesEnabled servicePropertiesEnabled) {
        super(name, null, null);
        this.servicePropertiesEnabled = servicePropertiesEnabled;
    }

    @Override
    public ServicePropertySet getValue() {
        if (this.servicePropertySet == null) {
            this.servicePropertySet = this.servicePropertiesEnabled.createServicePropertySet(this.isInputServicePropertySetFeature());
        }
        return this.servicePropertySet;
    }

    @Override
    public void setValue(ServicePropertySet set) {
        this.servicePropertySet = set;
    }

    @Override
    public ServicePropertySet getPrevValue() {
        return null;
    }

    @Override
    public boolean mustBeSaved() {
        return false;
    }

    @Override
    public void copyFrom(Feature<? extends ServicePropertySet> feature) {
        this.getValue().clearServiceProperties();
        for (ServiceProperty copyServiceProperty : feature.getValue().getServiceProperties()) {
            ServiceProperty newProperty = this.getValue().createServiceProperty(copyServiceProperty.getName(), copyServiceProperty.getExpression());
            this.getValue().addServiceProperty(newProperty);
        }
    }

    protected abstract boolean isInputServicePropertySetFeature();
}

