/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.features;

import oracle.bpm.project.model.features.BooleanFeature;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.FeatureSet;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataAssociationFeature
extends FeatureSet {
    private DataAssociationEnabled dataAssociationEnabled;
    private DataAssociationSet dataAssociationSet;
    private DataAssociationSet draftDataAssociationSet;
    private boolean input;
    private BooleanFeature validationFeature;

    protected AbstractDataAssociationFeature(@NotNull String featureName, @NotNull DataAssociationEnabled dataAssociationEnabled, boolean input) {
        super(featureName, null, null);
        this.dataAssociationEnabled = dataAssociationEnabled;
        this.input = input;
        this.validationFeature = this.createValidationFeature();
        this.addFeature(this.validationFeature);
    }

    public DataAssociationSet getDataAssociationSet(boolean draft) {
        return draft ? this.getDraftDataAssociationSet() : this.getNonDraftDataAssociationSet();
    }

    @Override
    public void copyFrom(Feature feature) {
        super.copyFrom(feature);
        if (feature instanceof AbstractDataAssociationFeature) {
            AbstractDataAssociationFeature sourceFeature = (AbstractDataAssociationFeature)feature;
            this.copySetFeature(sourceFeature, this, true);
            this.copySetFeature(sourceFeature, this, false);
        }
    }

    public boolean isValidating() {
        return this.validationFeature.getValue();
    }

    public void setValidating(boolean value) {
        this.validationFeature.setValue(value);
    }

    protected abstract BooleanFeature createValidationFeature();

    private DataAssociationSet getDraftDataAssociationSet() {
        if (this.draftDataAssociationSet == null && this.dataAssociationEnabled.isDraftable()) {
            this.draftDataAssociationSet = this.createDataAssociationSet();
        }
        return this.draftDataAssociationSet;
    }

    private DataAssociationSet getNonDraftDataAssociationSet() {
        if (this.dataAssociationSet == null) {
            this.dataAssociationSet = this.createDataAssociationSet();
        }
        return this.dataAssociationSet;
    }

    private void copySetFeature(@NotNull AbstractDataAssociationFeature sourceFeature, @NotNull AbstractDataAssociationFeature targetFeature, boolean draft) {
        DataAssociationSet sourceDataAssociationSet = sourceFeature.getDataAssociationSet(draft);
        DataAssociationSet targetDataAssociationSet = targetFeature.getDataAssociationSet(draft);
        if (sourceDataAssociationSet != null && targetDataAssociationSet != null) {
            this.copySet(sourceDataAssociationSet, targetDataAssociationSet);
        }
    }

    private void copySet(@NotNull DataAssociationSet sourceDataAssociationSet, @NotNull DataAssociationSet targetDataAssociationSet) {
        targetDataAssociationSet.clearDataAssociations();
        for (DataAssociation dataAssociation : sourceDataAssociationSet.getDataAssociations()) {
            DataAssociation newDataAssociation = null;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = dataAssociation.as(DataAssignment.class);
                DataAssignment newDataAssignment = targetDataAssociationSet.createDataAssignment(dataAssignment.getSource().getExpression(), dataAssignment.getTarget().getExpression());
                newDataAssignment.setOperation(dataAssignment.getOperation());
                newDataAssociation = newDataAssignment;
            } else if (dataAssociation.isDataTransformation()) {
                DataTransformation dataTransformation = dataAssociation.as(DataTransformation.class);
                newDataAssociation = targetDataAssociationSet.createDataTransformation(dataTransformation.getSourceRefs(), dataTransformation.getTargetRef(), dataTransformation.getTransformationName());
            }
            if (newDataAssociation == null) continue;
            targetDataAssociationSet.addDataAssociation(newDataAssociation);
        }
    }

    private DataAssociationSet createDataAssociationSet() {
        return this.dataAssociationEnabled.createDataAssociationSet(this.input);
    }
}

