/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.events;

import oracle.bpm.lang.Any;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.PropertyNames;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import org.jetbrains.annotations.NotNull;

public abstract class ProjectEvent<E extends ProjectObject>
implements PropertyNames {
    private int hashCode = -1;
    private ProjectObject parent;
    private E projectObject;

    public ProjectEvent(E projectObject) {
        this(projectObject, projectObject.getParentObject());
    }

    public ProjectEvent(E projectObject, ProjectObject parent) {
        this.projectObject = projectObject;
        this.parent = parent;
    }

    @NotNull
    public abstract Type getType();

    public static ProjectEvent<ProjectObject> CHANGE(ProjectObject projectObject) {
        return new Change<ProjectObject>(projectObject);
    }

    public static ProjectEvent<ProjectObject> CHANGE(ProjectObject projectObject, Feature<Object> feature) {
        return new Change<ProjectObject>(projectObject, feature);
    }

    public static ProjectEvent<ProjectObject> CHANGE(ProjectObject projectObject, String propertyName, Object oldValue, Object newValue) {
        return new Change<ProjectObject>(projectObject, propertyName, oldValue, newValue);
    }

    public static ProjectEvent<ProjectObject> REPLACE(ProjectObject oldObject, ProjectObject newObject) {
        return new Replace<ProjectObject>(oldObject, newObject);
    }

    public static ProjectEvent<ProjectObject> POST_REMOVE(ProjectObject object, ProjectObject parent) {
        return new PostRemove<ProjectObject>(object, parent);
    }

    public static ProjectEvent<ProjectObject> POST_ADD(ProjectObject object, ProjectObject parent) {
        return new PostAdd<ProjectObject>(object, parent);
    }

    public static ProjectEvent<ProjectObject> PRE_REMOVE(ProjectObject object, ProjectObject parent) {
        return new PreRemove<ProjectObject>(object, parent);
    }

    public static ProjectEvent<ProjectObject> PRE_ADD(ProjectObject object, ProjectObject parent) {
        return new PreAdd<ProjectObject>(object, parent);
    }

    public final void replay(ProjectListener listener) throws ProjectException {
        if (this.isSupported(listener)) {
            try {
                this.replayImpl(listener);
            }
            catch (Throwable unexpected) {
                unexpected.printStackTrace();
                Log.logSevere((Throwable)unexpected);
            }
        }
    }

    public Feature<Object> getFeature() {
        return null;
    }

    public E getProjectObject() {
        return this.projectObject;
    }

    public E getReplacement() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public Object getOldValue() {
        return null;
    }

    public Object getNewValue() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProjectEvent)) {
            return false;
        }
        ProjectEvent event = (ProjectEvent)other;
        return Any.equals((Object)((Object)this.getType()), (Object)((Object)event.getType())) && Any.equals(this.getProjectObject(), event.getProjectObject()) && Any.equals((Object)this.getPropertyName(), (Object)event.getPropertyName()) && Any.equals((Object)this.getNewValue(), (Object)event.getNewValue()) && Any.equals((Object)this.getOldValue(), (Object)event.getOldValue());
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int value = this.getType().hashCode();
            value = 31 * value + (this.getPropertyName() != null ? this.getPropertyName().hashCode() : 0);
            try {
                value = 31 * value + (this.getProjectObject() != null ? this.getProjectObject().hashCode() : 0);
            }
            catch (Exception unexpected) {
                Log.logSevere((Throwable)unexpected);
            }
            this.hashCode = value;
        }
        return this.hashCode;
    }

    public String toString() {
        return "Project Event(" + (Object)((Object)this.getType()) + ", source: " + this.getProjectObject() + " property: " + this.getPropertyName() + " oldValue: " + this.getOldValue() + " newValue: " + this.getNewValue() + ")";
    }

    public ProjectObject getParent() {
        return this.parent;
    }

    protected boolean isSupported(ProjectListener listener) {
        return listener.getSupportedTypes().isAssignableFrom(this.getProjectObject().getClass());
    }

    protected void replayImpl(ProjectListener listener) throws ProjectException {
    }

    static class Replace<E extends ProjectObject>
    extends ProjectEvent<E> {
        private E replacement;

        public Replace(E projectObject, E replacement) {
            super(projectObject);
            this.replacement = replacement;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.REPLACE;
        }

        @Override
        public E getReplacement() {
            return this.replacement;
        }

        @Override
        public void replayImpl(ProjectListener listener) throws ProjectException {
            listener.objectReplaced(this.getProjectObject(), this.getReplacement());
        }
    }

    static class PreRemove<E extends ProjectObject>
    extends ProjectEvent<E> {
        public PreRemove(E projectObject, ProjectObject parent) {
            super(projectObject, parent);
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.PRE_REMOVE;
        }

        @Override
        public void replayImpl(ProjectListener listener) throws ProjectException {
            listener.preObjectRemoved(this.getProjectObject(), this.getParent());
        }
    }

    static class PreAdd<E extends ProjectObject>
    extends ProjectEvent<E> {
        public PreAdd(E projectObject, ProjectObject parent) {
            super(projectObject, parent);
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.PRE_ADD;
        }

        @Override
        public void replayImpl(ProjectListener listener) throws ProjectException {
            listener.preObjectAdded(this.getProjectObject(), this.getParent());
        }
    }

    static class PostRemove<E extends ProjectObject>
    extends ProjectEvent<E> {
        public PostRemove(E projectObject, ProjectObject parent) {
            super(projectObject, parent);
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.POST_REMOVE;
        }

        @Override
        public void replayImpl(ProjectListener listener) throws ProjectException {
            listener.postObjectRemoved(this.getProjectObject(), this.getParent());
        }
    }

    static class PostAdd<E extends ProjectObject>
    extends ProjectEvent<E> {
        public PostAdd(E projectObject, ProjectObject parent) {
            super(projectObject, parent);
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.POST_ADD;
        }

        @Override
        public void replayImpl(ProjectListener listener) throws ProjectException {
            listener.postObjectAdded(this.getProjectObject(), this.getParent());
        }
    }

    static class Change<E extends ProjectObject>
    extends ProjectEvent<E> {
        private Feature<Object> feature;
        private Object newValue;
        private Object oldValue;
        private String propertyName;

        public Change(E projectObject) {
            super(projectObject);
        }

        public Change(E projectObject, Feature<Object> feature) {
            this(projectObject, feature.getName(), null, feature.getValue());
            this.feature = feature;
        }

        public Change(E projectObject, String propertyName, Object oldValue, Object newValue) {
            super(projectObject);
            this.propertyName = propertyName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        @NotNull
        public Type getType() {
            return Type.CHANGE;
        }

        @Override
        public Feature<Object> getFeature() {
            return this.feature;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public Object getOldValue() {
            return this.oldValue;
        }

        @Override
        public Object getNewValue() {
            return this.newValue;
        }

        @Override
        public void replayImpl(ProjectListener listener) {
            listener.objectChanged(this.getProjectObject(), this);
        }
    }

    public static enum Type {
        CHANGE,
        PRE_ADD,
        PRE_REMOVE,
        POST_ADD,
        POST_REMOVE,
        REPLACE;

    }
}

