/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model.casemgmt;

import javax.xml.namespace.QName;
import oracle.bpm.casemgmt.model.DataType;
import oracle.bpm.casemgmt.model.PropertyBundle;
import oracle.bpm.casemgmt.model.cm.CaseFactory;
import oracle.bpm.casemgmt.model.cm.Data;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeToXsdMapping;
import oracle.bpm.util.Identifier;

public class CaseManagementUtils {
    private CaseManagementUtils() {
    }

    public static String getDisplayName(PropertyBundle bundle, String name) {
        String value = bundle != null ? (String)bundle.get((Object)name) : null;
        return Str.isEmpty((String)value) ? "[" + name + "]" : value;
    }

    public static boolean isMatchingData(Data data, CatalogType type) {
        boolean result = data.getDataType().isSimpleType() ? CaseManagementUtils.isCaseDataTypeAssignable(data, type) : CaseManagementUtils.isCaseDataTypeEquivalent(data, type);
        return result;
    }

    public static boolean isCaseDataTypeEquivalent(Data data, CatalogType type) {
        QName qName;
        boolean result = false;
        SchemaObject schemaObject = CaseManagementUtils.getSchemaObject(type);
        if (schemaObject != null && (qName = schemaObject.getQName()) != null && qName.toString().equals(data.getType())) {
            DataType dataType = data.getDataType();
            if (schemaObject.isBasicType() && dataType.isSimpleType() || schemaObject.isElement() && dataType.isElement() || schemaObject.isType() && dataType.isComplexType()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isCaseDataTypeAssignable(Data data, CatalogType type) {
        boolean result = false;
        CatalogType catalogType = CaseManagementUtils.getCatalogTypeFromSimpleDataType(data);
        if (catalogType != null) {
            boolean b1 = catalogType.isAssignableFrom(type);
            boolean b2 = type.isAssignableFrom(catalogType);
            result = b1 && b2;
        }
        return result;
    }

    public static CatalogType getCatalogTypeFromSimpleDataType(Data data) {
        String sQName;
        CatalogType result = null;
        if (data.getDataType().isSimpleType() && !Str.isEmpty((String)(sQName = data.getType()))) {
            try {
                QName qName = QName.valueOf(sQName);
                String localPart = qName.getLocalPart();
                TypeDescription typeDescription = (TypeDescription)TypeToXsdMapping.getXsdToType().get(localPart);
                if (typeDescription != null) {
                    result = CatalogType.Default.get((TypeRef)typeDescription);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static HumanTask getHumanTask(Project project, String referenceId) {
        HumanTask result = null;
        String normalizedName = Identifier.classname((String)referenceId);
        String humanTaskCatalogId = "HumanTasks." + normalizedName;
        try {
            CatalogObject catalogObject = project.findCatalogObject(humanTaskCatalogId);
            if (catalogObject != null && catalogObject.isHumanTask()) {
                result = catalogObject.asHumanTask();
            }
        }
        catch (AmbiguousTypeNameException e) {
            // empty catch block
        }
        return result;
    }

    public static Data createData(CatalogType type) {
        Data result = CaseFactory.createData();
        if (type != null && type.getDelegate().isSchemaObject()) {
            SchemaObject schemaObject = type.getDelegate().asSchemaObject();
            result.setName(schemaObject.getName());
            if (schemaObject.isBasicType()) {
                result.setDataType(DataType.SIMPLE_TYPE);
            } else if (schemaObject.isElement()) {
                result.setDataType(DataType.ELEMENT);
            } else {
                result.setDataType(DataType.COMPLEX_TYPE);
            }
            QName qName = schemaObject.getQName();
            if (qName != null) {
                result.setType(qName.toString());
            }
            try {
                String schema = schemaObject.getLocation();
                if (schema != null) {
                    if (schema.startsWith("/") && schema.length() > 1) {
                        schema = schema.substring(1);
                    }
                    result.setSchema(schema);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private static SchemaObject getSchemaObject(CatalogType type) {
        SchemaObject result = null;
        if (type.getDelegate().isSchemaObject()) {
            result = type.getDelegate().asSchemaObject();
        }
        return result;
    }
}

