/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bpm.observers.Observable;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryChangeEvent;
import oracle.bpm.project.model.RepositoryServiceListener;

public class RepositoryService
implements Observable<RepositoryServiceListener> {
    private ProjectRepository defaultRepository;
    private Collection<RepositoryServiceListener> listeners = new ArrayList<RepositoryServiceListener>();
    private static RepositoryService repositoryService;

    private RepositoryService() {
    }

    public static synchronized RepositoryService getInstance() {
        if (repositoryService == null) {
            repositoryService = new RepositoryService();
        }
        return repositoryService;
    }

    public ProjectRepository getActiveRepository() {
        return this.defaultRepository;
    }

    public void setActiveRepository(ProjectRepository repository) {
        RepositoryChangeEvent event = RepositoryChangeEvent.create(this.defaultRepository, repository);
        this.defaultRepository = repository;
        this.fireRepositoryChanged(event);
    }

    public void repositoryRemoved(ProjectRepository repository) {
        if (this.defaultRepository == repository) {
            this.setActiveRepository(null);
        }
    }

    public void addObserver(RepositoryServiceListener observer) {
        this.listeners.add(observer);
    }

    public void removeObserver(RepositoryServiceListener observer) {
        this.listeners.remove(observer);
    }

    private void fireRepositoryChanged(RepositoryChangeEvent event) {
        for (RepositoryServiceListener listener : this.listeners) {
            listener.repositoryChanged(event);
        }
    }
}

