/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.io.IOException;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Week;
import oracle.bpm.project.model.ProjectVisitor;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleEntryField;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.xml.XmlTag;
import oracle.bpm.xml.XmlWriter;

public class MonthlySchedule
extends ScheduleEntry {
    private int dayOfMonth;
    private Day dayOfWeek;
    private Month month;
    private Week week;
    protected static final ScheduleEntryField[] monthlyFields = new ScheduleEntryField[]{ScheduleEntryField.MONTH, ScheduleEntryField.WEEK, ScheduleEntryField.DAY};
    protected static final int fieldCount = monthlyFields.length;

    protected MonthlySchedule(Month month, int dayOfMonth, Interval when) {
        this(month, when);
        this.dayOfMonth = dayOfMonth;
    }

    protected MonthlySchedule(Month month, Week week, Day dayOfWeek, Interval when) {
        this(month, when);
        if (week == null) {
            throw new NullPointerException("week");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("dayOfWeek");
        }
        this.week = week;
        this.dayOfWeek = dayOfWeek;
    }

    private MonthlySchedule(Month month, Interval when) {
        super(when);
        this.month = month;
        this.week = null;
        this.dayOfMonth = 0;
        this.dayOfWeek = Day.MONDAY;
    }

    public static MonthlySchedule create() {
        return new MonthlySchedule(null, 1, Interval.ZERO);
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfWeek(Day dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dayOfWeek");
        }
        this.dayOfWeek = dayOfWeek;
    }

    public Day getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public ScheduleEntryField getField(int i) {
        return i < fieldCount ? monthlyFields[i] : super.getField(i - fieldCount);
    }

    @Override
    public Class getFieldClass(int i) {
        return i == 0 ? Month.class : (i == 1 ? Week.class : (i == 2 ? Day.class : super.getFieldClass(i - fieldCount)));
    }

    @Override
    public int getFieldCount() {
        return monthlyFields.length + super.getFieldCount();
    }

    @Override
    public void setFieldValue(int i, Object o) {
        if (i == 0) {
            this.month = (Month)o;
        } else if (i == 1) {
            this.week = (Week)o;
        } else if (i != 2) {
            super.setFieldValue(i - fieldCount, o);
        } else if (this.week == null) {
            this.dayOfMonth = o instanceof String ? Integer.parseInt((String)o) : ((Number)o).intValue();
        } else {
            this.dayOfWeek = o instanceof Integer ? Day.values()[(Integer)o] : (Day)o;
        }
    }

    @Override
    public Object getFieldValue(int i) {
        return i == 0 ? this.month : (i == 1 ? this.week : (i != 2 ? super.getFieldValue(i - fieldCount) : (this.week == null ? Integer.valueOf(this.dayOfMonth) : this.dayOfWeek)));
    }

    public void setMonth(Month month) {
        this.month = month;
    }

    public Month getMonth() {
        return this.month;
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.MONTHLY;
    }

    public void setWeek(Week week) {
        if (week == null) {
            throw new NullPointerException("week");
        }
        this.week = week;
    }

    public Week getWeek() {
        return this.week;
    }

    public Time nextDueTime(Time base) {
        Time dueTime = this.establishWhen(base);
        if (this.week == null) {
            dueTime = dueTime.addDays(this.dayOfMonth - base.getDay());
        }
        if (this.month != null) {
            dueTime = Time.month((Time)dueTime, (int)this.month.intValue());
            if (this.month.intValue() > base.getMonth()) {
                dueTime = dueTime.addYears(1);
            }
        } else if (base.compareTo(dueTime) > 0) {
            dueTime = dueTime.addMonths(1);
        }
        if (this.week != null) {
            dueTime = this.calculateDayInWeek(dueTime);
        } else if (base.compareTo(dueTime) > 0) {
            dueTime = dueTime.addYears(1);
        }
        return dueTime;
    }

    @Override
    public void revalidate() {
        if (this.week == null) {
            if (this.dayOfMonth <= 1 || this.dayOfMonth > 31 || this.month != null && this.dayOfMonth > this.month.days(2000)) {
                this.dayOfMonth = 1;
            }
            this.dayOfWeek = null;
        } else {
            this.dayOfMonth = 0;
            if (this.dayOfWeek == null) {
                this.dayOfWeek = Day.MONDAY;
            }
        }
    }

    @Override
    public void visit(ProjectVisitor visitor) throws ProjectException {
        visitor.visit(this);
    }

    @Override
    public void writeFieldsToXml(XmlWriter xml) throws IOException {
        xml.printAttribute(ScheduleEntryField.MONTH.getAttributeName(), (Enum)this.month);
        if (this.week == null) {
            xml.printAttribute(ScheduleEntryField.DAY.getAttributeName(), this.dayOfMonth);
        } else {
            xml.printAttribute(ScheduleEntryField.WEEK.getAttributeName(), (Enum)this.week);
            xml.printAttribute(ScheduleEntryField.DAY.getAttributeName(), (Enum)this.dayOfWeek);
        }
        super.writeFieldsToXml(xml);
    }

    public boolean check() {
        return this.dayOfMonth > 0 && this.dayOfMonth <= 31 && (this.month == null || this.dayOfMonth <= this.month.days(2000));
    }

    public void setForceWeek(Week week) {
        this.week = week;
    }

    public Week getForceWeek() {
        return this.getWeek();
    }

    protected Time calculateDayInWeek(Time seedDay) {
        Time referenceDay;
        int weekNumber = 0;
        if (this.week == Week.LAST) {
            referenceDay = seedDay.getLastDayOfMonth();
        } else {
            referenceDay = seedDay.getFirstDayOfMonth();
            weekNumber = this.week.intValue();
        }
        Time dueTime = referenceDay.next(this.dayOfWeek).addWeeks(weekNumber - 1);
        if (Time.now().compareTo(dueTime) > 0) {
            dueTime = this.month == null ? dueTime.addMonths(1) : dueTime.addYears(1);
            dueTime = this.calculateDayInWeek(dueTime);
        }
        return dueTime;
    }

    @Override
    protected int compareFields(ScheduleEntry o) {
        MonthlySchedule that = (MonthlySchedule)o;
        int result = this.month == that.month ? 0 : (this.month == null ? -1 : (that.month == null ? 1 : this.month.compareTo((Enum)that.month)));
        if (result == 0) {
            int n = this.week == that.week ? 0 : (result = this.week == null ? -1 : this.week.compareTo((Enum)that.week));
            if (result == 0) {
                int n2 = this.dayOfWeek == that.dayOfWeek ? 0 : (result = this.dayOfWeek == null ? -1 : this.dayOfWeek.compareTo((Enum)that.dayOfWeek));
                if (result == 0 && (result = this.dayOfMonth - that.dayOfMonth) == 0) {
                    result = super.compareFields(that);
                }
            }
        }
        return result;
    }

    @Override
    protected boolean equalsFields(ScheduleEntry o) {
        MonthlySchedule that = (MonthlySchedule)o;
        return this.month == that.month && this.dayOfMonth == that.dayOfMonth && this.week == that.week && this.dayOfWeek == that.dayOfWeek && super.equalsFields(that);
    }

    @Override
    protected void parse(XmlTag tag) {
        String monthStr = tag.getAttribute(ScheduleEntryField.MONTH.getAttributeName());
        this.month = monthStr == null ? null : Month.valueOf((String)monthStr.toUpperCase());
        String weekStr = tag.getAttribute(ScheduleEntryField.WEEK.getAttributeName());
        if (weekStr == null) {
            this.dayOfMonth = tag.getInteger(ScheduleEntryField.DAY.getAttributeName());
            this.week = null;
            this.dayOfWeek = null;
        } else {
            this.week = Week.valueOf((String)weekStr.toUpperCase());
            String dayStr = tag.getAttribute(ScheduleEntryField.DAY.getAttributeName());
            this.dayOfWeek = dayStr == null ? null : Day.valueOf((String)dayStr.toUpperCase());
            this.dayOfMonth = 0;
        }
        super.parse(tag);
    }
}

