/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lang.Any;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.ProjectObject;

public class ModificationAwareLocaleStringMap
extends LocaleStringMap {
    private transient Collection<ModificationListener<ProjectObject>> listeners = new ArrayList<ModificationListener<ProjectObject>>();
    private transient ProjectObject object;
    private static final long serialVersionUID = 8634791279710573069L;

    public ModificationAwareLocaleStringMap(ProjectObject object) {
        this.object = object;
    }

    public static ModificationAwareLocaleStringMap create(ProjectObject object) {
        return new ModificationAwareLocaleStringMap(object);
    }

    public void addModificationListener(ModificationListener<ProjectObject> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String remove(Locale locale) {
        String s = super.remove(locale);
        this.fireModified(this.object, s, null);
        return s;
    }

    public String put(Locale locale, String text) {
        String oldValue = super.put(locale, text);
        if (!Any.equals((Object)oldValue, (Object)text)) {
            this.fireModified(this.object, oldValue, text);
        }
        return oldValue;
    }

    public void putAll(LocaleStringMap label) {
        super.putAll(label);
        this.fireModified(this.object, null, null);
    }

    public void replaceValues(LocaleStringMap label) {
        this.clear();
        super.putAll(label);
    }

    public void removeModificationListener(ModificationListener listener) {
        this.listeners.remove(listener);
    }

    public LocaleStringMap clone() {
        ModificationAwareLocaleStringMap stringMap = (ModificationAwareLocaleStringMap)super.clone();
        stringMap.listeners.clear();
        return stringMap;
    }

    private void fireModified(ProjectObject source, Object prevValue, Object value) {
        for (ModificationListener<ProjectObject> listener : this.listeners) {
            try {
                listener.objectModified(new ModificationEvent((Object)source, prevValue, value));
            }
            catch (Exception e) {
                Log.logWarning((Throwable)e);
            }
        }
    }
}

