/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.EditableView;
import fuego.papi.ProcessServiceSession;
import fuego.papi.ViewType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import oracle.bpel.services.workflow.user.model.UserViewDetail;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.Constants;
import oracle.bpm.papi.ora.view.ActivityViewAdapter;
import oracle.bpm.papi.ora.view.ApplicationsViewAdapter;
import oracle.bpm.papi.ora.view.AttachmentsViewAdapter;
import oracle.bpm.papi.ora.view.BookmarkViewAdapter;
import oracle.bpm.papi.ora.view.ConsultationsViewAdapter;
import oracle.bpm.papi.ora.view.FolderViewAdapter;
import oracle.bpm.papi.ora.view.HistoryViewAdapter;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public abstract class ViewAdapter
implements EditableView {
    protected Collection<String> assignedProcesses;
    protected Collection<String> assignedRoles;
    protected String id;
    protected boolean isCustom;
    protected boolean isHidden;
    protected boolean isReadOnly;
    protected boolean isTransient;
    protected LocaleStringMap labels;
    protected Msg messageLabels;
    protected String ownerId;
    protected String presentationId;
    protected boolean wasStored = false;
    private static final long serialVersionUID = -860807203672673001L;
    @NonNls
    public static final String ID_SEPARATOR = "/";

    protected ViewAdapter(String id, String owner) {
        this.id = id;
        this.ownerId = owner == null ? "organization" : owner;
        this.labels = LocaleStringMap.create();
        this.assignedProcesses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.assignedRoles = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.isHidden = false;
        this.isReadOnly = true;
        this.isCustom = true;
        this.isTransient = true;
    }

    public static ViewAdapter create(ViewType viewType, String id) {
        return ViewAdapter.create(viewType, id, "organization");
    }

    public static ViewAdapter create(ViewType viewType, String id, String owner) {
        if (viewType == ViewType.APPLICATIONS) {
            return ViewAdapter.createApplicationsView(id, owner);
        }
        if (viewType == ViewType.ATTACHMENTS) {
            return ViewAdapter.createAttachmentsView(id, owner);
        }
        if (viewType == ViewType.INSTANCES) {
            return ViewAdapter.createInstancesView(id, owner);
        }
        if (viewType == ViewType.ACTIVITY_INSTANCES) {
            return ViewAdapter.createActivityView(id, null, owner);
        }
        if (viewType == ViewType.BOOKMARKS) {
            return ViewAdapter.createBookmarkView(id);
        }
        if (viewType == ViewType.CONSULTATIONS) {
            return ViewAdapter.createConsultationsView(id);
        }
        if (viewType == ViewType.HISTORY) {
            return ViewAdapter.createHistoryView(id);
        }
        if (viewType == ViewType.FOLDER) {
            return ViewAdapter.createFolderView(id, owner);
        }
        throw new IllegalArgumentException("Invalid ViewType [" + viewType + "]");
    }

    public static ActivityViewAdapter createActivityView(String id, String activity) {
        return ViewAdapter.createActivityView(id, activity, "organization");
    }

    public static ActivityViewAdapter createActivityView(String id, String activity, String owner) {
        return ActivityViewAdapter.create(id, owner, activity);
    }

    public static ApplicationsViewAdapter createApplicationsView(String id) {
        return ViewAdapter.createApplicationsView(id, "organization");
    }

    public static ApplicationsViewAdapter createApplicationsView(String id, String owner) {
        return ApplicationsViewAdapter.create(id, owner);
    }

    public static AttachmentsViewAdapter createAttachmentsView(String id) {
        return ViewAdapter.createAttachmentsView(id, "organization");
    }

    public static AttachmentsViewAdapter createAttachmentsView(String id, String owner) {
        return AttachmentsViewAdapter.create(id, owner);
    }

    public static BookmarkViewAdapter createBookmarkView(String id) {
        return new BookmarkViewAdapter(id, "organization");
    }

    public static BookmarkViewAdapter createBookmarkView(String id, String owner) {
        return new BookmarkViewAdapter(id, owner);
    }

    public static ConsultationsViewAdapter createConsultationsView(String id) {
        return ViewAdapter.createConsultationsView(id, "organization");
    }

    public static ConsultationsViewAdapter createConsultationsView(String id, String owner) {
        return ConsultationsViewAdapter.create(id, owner);
    }

    public static FolderViewAdapter createFolderView(String id) {
        return ViewAdapter.createFolderView(id, "organization");
    }

    public static FolderViewAdapter createFolderView(String id, String owner) {
        return FolderViewAdapter.create(id, owner);
    }

    public static HistoryViewAdapter createHistoryView(String id) {
        return ViewAdapter.createHistoryView(id, "organization");
    }

    public static HistoryViewAdapter createHistoryView(String id, String owner) {
        return HistoryViewAdapter.create(id, owner, Time.now(), Time.now());
    }

    public static InstancesViewAdapter createInstancesView(String id) {
        return ViewAdapter.createInstancesView(id, "organization");
    }

    public static InstancesViewAdapter createInstancesView(String id, String owner) {
        return InstancesViewAdapter.create(id, owner);
    }

    public static InstancesViewAdapter createInstancesView(ProcessServiceSession session, UserViewDetail userViewDetail) {
        return InstancesViewAdapter.create(session, userViewDetail);
    }

    public static String getParentId(String id) {
        int end = id.lastIndexOf(ID_SEPARATOR);
        if (end != -1) {
            return id.substring(0, end);
        }
        return null;
    }

    public static char[] invalidViewIdCharacters() {
        return Constants.INVALID_KEY_CHARACTERS;
    }

    public void assignProcess(String processId) {
        this.assignedProcesses.add(processId);
    }

    public void assignProcesses(String[] processIds) {
        if (processIds != null) {
            for (String element : processIds) {
                this.assignProcess(element);
            }
        }
    }

    public void assignRole(String roleId) {
        this.assignedRoles.add(roleId);
    }

    public void assignRoles(String[] roleIds) {
        this.assignedRoles.addAll(Arrays.asList(roleIds));
    }

    public void clearLabels() {
        this.messageLabels = null;
        this.labels.clear();
    }

    public ViewAdapter copy() {
        ViewAdapter copy = ViewAdapter.create(this.getType(), this.id, this.ownerId);
        copy.presentationId = this.presentationId;
        copy.assignedProcesses.addAll(this.assignedProcesses);
        copy.assignedRoles.addAll(this.assignedRoles);
        copy.isCustom = this.isCustom;
        copy.isHidden = this.isHidden;
        copy.isReadOnly = this.isReadOnly;
        copy.isTransient = true;
        copy.labels = this.labels.clone();
        copy.messageLabels = this.messageLabels;
        return copy;
    }

    public String[] getAssignedProcesses() {
        return this.assignedProcesses.toArray(new String[this.assignedProcesses.size()]);
    }

    public String[] getAssignedRoles() {
        return this.assignedRoles.toArray(new String[this.assignedRoles.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Locale locale) {
        String label = null;
        if (this.messageLabels != null) {
            if (locale != null) {
                label = this.messageLabels.getString(locale);
            }
            if (label == null || "".equals(label.trim())) {
                label = this.messageLabels.getString();
            }
        } else {
            if (locale != null) {
                label = this.labels.getString(locale);
            }
            if (label == null || "".equals(label.trim())) {
                label = this.labels.getString();
            }
        }
        if (label == null || "".equals(label.trim())) {
            label = this.id.substring(this.id.lastIndexOf(ID_SEPARATOR) + 1);
        }
        return label;
    }

    public LocaleStringMap getLabels() {
        if (this.messageLabels != null) {
            return this.messageLabels.getAllAvailableTranslationsForProjectLanguages();
        }
        return this.labels;
    }

    public String getOwner() {
        return this.ownerId;
    }

    public String getParentId() {
        return ViewAdapter.getParentId(this.id);
    }

    public String getPresentation() {
        if (this.presentationId == null) {
            this.presentationId = this.getDefaultPresentation();
        }
        return this.presentationId;
    }

    public boolean hasType(ViewType viewType) {
        return this.getType().isType(viewType);
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String removeLabel(Locale locale) {
        if (this.messageLabels != null) {
            this.labels = this.messageLabels.getAllAvailableTranslationsForProjectLanguages();
            this.messageLabels = null;
        }
        return this.labels.remove(locale);
    }

    public void setCustom(boolean isCustom) {
        this.isCustom = isCustom;
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public void setLabel(String label, Locale locale) {
        if (this.messageLabels != null) {
            this.labels = this.messageLabels.getAllAvailableTranslationsForProjectLanguages();
            this.messageLabels = null;
        }
        this.labels.put(locale, label);
    }

    public void setLabels(Msg labels) {
        this.messageLabels = labels;
    }

    public void setLabels(LocaleStringMap labels) {
        this.labels = labels == null ? LocaleStringMap.create() : labels;
        this.messageLabels = null;
    }

    public void setOwner(String owner) {
        this.ownerId = owner;
    }

    public void setPresentation(String presentationId) {
        this.presentationId = presentationId;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public String toString() {
        StringBuilder description;
        block7: {
            block6: {
                description = new StringBuilder();
                description.append("View\n");
                description.append("\tId '");
                description.append(this.id);
                description.append("'\n");
                description.append("\tType '");
                description.append(this.getType().getString());
                description.append("'\n");
                description.append("\tOwner '");
                description.append(this.ownerId);
                description.append("'\n");
                description.append("\tIs Read Only '");
                description.append(this.isReadOnly);
                description.append("'\n");
                description.append("\tIs Custom '");
                description.append(this.isCustom);
                description.append("'\n");
                description.append("\tIs Hidden '");
                description.append(this.isHidden);
                description.append("'\n");
                description.append("\tPresentation '");
                description.append(this.presentationId);
                description.append("'\n");
                description.append("\tAssigned Processes\n");
                if (this.assignedProcesses != null) {
                    for (String assignedProcess : this.assignedProcesses) {
                        description.append("\t\tProcess '");
                        description.append(assignedProcess);
                        description.append("'\n");
                    }
                }
                description.append("\tAssigned Roles\n");
                if (this.assignedRoles != null) {
                    for (String assignedRole : this.assignedRoles) {
                        description.append("\t\tRole '");
                        description.append(assignedRole);
                        description.append("'\n");
                    }
                }
                description.append("\tLabels\n");
                if (this.messageLabels == null) break block6;
                for (Map.Entry entry : this.messageLabels.getAllAvailableTranslationsForProjectLanguages().entrySet()) {
                    description.append("\t\tLabel [");
                    description.append(((Locale)entry.getKey()).getLanguage());
                    description.append("] '");
                    description.append((String)entry.getValue());
                    description.append("'\n");
                }
                break block7;
            }
            if (this.labels == null) break block7;
            for (Map.Entry entry : this.labels.entrySet()) {
                description.append("\t\tLabel [");
                description.append(((Locale)entry.getKey()).getLanguage());
                description.append("] '");
                description.append((String)entry.getValue());
                description.append("'\n");
            }
        }
        return description.toString();
    }

    public void unassignAllProcesses() {
        this.assignedProcesses.clear();
    }

    public void unassignAllRoles() {
        this.assignedRoles.clear();
    }

    public void unassignProcess(String processId) {
        this.assignedProcesses.remove(processId);
    }

    public void unassignRole(String roleId) {
        this.assignedRoles.remove(roleId);
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ViewAdapter)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        ViewAdapter otherView = (ViewAdapter)other;
        return this.id.equals(otherView.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected abstract String getDefaultPresentation();
}

