/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.Presentation;
import fuego.papi.PresentationType;
import fuego.papi.VarDefinition;
import fuego.papi.ViewType;
import oracle.bpm.papi.ora.view.PresentationAdapter;

public class PresentationAdapterUtils {
    public static final String PRESENTATION_FDI_CATEGORY = "fuego-presentations";
    private static PresentationAdapter defaultInstancesPresentation = null;
    private static PresentationAdapter defaultApplicationsPresentation = null;
    private static PresentationAdapter defaultAttachemetsPresentation = null;
    private static PresentationAdapter defaultActivityPresentation = null;
    private static PresentationAdapter defaultFolderPresentation = null;

    public static Presentation getDefaultActivityPresentation() {
        if (defaultActivityPresentation == null) {
            Presentation.Column[] defaultPresentationColumns = new Presentation.Column[6];
            int index = 0;
            for (VarDefinition variable : VarDefinition.createInstanceDefaults()) {
                if (!"PREDEFINE_DESCRIPTION".equalsIgnoreCase(variable.getId()) && !"PREDEFINE_PRIORITY".equalsIgnoreCase(variable.getId()) && !"PREDEFINE_STATUS".equalsIgnoreCase(variable.getId()) && !"PREDEFINE_RECEIVED TIME".equalsIgnoreCase(variable.getId()) && !"PREDEFINE_DEADLINE".equalsIgnoreCase(variable.getId()) && !"PREDEFINE_PARTICIPANT".equalsIgnoreCase(variable.getId())) continue;
                defaultPresentationColumns[index] = new Presentation.Column(variable);
                ++index;
            }
            defaultActivityPresentation = PresentationAdapter.create(PresentationType.INSTANCES, "default_activity", defaultPresentationColumns);
        }
        return defaultActivityPresentation.copy(defaultActivityPresentation.getId());
    }

    public static Presentation getDefaultApplicationsPresentation() {
        if (defaultApplicationsPresentation == null) {
            VarDefinition[] defaultVariables = VarDefinition.createApplicationDefaults();
            Presentation.Column[] defaultPresentationColumns = new Presentation.Column[defaultVariables.length];
            for (int i = 0; i < defaultVariables.length; ++i) {
                defaultPresentationColumns[i] = new Presentation.Column(defaultVariables[i]);
            }
            defaultApplicationsPresentation = PresentationAdapter.create(PresentationType.APPLICATIONS, "default_applications", defaultPresentationColumns);
        }
        return defaultApplicationsPresentation.copy(defaultApplicationsPresentation.getId());
    }

    public static Presentation getDefaultAttachmentsPresentation() {
        if (defaultAttachemetsPresentation == null) {
            VarDefinition[] defaultVariables = VarDefinition.createAttachmentDefaults();
            Presentation.Column[] defaultPresentationColumns = new Presentation.Column[defaultVariables.length];
            for (int i = 0; i < defaultVariables.length; ++i) {
                defaultPresentationColumns[i] = new Presentation.Column(defaultVariables[i]);
            }
            defaultAttachemetsPresentation = PresentationAdapter.create(PresentationType.ATTACHMENTS, "default_attachments", defaultPresentationColumns);
        }
        return defaultAttachemetsPresentation.copy(defaultAttachemetsPresentation.getId());
    }

    public static Presentation getDefaultFolderPresentation() {
        if (defaultFolderPresentation == null) {
            defaultFolderPresentation = PresentationAdapter.create(PresentationType.FOLDER, "default_folder", new Presentation.Column[0]);
        }
        return defaultFolderPresentation.copy(defaultFolderPresentation.getId());
    }

    public static Presentation getDefaultInstancesPresentation() {
        if (defaultInstancesPresentation == null) {
            VarDefinition[] defaultVariables = VarDefinition.createInstanceDefaults();
            Presentation.Column[] defaultPresentationColumns = new Presentation.Column[8];
            int index = 0;
            for (VarDefinition variable : defaultVariables) {
                if (!variable.getId().equalsIgnoreCase("PREDEFINE_HAS_ATTACHMENTS") && !variable.getId().equalsIgnoreCase("PREDEFINE_DESCRIPTION") && !variable.getId().equalsIgnoreCase("PREDEFINE_ACTIVITY") && !variable.getId().equalsIgnoreCase("PREDEFINE_PRIORITY") && !variable.getId().equalsIgnoreCase("PREDEFINE_STATUS") && !variable.getId().equalsIgnoreCase("PREDEFINE_RECEIVED TIME") && !variable.getId().equalsIgnoreCase("PREDEFINE_DEADLINE") && !variable.getId().equalsIgnoreCase("PREDEFINE_PARTICIPANT")) continue;
                defaultPresentationColumns[index] = new Presentation.Column(variable);
                ++index;
            }
            defaultInstancesPresentation = PresentationAdapter.create(PresentationType.INSTANCES, "default_instances", defaultPresentationColumns);
        }
        return defaultInstancesPresentation.copy(defaultInstancesPresentation.getId());
    }

    public static Presentation getDefaultPresentation(ViewType viewType) {
        if (viewType == ViewType.APPLICATIONS) {
            return PresentationAdapterUtils.getDefaultApplicationsPresentation();
        }
        if (viewType == ViewType.ATTACHMENTS) {
            return PresentationAdapterUtils.getDefaultAttachmentsPresentation();
        }
        if (viewType == ViewType.ACTIVITY_INSTANCES) {
            return PresentationAdapterUtils.getDefaultActivityPresentation();
        }
        if (viewType == ViewType.FOLDER) {
            return PresentationAdapterUtils.getDefaultFolderPresentation();
        }
        return PresentationAdapterUtils.getDefaultInstancesPresentation();
    }

    public static Presentation getDefaultPresentation(PresentationType presentationType) {
        if (presentationType == PresentationType.INSTANCES) {
            return PresentationAdapterUtils.getDefaultInstancesPresentation();
        }
        if (presentationType == PresentationType.APPLICATIONS) {
            return PresentationAdapterUtils.getDefaultApplicationsPresentation();
        }
        if (presentationType == PresentationType.ATTACHMENTS) {
            return PresentationAdapterUtils.getDefaultAttachmentsPresentation();
        }
        return PresentationAdapterUtils.getDefaultFolderPresentation();
    }

    public static Presentation[] getDefaultPresentations() {
        Presentation[] presentations = new Presentation[]{PresentationAdapterUtils.getDefaultInstancesPresentation(), PresentationAdapterUtils.getDefaultActivityPresentation(), PresentationAdapterUtils.getDefaultAttachmentsPresentation(), PresentationAdapterUtils.getDefaultApplicationsPresentation(), PresentationAdapterUtils.getDefaultFolderPresentation()};
        return presentations;
    }
}

