/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.EditablePresentation;
import fuego.papi.OperationRuntimeException;
import fuego.papi.Ordering;
import fuego.papi.Presentation;
import fuego.papi.PresentationType;
import fuego.papi.ProcessServiceSession;
import java.io.Serializable;
import oracle.bpel.services.workflow.query.model.TaskOrderingType;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpel.services.workflow.user.model.ColumnListType;
import oracle.bpel.services.workflow.user.model.Presentation;
import oracle.bpm.papi.ora.collections.PapiColumnList;
import oracle.bpm.papi.ora.collections.TaskOrdering;
import org.jetbrains.annotations.NotNull;

public class PresentationAdapter
implements Serializable,
EditablePresentation {
    private PapiColumnList columns;
    private boolean isReadOnly = false;
    private TaskOrdering ordering;
    private PresentationType type;
    private Presentation workflowPresentation;
    private static final long serialVersionUID = 20090813112700L;

    private PresentationAdapter(@NotNull ProcessServiceSession session, @NotNull Presentation workflowPresentation) {
        this.workflowPresentation = workflowPresentation;
        this.type = PresentationType.INSTANCES;
        ColumnListType columns = workflowPresentation.getColumns();
        this.columns = columns == null ? PapiColumnList.create() : PapiColumnList.create(session, columns);
        TaskOrderingType ordering = workflowPresentation.getOrdering();
        this.ordering = ordering == null ? TaskOrdering.create() : TaskOrdering.create(workflowPresentation.getOrdering());
    }

    private PresentationAdapter(@NotNull PresentationType type, @NotNull String id, @NotNull Presentation.Column[] columns, @NotNull String owner) {
        this.workflowPresentation = this.createWorkflowPresentation(id, owner);
        this.type = type;
        this.columns = PapiColumnList.create(columns);
        this.ordering = TaskOrdering.create();
    }

    public static PresentationAdapter create(PresentationType type, String id, Presentation.Column[] columns) {
        return PresentationAdapter.create(type, id, columns, "organization");
    }

    public static PresentationAdapter create(PresentationType type, String id, Presentation.Column[] columns, String owner) {
        return new PresentationAdapter(type, id, columns, owner);
    }

    public static PresentationAdapter create(ProcessServiceSession session, Presentation workflowPresentation) {
        return new PresentationAdapter(session, workflowPresentation);
    }

    public Presentation getWorkflowPresentation() {
        this.workflowPresentation.setColumns(this.columns.getBpelColumns());
        this.workflowPresentation.setOrdering(this.ordering.getBpelOrdering());
        return this.copyWorkflowPresentation(this.workflowPresentation);
    }

    public void setWorkflowPresentation(@NotNull ProcessServiceSession session, @NotNull Presentation workflowPresentation) {
        this.workflowPresentation = this.copyWorkflowPresentation(workflowPresentation);
        ColumnListType columns = workflowPresentation.getColumns();
        this.columns = columns == null ? PapiColumnList.create() : PapiColumnList.create(session, columns);
        TaskOrderingType ordering = workflowPresentation.getOrdering();
        this.ordering = ordering == null ? TaskOrdering.create() : TaskOrdering.create(workflowPresentation.getOrdering());
    }

    public void setColumns(Presentation.Column[] columns) {
        this.columns = PapiColumnList.create(columns);
    }

    public Presentation.Column[] getColumns() {
        return this.columns.getPapiColumns();
    }

    public String getId() {
        return this.workflowPresentation.getName();
    }

    public String getOwner() {
        return this.workflowPresentation.getOwner();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public PresentationType getType() {
        return this.type;
    }

    public PresentationAdapter copy(String newId) {
        PresentationAdapter copy = this.copy();
        copy.workflowPresentation.setId(null);
        copy.workflowPresentation.setName(newId);
        return this.copy();
    }

    public PresentationAdapter copy() {
        PresentationAdapter copy = PresentationAdapter.create(this.getType(), this.getId(), this.getColumns(), this.getOwner());
        copy.setWorkflowId(this.getWorkflowId());
        copy.setReadOnly(this.isReadOnly());
        copy.setOrdering(this.getOrdering().copy());
        return copy;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = TaskOrdering.create(ordering);
    }

    public Ordering getOrdering() {
        return this.ordering.getPapiOrdering();
    }

    public String getWorkflowId() {
        return this.workflowPresentation.getId();
    }

    private void setWorkflowId(String workflowId) {
        this.workflowPresentation.setId(workflowId);
    }

    private Presentation copyWorkflowPresentation(Presentation presentation) {
        try {
            return (Presentation)UserMetadataUtil.getInstance().cloneObject((Object)presentation);
        }
        catch (Exception e) {
            throw new OperationRuntimeException((Throwable)e);
        }
    }

    private Presentation createWorkflowPresentation(String id, String user) {
        Presentation workflowPresentation = UserMetadataUtil.getFactory().createPresentation();
        workflowPresentation.setName(id);
        workflowPresentation.setOwner(user);
        workflowPresentation.setPresentationDataType(IUserMetadataService.PresentationDataType.PROCESS.name());
        return this.copyWorkflowPresentation(workflowPresentation);
    }
}

