/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.Activity;
import fuego.papi.ActivityView;
import fuego.papi.Comparison;
import fuego.papi.EditableInstancesView;
import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.OperationRuntimeException;
import fuego.papi.ParticipantScope;
import fuego.papi.PresentationType;
import fuego.papi.ProcessServiceSession;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import fuego.papi.ViewOperationException;
import fuego.papi.ViewType;
import java.util.List;
import oracle.bpel.services.workflow.query.model.TaskPredicateType;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpel.services.workflow.user.model.UserViewDetail;
import oracle.bpel.services.workflow.user.model.ViewGranteeListType;
import oracle.bpel.services.workflow.user.model.ViewGranteeType;
import oracle.bpm.papi.ora.helper.RoleHelper;
import oracle.bpm.papi.ora.util.FilterStoragedUtils;
import oracle.bpm.papi.ora.view.ActivityViewAdapter;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class InstancesViewAdapter
extends ViewAdapter
implements EditableInstancesView {
    protected FilterAdapter filter;
    protected UserViewDetail userViewDetail;
    private static final long serialVersionUID = 1124378622522202849L;

    protected InstancesViewAdapter(String id, String user) {
        super(id, user);
        this.userViewDetail = this.createUserViewDetail(id);
        this.setHidden(false);
        this.setOwner(user);
        this.setId(id);
        this.setCustom(true);
        this.setTransient(false);
        this.setLabels(Msg.QUOTE((String)this.userViewDetail.getName()));
        this.setReadOnly(false);
    }

    private InstancesViewAdapter(ProcessServiceSession session, UserViewDetail userViewDetail) {
        super(userViewDetail.getName(), userViewDetail.getOwner().getName());
        this.userViewDetail = this.copyUserViewDetail(userViewDetail);
        if (this.userViewDetail.getGrantees() != null) {
            this.assignRoles(RoleHelper.getPapiRoles(this.userViewDetail.getGrantees()).toArray());
        }
        this.setHidden(this.userViewDetail.isHidden());
        this.setOwner(this.userViewDetail.getOwner().getName());
        this.setId(this.userViewDetail.getName());
        this.setPresentation(this.userViewDetail.getPresentationId());
        this.setCustom(true);
        this.setTransient(false);
        this.setLabels(Msg.QUOTE((String)this.userViewDetail.getName()));
        String user = session.participantCurrent().getUid();
        if (user != null && user.equals(this.userViewDetail.getOwner().getName())) {
            this.setReadOnly(false);
        }
        if (this.userViewDetail.getViewPredicate() != null) {
            TaskPredicateType taskPredicate = userViewDetail.getViewPredicate();
            this.unassignAllProcesses();
            this.assignProcesses(FilterStoragedUtils.getStoragedAssignedProcesses(taskPredicate).toArray());
            this.setFilter(FilterStoragedUtils.getStoragedFilter(session, taskPredicate));
        }
    }

    public static InstancesViewAdapter create(ProcessServiceSession session, UserViewDetail userView) {
        return new InstancesViewAdapter(session, userView);
    }

    public static InstancesViewAdapter create(String id, String user) {
        return new InstancesViewAdapter(id, user);
    }

    public void setFilter(FilterAdapter filter) {
        this.filter = filter;
    }

    public FilterAdapter getFilter() {
        if (this.filter == null) {
            this.filter = FilterAdapter.create();
            this.filter.setName(this.getId());
            this.filter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.OPEN, null));
        }
        return this.filter;
    }

    public ActivityView createActivityView(Activity activity) {
        return this.createActivityView(activity.getName());
    }

    public ActivityViewAdapter createActivityView(String activity) {
        ActivityViewAdapter activityView = ViewAdapter.createActivityView(this.id, activity, this.ownerId);
        activityView.setActivityName(activity);
        activityView.setActivityType(2);
        activityView.setReadOnly(this.isReadOnly);
        activityView.setHidden(this.isHidden);
        activityView.setCustom(true);
        activityView.setTransient(true);
        activityView.setLabels(this.labels);
        activityView.setLabels(this.messageLabels);
        activityView.setPresentation(this.presentationId);
        activityView.setFilter(this.getFilter().copy());
        return activityView;
    }

    public PresentationType getPresentationType() {
        return PresentationType.INSTANCES;
    }

    public ViewType getType() {
        return ViewType.INSTANCES;
    }

    @Override
    public ViewAdapter copy() {
        InstancesViewAdapter copy = (InstancesViewAdapter)super.copy();
        copy.userViewDetail = this.copyUserViewDetail(this.userViewDetail);
        copy.filter = this.getFilter().copy();
        return copy;
    }

    public void setParametricValue(FilterAttribute filterAttribute, Object value) throws ViewOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    public void setParametricValue(VarDefinition variable, Comparison comp, Object value) throws ViewOperationException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder(super.toString());
        description.append("-- Filter -- \n");
        description.append(this.getFilter().getDescription());
        description.append("-- -- \n");
        return description.toString();
    }

    public void setFilter(Filter filter) {
        if (filter instanceof FilterAdapter) {
            this.setFilter((FilterAdapter)filter);
        } else {
            this.setFilter(FilterAdapter.create(filter));
        }
    }

    @Override
    public void assignRole(String roleId) {
        super.assignRole(roleId);
        ViewGranteeType grantee = UserMetadataUtil.getFactory().createViewGranteeType();
        grantee.setName(roleId);
        grantee.setRealm(null);
        grantee.setType("APPROLE");
        if (this.userViewDetail.getGrantees() == null) {
            ViewGranteeListType granteeList = UserMetadataUtil.getFactory().createViewGranteeListType();
            this.userViewDetail.setGrantees(granteeList);
        }
    }

    @Override
    public void assignRoles(String[] roleIds) {
        super.assignRoles(roleIds);
        for (String role : roleIds) {
            ViewGranteeType grantee = UserMetadataUtil.getFactory().createViewGranteeType();
            grantee.setName(role);
            grantee.setRealm(null);
            grantee.setType("APPROLE");
            if (this.userViewDetail.getGrantees() == null) {
                ViewGranteeListType granteeList = UserMetadataUtil.getFactory().createViewGranteeListType();
                this.userViewDetail.setGrantees(granteeList);
            }
            this.userViewDetail.getGrantees().getGrantee().add(grantee);
        }
    }

    @Override
    public void setHidden(boolean isHidden) {
        super.setHidden(isHidden);
        this.userViewDetail.setHidden(isHidden);
    }

    @Override
    public boolean hasType(ViewType viewType) {
        return viewType == ViewType.INSTANCES;
    }

    @Override
    public void setOwner(String owner) {
        super.setOwner(owner);
    }

    @Override
    public void setPresentation(String presentationId) {
        super.setPresentation(presentationId);
        this.userViewDetail.setPresentationId(presentationId);
    }

    @Override
    public void unassignAllRoles() {
        super.unassignAllRoles();
        List grantees = this.userViewDetail.getGrantees().getGrantee();
        grantees.removeAll(grantees);
    }

    @Override
    public void unassignRole(String roleId) {
        super.unassignRole(roleId);
        this.userViewDetail.getGrantees().getGrantee().remove(roleId);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
    }

    public void setUserViewDetail(@NotNull ProcessServiceSession session, @NotNull UserViewDetail userViewDetail) {
        TaskPredicateType taskPredicate;
        this.userViewDetail = this.copyUserViewDetail(userViewDetail);
        this.setId(userViewDetail.getName());
        this.setOwner(userViewDetail.getOwner().getName());
        this.setPresentation(userViewDetail.getPresentationId());
        this.setHidden(userViewDetail.isHidden());
        if (userViewDetail.getGrantees() != null) {
            this.assignRoles(RoleHelper.getPapiRoles(this.userViewDetail.getGrantees()).toArray());
        }
        if ((taskPredicate = userViewDetail.getViewPredicate()) != null) {
            this.unassignAllProcesses();
            this.assignProcesses(FilterStoragedUtils.getStoragedAssignedProcesses(taskPredicate).toArray());
            this.setFilter(FilterStoragedUtils.getStoragedFilter(session, taskPredicate));
        }
    }

    public UserViewDetail getUserViewDetail() {
        if (this.presentationId != null && this.presentationId.equalsIgnoreCase("default_instances") && this.presentationId.equalsIgnoreCase("default_activity")) {
            this.userViewDetail.setPresentationId(this.presentationId);
        }
        this.userViewDetail.setViewPredicate(FilterStoragedUtils.getTaskPredicate((Filter)this.filter, this.getAssignedProcesses()));
        return this.userViewDetail;
    }

    public String getWorkflowId() {
        return this.userViewDetail.getId();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof InstancesViewAdapter)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        InstancesViewAdapter otherView = (InstancesViewAdapter)other;
        return this.getId().equals(otherView.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    protected String getDefaultPresentation() {
        return "default_instances";
    }

    private UserViewDetail copyUserViewDetail(UserViewDetail userViewDetail) {
        try {
            return (UserViewDetail)UserMetadataUtil.getInstance().cloneObject((Object)userViewDetail);
        }
        catch (Exception e) {
            throw new OperationRuntimeException((Throwable)e);
        }
    }

    private UserViewDetail createUserViewDetail(String id) {
        UserViewDetail userViewDetail = UserMetadataUtil.getFactory().createUserViewDetail();
        userViewDetail.setName(id);
        userViewDetail.setViewType(IUserMetadataService.UserTaskViewType.PROCESS_VIEW.name());
        return userViewDetail;
    }
}

