/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.HistoryView;
import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.SortedMap;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.view.History;
import oracle.bpm.papi.ora.view.HistoryViewAdapter;
import oracle.bpm.resources.Msg;

public class HistoryViewManager {
    public static final String HYT_DEFAULT_ID = "history_view";
    public static final ViewData[] HYT_OBJS = new ViewData[]{new ViewData("today", PapiMsg.TODAY, 0), new ViewData("yesterday", PapiMsg.YESTERDAY, 0)};
    public static final String HYT_TODAY_DEFAULT_ID = HistoryViewManager.HYT_OBJS[0].viewId;
    public static final List<ViewData> HYT_WEEKS_OBJS = Arrays.asList(new ViewData("this_week", PapiMsg.LAST_WEEK, 1), new ViewData("last_week", PapiMsg.LAST_WEEK, 1), new ViewData("two_weeks_ago", PapiMsg.TWO_WEEKS_AGO, 1), new ViewData("three_weeks_ago", PapiMsg.THREE_WEEKS_AGO, 1));
    public static final ViewData[] HYT_DAYS_OBJS = new ViewData[]{new ViewData("friday", PapiMsg.FRIDAY, 0), new ViewData("thursday", PapiMsg.THURSDAY, 0), new ViewData("wednesday", PapiMsg.WEDNESDAY, 0), new ViewData("tuesday", PapiMsg.TUESDAY, 0), new ViewData("monday", PapiMsg.MONDAY, 0), new ViewData("sunday", PapiMsg.SUNDAY, 0), new ViewData("saturday", PapiMsg.SATURDAY, 0), new ViewData("friday", PapiMsg.FRIDAY, 0), new ViewData("thursday", PapiMsg.THURSDAY, 0), new ViewData("wednesday", PapiMsg.WEDNESDAY, 0), new ViewData("tuesday", PapiMsg.TUESDAY, 0), new ViewData("monday", PapiMsg.MONDAY, 0), new ViewData("sunday", PapiMsg.SUNDAY, 0)};

    public static void generateHistoryViews(SortedMap<String, HistoryViewAdapter> views, Calendar calendar) {
        String todayHistoryId = "history_view/" + HYT_TODAY_DEFAULT_ID;
        HistoryView defaultView = (HistoryView)views.remove(todayHistoryId);
        if (defaultView != null) {
            HistoryViewManager.expandHistoryViews(views, defaultView, HistoryViewManager.buildDays(calendar), calendar, 0);
            HistoryViewManager.expandHistoryViews(views, defaultView, HYT_WEEKS_OBJS, calendar, 1);
        }
    }

    private static List<ViewData> buildDays(Calendar calendar) {
        ArrayList<ViewData> result = new ArrayList<ViewData>(Arrays.asList(HYT_OBJS));
        int firstDayOfWeek = calendar.getFirstDayOfWeek();
        int todayDayOfWeek = Time.now().getDayOfWeek() - HYT_OBJS.length;
        for (int i = HYT_DAYS_OBJS.length - todayDayOfWeek; i <= HYT_DAYS_OBJS.length - firstDayOfWeek; ++i) {
            result.add(HYT_DAYS_OBJS[i]);
        }
        return result;
    }

    private static void expandHistoryViews(SortedMap<String, HistoryViewAdapter> viewmap, HistoryView defaultView, List<ViewData> viewsData, Calendar calendar, int startAt) {
        for (int i = startAt; i < viewsData.size(); ++i) {
            ViewData viewData = viewsData.get(i);
            HistoryViewAdapter historyView = (HistoryViewAdapter)((HistoryViewAdapter)defaultView).copy();
            historyView.setHistoryInterval(History.HistoryInterval.getIntervalAgo(i, viewData.type, calendar));
            historyView.setId("history_view/" + viewData.viewId);
            historyView.setLabels(viewData.label);
            viewmap.put(historyView.getId(), historyView);
        }
    }

    public static class ViewData {
        public Msg label = null;
        public int type = 0;
        public String viewId = null;

        public ViewData(String id, Msg msg, int t) {
            this.viewId = id;
            this.label = msg;
            this.type = t;
        }
    }
}

