/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.EditableHistoryView;
import fuego.papi.ViewType;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.view.History;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;

public class HistoryViewAdapter
extends InstancesViewAdapter
implements EditableHistoryView {
    private String bpelId;
    private Time from;
    private History.HistoryInterval historyInterval;
    private Time to;
    private static final long serialVersionUID = 8909243271416054698L;
    public static final String LAST_DAY = "last_day";
    public static final String LAST_WEEK = "last_week";
    public static final String LAST_MONTH = "last_month";
    public static final String LAST_THREE_MONTHS = "last_three_months";
    public static final String LAST_YEAR = "last_year";

    private HistoryViewAdapter(String id, String owner, Time from, Time to) {
        super(id, owner);
        this.from = from;
        this.to = to;
        this.historyInterval = History.HistoryInterval.getToday();
    }

    public static HistoryViewAdapter create(String id, String owner, Time from, Time to) {
        return new HistoryViewAdapter(id, owner, from, to);
    }

    @Override
    public String getWorkflowId() {
        return this.bpelId;
    }

    public void setBpelId(String bpelId) {
        this.bpelId = bpelId;
    }

    public Time getFrom() {
        return this.from;
    }

    public void setHistoryInterval(History.HistoryInterval historyInterval) {
        this.historyInterval = historyInterval;
    }

    public History getHistorySince() {
        return this.historyInterval.getSince();
    }

    public History getHistoryTo() {
        return new History(this.getHistorySince().getDate()).add(this.historyInterval.getInterval());
    }

    public int getOrder() {
        return this.historyInterval.getSince().getDaysAgo();
    }

    public Time getSince() {
        return this.getHistorySince().getDate();
    }

    public Time getTo() {
        return this.getHistoryTo().getDate();
    }

    @Override
    public ViewType getType() {
        return ViewType.HISTORY;
    }

    @Override
    public ViewAdapter copy() {
        HistoryViewAdapter copy = (HistoryViewAdapter)super.copy();
        copy.setBpelId(this.bpelId);
        copy.setFrom(this.from);
        copy.setTo(this.to);
        copy.historyInterval = new History.HistoryInterval(this.historyInterval.getSince(), this.historyInterval.getInterval());
        return copy;
    }

    public void setFrom(Time from) {
        this.from = from;
    }

    public void setTo(Time to) {
        this.to = to;
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder(super.toString());
        description.append("\tSince '");
        description.append(this.getFrom());
        description.append("'\n");
        description.append("\tTo '");
        description.append(this.getTo());
        description.append("'");
        return description.toString();
    }
}

