/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.InstanceId;
import java.io.Serializable;
import java.util.Calendar;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;

public class History
implements Serializable {
    private Time date = null;
    private static final long serialVersionUID = 5580711129842789738L;

    public History(Time date) {
        this("", date);
        this.setDateFixed(date);
    }

    public History(String instanceId, Time date) {
    }

    public History(InstanceId instanceId, Time date) {
    }

    protected History() {
    }

    public Time getDate() {
        return this.date;
    }

    public int getDaysAgo() {
        return Time.now().getDays() - this.date.getDays();
    }

    public int getProcessIn() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public History add(Interval interval) {
        this.date = Time.add((Time)this.date, (Interval)interval);
        return this;
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    public String toString() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private void setDateFixed(Time date) {
        this.date = date;
    }

    public static class HistoryInterval
    implements Serializable {
        private Interval interval = null;
        private History since = null;
        private static final long serialVersionUID = -3481483894740311388L;
        public static final int DAYS = 0;
        public static final int WEEKS = 1;

        public HistoryInterval(History since, Interval interval) {
            this.since = since;
            this.interval = interval;
        }

        protected HistoryInterval() {
        }

        public static HistoryInterval getIntervalAgo(int when, int type, Calendar calendar) {
            switch (type) {
                case 0: {
                    return HistoryInterval.getDaysAgo(when);
                }
                case 1: {
                    return HistoryInterval.getWeeksAgo(when, calendar);
                }
            }
            return HistoryInterval.getDaysAgo(when);
        }

        public static HistoryInterval getToday() {
            return HistoryInterval.getDaysAgo(0);
        }

        public Interval getInterval() {
            return this.interval;
        }

        public History getSince() {
            return this.since;
        }

        public String toString() {
            return "HistoryInterval since '" + this.since + "' and interval '" + this.interval + "'";
        }

        private static HistoryInterval getDaysAgo(int days) {
            return new HistoryInterval(new History(Time.sub((Time)Time.now(), (Interval)Interval.valueOf((int)0, (int)days, (long)0L))), Interval.ONE_DAY);
        }

        private static int getFirstDayOfWeek(int today, Calendar calendar) {
            int result = today - calendar.getFirstDayOfWeek();
            return result >= 0 ? result : 7 + result;
        }

        private static HistoryInterval getWeeksAgo(int weeks, Calendar calendar) {
            Time time = Time.now();
            time = Time.sub((Time)time, (Interval)Interval.valueOf((int)0, (int)HistoryInterval.getFirstDayOfWeek(time.getDayOfWeek(), calendar), (long)0L));
            time = Time.sub((Time)time, (Interval)Interval.valueOf((int)0, (int)(7 * weeks), (long)0L));
            return new HistoryInterval(new History(time), Interval.ONE_WEEK);
        }
    }
}

