/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.Comparison;
import fuego.papi.FilterAttribute;
import fuego.papi.InstanceInfo;
import fuego.papi.VarDefinition;
import fuego.papi.exception.InvalidVariableIdException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Void;
import oracle.bpm.log.Log;

public class FilterAttributeAdapter
implements FilterAttribute,
Serializable {
    private Comparison comparison;
    private boolean isParametric;
    private int kind = -1;
    private Object value;
    private transient VarDefinition variable = null;
    private String variableId;
    private static final long serialVersionUID = 7213343750255139695L;
    private static final String TIME_MASK = "yyyy-MM-dd HH:mm:ss";

    public FilterAttributeAdapter() {
    }

    public FilterAttributeAdapter(String variableId, Comparison comparison, Object value) {
        this.variableId = variableId;
        this.comparison = comparison == null ? Comparison.IS : comparison;
        this.isParametric = false;
        this.variable = VarDefinition.getDefaultVarDefinition((String)variableId);
        this.kind = this.variable != null ? this.variable.getKind() : FilterAttributeAdapter.getKind(value);
        this.setValue(value);
    }

    public FilterAttributeAdapter(VarDefinition variable, Comparison comparison, Object value) {
        this.variable = variable;
        this.comparison = comparison == null ? Comparison.IS : comparison;
        this.variableId = variable.getId();
        this.isParametric = false;
        this.kind = variable.getKind();
        this.setValue(value);
    }

    public boolean equals(Object comparator) {
        FilterAttribute attribute;
        String _variableId = this.getVariableId();
        Comparison _comparison = this.getComparison();
        if (comparator == this) {
            return true;
        }
        if (comparator != null && comparator instanceof FilterAttribute && _variableId.equalsIgnoreCase((attribute = (FilterAttribute)comparator).getVariableId()) && _comparison == attribute.getComparison()) {
            Object currentValue = this.getValue();
            if (currentValue != null) {
                try {
                    return currentValue.equals(attribute.getValue());
                }
                catch (ClassCastException exception) {
                }
            } else {
                if (currentValue instanceof Comparable) {
                    return ((Comparable)currentValue).compareTo(attribute.getValue()) == 0;
                }
                return currentValue == attribute.getValue();
            }
        }
        return false;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public int getKind() {
        return this.kind;
    }

    public String getSQLExpression(boolean caseSensitive) {
        int _kind = this.getKind();
        Comparison _comparison = this.getComparison();
        String expression = null;
        Object _value = this.getValue();
        if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
            expression = this.getDatabaseColumnName();
            expression = expression + _comparison.getSQLExpression();
            return expression;
        }
        switch (_kind) {
            case 1: {
                expression = this.getDatabaseColumnName();
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_value != null) {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + _value.toString().toUpperCase();
                    break;
                }
                expression = expression + _comparison.getSQLExpression();
                expression = expression + Boolean.FALSE.toString().toUpperCase();
                break;
            }
            case 3: {
                expression = this.getDatabaseColumnName();
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
                    if (_value == null) {
                        expression = expression + _comparison.getSQLExpression();
                        expression = expression + "0.0 AND 0.0";
                        break;
                    }
                    if (!(_value instanceof Number[])) break;
                    Number[] values = (Number[])_value;
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + values[0].doubleValue() + " AND " + values[1].doubleValue();
                    break;
                }
                if (_value != null) {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + ((Number)_value).doubleValue();
                    break;
                }
                expression = expression + _comparison.getSQLExpression();
                expression = expression + 0.0;
                break;
            }
            case 2: {
                expression = this.getDatabaseColumnName();
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
                    if (_value == null) {
                        expression = expression + _comparison.getSQLExpression();
                        expression = expression + "0.0 AND 0.0";
                        break;
                    }
                    if (!(_value instanceof Number[])) break;
                    Number[] values = (Number[])_value;
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + values[0].longValue() + " AND " + values[1].longValue();
                    break;
                }
                if (_value != null) {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + ((Number)_value).longValue();
                } else {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + 0;
                }
                if (_comparison != Comparison.IS_NOT || !this.getVariableId().equals("PREDEFINE_PARTICIPANT") && !this.getVariableId().equals("PREDEFINE_AUTHOR")) break;
                String nullCondition = this.getDatabaseColumnName() + Comparison.IS_NULL.getSQLExpression();
                expression = "(" + expression + " OR " + nullCondition + ")";
                break;
            }
            case 4: {
                expression = this.getDatabaseColumnName();
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
                    if (_value == null) {
                        expression = expression + _comparison.getSQLExpression();
                        expression = expression + "0.0 AND 0.0";
                        break;
                    }
                    if (!(_value instanceof Number[])) break;
                    Number[] values = (Number[])_value;
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + values[0].longValue() + " AND " + values[1].longValue();
                    break;
                }
                if (_value != null) {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + ((Number)_value).longValue();
                    break;
                }
                expression = expression + _comparison.getSQLExpression();
                expression = expression + 0;
                break;
            }
            case 5: {
                expression = caseSensitive ? this.getDatabaseColumnName() : "LOWER(" + this.getDatabaseColumnName() + ")";
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
                    if (!(_value instanceof Time[])) break;
                    Time[] values = (Time[])_value;
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + "'" + values[0].format(TIME_MASK) + "'";
                    expression = expression + " AND ";
                    expression = expression + "'" + values[1].format(TIME_MASK) + "'";
                    break;
                }
                if (_value != null) {
                    expression = expression + _comparison.getSQLExpression();
                    String expresionValue = _comparison == Comparison.BEGIN_WITH || _comparison == Comparison.NOT_BEGIN_WITH ? "'" + _value.toString() + "%'" : (_comparison == Comparison.END_WITH || _comparison == Comparison.NOT_END_WITH ? "'%" + _value.toString() + "'" : (_comparison == Comparison.CONTAINS || _comparison == Comparison.NOT_CONTAINS ? "'%" + _value.toString() + "%'" : "'" + _value.toString() + "'"));
                    if (caseSensitive) {
                        expression = expression + expresionValue;
                        break;
                    }
                    expression = expression + expresionValue.toLowerCase();
                    break;
                }
                expression = expression + _comparison.getSQLExpression();
                String expresionValue = _comparison == Comparison.BEGIN_WITH || _comparison == Comparison.NOT_BEGIN_WITH || _comparison == Comparison.END_WITH || _comparison == Comparison.NOT_END_WITH || _comparison == Comparison.CONTAINS || _comparison == Comparison.NOT_CONTAINS ? "'%'" : "''";
                expression = expression + expresionValue;
                break;
            }
            case 6: {
                if (this.getVariableId().equals("PREDEFINE_DEADLINE")) {
                    expression = this.getDeadlineSQLExpresion();
                    break;
                }
                if (_comparison.getSQLExpression() == null) break;
                expression = this.getDatabaseColumnName();
                if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
                    expression = expression + _comparison.getSQLExpression();
                    break;
                }
                if (_value instanceof Time) {
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + "'" + ((Time)_value).format(TIME_MASK) + "'";
                    break;
                }
                if (_value instanceof Interval) {
                    Time start = Time.now().sub((Interval)_value);
                    Time finish = Time.now().add((Interval)_value);
                    if (_comparison == Comparison.IS_NOT) {
                        expression = expression + " NOT BETWEEN ";
                        expression = expression + "'" + start.format(TIME_MASK) + "'";
                        expression = expression + " AND ";
                        expression = expression + "'" + finish.format(TIME_MASK) + "'";
                        break;
                    }
                    if (_comparison == Comparison.IS) {
                        expression = expression + " BETWEEN ";
                        expression = expression + "'" + start.format(TIME_MASK) + "'";
                        expression = expression + " AND ";
                        expression = expression + "'" + finish.format(TIME_MASK) + "'";
                        break;
                    }
                    if (_comparison == Comparison.LESS_THAN || _comparison == Comparison.LESS_OR_EQUALS || _comparison == Comparison.BEFORE) {
                        expression = expression + _comparison.getSQLExpression();
                        expression = expression + "'" + start.format(TIME_MASK) + "'";
                        break;
                    }
                    if (_comparison != Comparison.GREATER_THAN && _comparison != Comparison.GREATER_OR_EQUALS && _comparison != Comparison.AFTER) break;
                    expression = expression + _comparison.getSQLExpression();
                    expression = expression + "'" + finish.format(TIME_MASK) + "'";
                    break;
                }
                expression = expression + _comparison.getSQLExpression();
                expression = expression + "'" + ((Time)this.getDefaultValue()).format(TIME_MASK) + "'";
            }
        }
        if (expression == null) {
            expression = this.getDatabaseColumnName();
            expression = expression + _comparison.getSQLExpression();
            expression = expression + this.getDefaultValue();
        }
        return expression;
    }

    public Object getValue() {
        return this.value;
    }

    public VarDefinition getVariable() {
        return this.variable;
    }

    public String getVariableId() {
        return this.variableId;
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 17 * hashCode + this.getVariableId().toLowerCase().hashCode();
        hashCode = 17 * hashCode + this.getComparison().hashCode();
        hashCode = 17 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return hashCode;
    }

    public boolean isParametric() {
        return this.isParametric;
    }

    public boolean match(InstanceInfo instance, boolean caseSensitive) {
        int _kind = this.getKind();
        Comparison _comparison = this.getComparison();
        Object instanceValue = Void.getInstance();
        try {
            instanceValue = instance.getExternalVariable(this.getVariableId());
        }
        catch (InvalidVariableIdException e) {
            // empty catch block
        }
        if (instanceValue instanceof Void) {
            Log.logDebug((String)("Instance " + instance.getId() + " returned Void while querying for external var " + this.getVariableId() + "\nFilter: " + this.toString()));
            return false;
        }
        Object attributeValue = this.getValue();
        if (_kind == 5 && !caseSensitive) {
            if (instanceValue != null) {
                instanceValue = instanceValue.toString().toUpperCase();
            }
            if (attributeValue != null) {
                attributeValue = attributeValue.toString().toUpperCase();
            }
        }
        if (_comparison == Comparison.IS_NULL) {
            return instanceValue == null;
        }
        if (_comparison == Comparison.IS_NOT_NULL) {
            return instanceValue != null;
        }
        if (_comparison == Comparison.IS) {
            if (instanceValue == null) {
                return false;
            }
            if (attributeValue instanceof Interval) {
                return this.compare(instanceValue, Time.now().add((Interval)attributeValue)) <= 0 && this.compare(instanceValue, Time.now().sub((Interval)attributeValue)) >= 0;
            }
            return this.areEquals(instanceValue, attributeValue);
        }
        if (_comparison == Comparison.IS_NOT) {
            if (instanceValue == null) {
                return true;
            }
            if (attributeValue instanceof Interval) {
                return this.compare(instanceValue, Time.now().add((Interval)attributeValue)) > 0 || this.compare(instanceValue, Time.now().sub((Interval)attributeValue)) < 0;
            }
            return !this.areEquals(instanceValue, attributeValue);
        }
        if (_comparison == Comparison.CONTAINS) {
            if (instanceValue == null) {
                return false;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return ((String)instanceValue).indexOf((String)attributeValue) != -1;
        }
        if (_comparison == Comparison.NOT_CONTAINS) {
            if (instanceValue == null) {
                return true;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return ((String)instanceValue).indexOf((String)attributeValue) == -1;
        }
        if (_comparison == Comparison.BEGIN_WITH) {
            if (instanceValue == null) {
                return false;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return ((String)instanceValue).startsWith((String)attributeValue);
        }
        if (_comparison == Comparison.NOT_BEGIN_WITH) {
            if (instanceValue == null) {
                return true;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return !((String)instanceValue).startsWith((String)attributeValue);
        }
        if (_comparison == Comparison.END_WITH) {
            if (instanceValue == null) {
                return false;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return ((String)instanceValue).endsWith((String)attributeValue);
        }
        if (_comparison == Comparison.NOT_END_WITH) {
            if (instanceValue == null) {
                return true;
            }
            if (_kind != 5 || !(instanceValue instanceof String)) {
                return false;
            }
            return !((String)instanceValue).endsWith((String)attributeValue);
        }
        if (_comparison == Comparison.GREATER_THAN) {
            return instanceValue != null && this.compare(instanceValue, attributeValue) > 0;
        }
        if (_comparison == Comparison.GREATER_OR_EQUALS) {
            return instanceValue != null && this.compare(instanceValue, attributeValue) >= 0;
        }
        if (_comparison == Comparison.LESS_THAN) {
            return instanceValue == null || this.compare(instanceValue, attributeValue) < 0;
        }
        if (_comparison == Comparison.LESS_OR_EQUALS) {
            return instanceValue == null || this.compare(instanceValue, attributeValue) <= 0;
        }
        if (_comparison == Comparison.AFTER) {
            if (instanceValue == null) {
                return false;
            }
            if (attributeValue instanceof Interval) {
                return this.compare(instanceValue, Time.now().add((Interval)attributeValue)) > 0;
            }
            return this.compare(instanceValue, attributeValue) > 0;
        }
        if (_comparison == Comparison.BEFORE) {
            if (instanceValue == null) {
                return true;
            }
            if (attributeValue instanceof Interval) {
                return this.compare(instanceValue, Time.now().sub((Interval)attributeValue)) < 0;
            }
            return this.compare(instanceValue, attributeValue) < 0;
        }
        if (_comparison == Comparison.BETWEEN) {
            if (attributeValue.getClass().isArray()) {
                Class<?> componentType = attributeValue.getClass().getComponentType();
                if (Number.class.isAssignableFrom(componentType)) {
                    Number[] values = (Number[])attributeValue;
                    return this.compare(instanceValue, values[0]) >= 0 && this.compare(instanceValue, values[1]) <= 0;
                }
                if (Time.class.isAssignableFrom(componentType)) {
                    Time[] values = (Time[])attributeValue;
                    return this.compare(instanceValue, values[0]) >= 0 && this.compare(instanceValue, values[1]) <= 0;
                }
            }
        } else if (_comparison == Comparison.NOT_BETWEEN && attributeValue.getClass().isArray()) {
            Class<?> componentType = attributeValue.getClass().getComponentType();
            if (Number.class.isAssignableFrom(componentType)) {
                Number[] values = (Number[])attributeValue;
                return this.compare(instanceValue, values[0]) < 0 || this.compare(instanceValue, values[1]) > 0;
            }
            if (Time.class.isAssignableFrom(componentType)) {
                Time[] values = (Time[])attributeValue;
                return this.compare(instanceValue, values[0]) < 0 || this.compare(instanceValue, values[1]) > 0;
            }
        }
        return false;
    }

    public void setComparison(Comparison comparison) {
        this.checkOperatorType(comparison);
        this.comparison = comparison;
        this.changedValue();
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void setParametric(boolean isParametric) {
        this.isParametric = isParametric;
    }

    public void setValue(Object value) {
        if ((value = this.checkValue(value)) == null && this.comparison != Comparison.IS_NULL && this.comparison != Comparison.IS_NOT_NULL) {
            value = this.getDefaultValue();
        }
        this.value = value;
    }

    public void setVariable(VarDefinition variable) {
        if (!variable.getId().equalsIgnoreCase(this.getVariableId())) {
            throw new IllegalArgumentException("Invalid VarDefinition");
        }
        this.checkVariable(variable.getId());
        this.variable = variable;
        this.setVariableId(variable.getId());
        this.setKind(variable.getKind());
    }

    public void setVariableId(String variableId) {
        this.checkVariable(variableId);
        this.variableId = variableId;
    }

    public String toString() {
        StringBuilder description = new StringBuilder("Attribute ");
        description.append(this.variableId);
        description.append(" (");
        description.append(this.kind);
        description.append(") ");
        description.append(this.comparison.name());
        description.append(" ");
        Object _value = this.getValue();
        if (_value == null) {
            description.append("null (null)");
        } else {
            description.append(_value.toString());
            description.append("(");
            description.append(_value.getClass().getName());
            description.append(")");
        }
        description.append(" - Parametric '");
        description.append(this.isParametric);
        description.append("'");
        return description.toString();
    }

    private static int getKind(Object value) {
        Object checkValue = null;
        if (value.getClass().isArray()) {
            Class<?> clazz = value.getClass().getComponentType();
            if (clazz != null) {
                try {
                    checkValue = clazz.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        } else {
            checkValue = value;
        }
        if (checkValue instanceof Integer || checkValue instanceof Long) {
            return 2;
        }
        if (checkValue instanceof Float || checkValue instanceof Double) {
            return 4;
        }
        if (checkValue instanceof BigDecimal || checkValue instanceof Number) {
            return 3;
        }
        if (checkValue instanceof Time || checkValue instanceof Date) {
            return 6;
        }
        if (checkValue instanceof Interval) {
            return 7;
        }
        if (checkValue instanceof Boolean) {
            return 1;
        }
        if (checkValue instanceof String) {
            return 5;
        }
        return -1;
    }

    private static int compareAny(Object leftObj, Object rightObj) {
        return ((Comparable)leftObj).compareTo(rightObj);
    }

    private boolean areEquals(Object leftObj, Object rightObj) {
        if (leftObj instanceof Boolean) {
            if (rightObj instanceof Boolean) {
                Boolean left = (Boolean)leftObj;
                Boolean right = (Boolean)rightObj;
                return left.equals(right);
            }
        } else if (leftObj instanceof Number) {
            if (rightObj instanceof Number) {
                Double left = ((Number)leftObj).doubleValue();
                Double right = ((Number)rightObj).doubleValue();
                return left.equals(right);
            }
        } else if (leftObj instanceof Time) {
            if (rightObj instanceof Time) {
                Time left = (Time)leftObj;
                Time right = (Time)rightObj;
                return left.equals((Object)right);
            }
        } else if (leftObj instanceof Interval) {
            if (rightObj instanceof Interval) {
                Interval left = (Interval)leftObj;
                Interval right = (Interval)rightObj;
                return left.equals((Object)right);
            }
        } else if (leftObj instanceof String && rightObj instanceof String) {
            String left = (String)leftObj;
            String right = (String)rightObj;
            return left.equals(right);
        }
        return false;
    }

    private void checkVariable(String _variableId) {
        if (!VarDefinition.isExternal((String)_variableId)) {
            VarDefinition[] defaultVarDefinitions;
            for (VarDefinition defaultVariable : defaultVarDefinitions = VarDefinition.createInstanceDefaults()) {
                if (!_variableId.equals(defaultVariable.getId())) continue;
                this.setKind(defaultVariable.getKind());
                return;
            }
            throw new IllegalArgumentException("Invalid VarDefinition");
        }
    }

    private int compare(Object leftObj, Object rightObj) {
        if (leftObj == null && rightObj == null) {
            return 0;
        }
        if (leftObj == null) {
            return -1;
        }
        if (rightObj == null) {
            return 1;
        }
        if (leftObj instanceof Boolean) {
            if (rightObj instanceof Boolean) {
                Boolean left = (Boolean)leftObj;
                Boolean right = (Boolean)rightObj;
                if (left.booleanValue() && right.booleanValue()) {
                    return 0;
                }
                if (left.booleanValue()) {
                    return 1;
                }
                return -1;
            }
        } else if (leftObj instanceof Number) {
            if (rightObj instanceof Number) {
                Double left = ((Number)leftObj).doubleValue();
                Double right = ((Number)rightObj).doubleValue();
                return left.compareTo(right);
            }
        } else if (leftObj instanceof Time) {
            if (rightObj instanceof Time) {
                Time left = (Time)leftObj;
                Time right = (Time)rightObj;
                return left.compareTo(right);
            }
        } else if (leftObj instanceof Interval) {
            if (rightObj instanceof Interval) {
                Interval left = (Interval)leftObj;
                Interval right = (Interval)rightObj;
                return left.compareTo(right);
            }
        } else if (leftObj instanceof String && rightObj instanceof String) {
            String left = (String)leftObj;
            String right = (String)rightObj;
            return left.compareTo(right);
        }
        if (leftObj.equals(rightObj)) {
            return 0;
        }
        if (leftObj instanceof Comparable) {
            return FilterAttributeAdapter.compareAny(leftObj, rightObj);
        }
        throw new RuntimeException("Invalid comparisson types.\n" + leftObj.getClass().getName() + " != " + rightObj.getClass().getName());
    }

    private String getDatabaseColumnName() {
        return VarDefinition.getDatabaseColumnName((String)this.getVariableId()).toUpperCase();
    }

    private String getDeadlineSQLExpresion() {
        Comparison _comparison = this.getComparison();
        String processDeadlineExpresion = VarDefinition.getDatabaseColumnName((String)"PREDEFINE_PROCESS DEADLINE").toUpperCase();
        String activityDeadlineExpresion = VarDefinition.getDatabaseColumnName((String)"PREDEFINE_ACTIVITY DEADLINE").toUpperCase();
        if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
            return "((" + VarDefinition.getDatabaseColumnName((String)"PREDEFINE_ACTIVITY DEADLINE").toUpperCase() + _comparison.getSQLExpression() + ") AND (" + VarDefinition.getDatabaseColumnName((String)"PREDEFINE_PROCESS DEADLINE").toUpperCase() + _comparison.getSQLExpression() + "))";
        }
        Object _value = this.getValue();
        if (_value == null) {
            processDeadlineExpresion = processDeadlineExpresion + _comparison.getSQLExpression();
            processDeadlineExpresion = processDeadlineExpresion + "'" + Time.now().format(TIME_MASK) + "'";
            activityDeadlineExpresion = activityDeadlineExpresion + _comparison.getSQLExpression();
            activityDeadlineExpresion = activityDeadlineExpresion + "'" + Time.now().format(TIME_MASK) + "'";
        } else if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
            if (_value instanceof Time[]) {
                Time[] values = (Time[])_value;
                processDeadlineExpresion = processDeadlineExpresion + _comparison.getSQLExpression();
                processDeadlineExpresion = processDeadlineExpresion + "'" + values[0].format(TIME_MASK) + "'";
                processDeadlineExpresion = processDeadlineExpresion + " AND ";
                processDeadlineExpresion = processDeadlineExpresion + "'" + values[1].format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + _comparison.getSQLExpression();
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + values[0].format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + " AND ";
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + values[1].format(TIME_MASK) + "'";
            }
        } else if (_value instanceof Time) {
            processDeadlineExpresion = processDeadlineExpresion + _comparison.getSQLExpression();
            processDeadlineExpresion = processDeadlineExpresion + "'" + ((Time)_value).format(TIME_MASK) + "'";
            activityDeadlineExpresion = activityDeadlineExpresion + _comparison.getSQLExpression();
            activityDeadlineExpresion = activityDeadlineExpresion + "'" + ((Time)_value).format(TIME_MASK) + "'";
        } else if (_value instanceof Interval) {
            Time start = Time.now().sub((Interval)_value);
            Time finish = Time.now().add((Interval)_value);
            if (_comparison == Comparison.IS_NOT) {
                processDeadlineExpresion = processDeadlineExpresion + " NOT BETWEEN ";
                processDeadlineExpresion = processDeadlineExpresion + "'" + start.format(TIME_MASK) + "'";
                processDeadlineExpresion = processDeadlineExpresion + " AND ";
                processDeadlineExpresion = processDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + " NOT BETWEEN ";
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + start.format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + " AND ";
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
            } else if (_comparison == Comparison.IS) {
                processDeadlineExpresion = processDeadlineExpresion + " BETWEEN ";
                processDeadlineExpresion = processDeadlineExpresion + start.format(TIME_MASK);
                processDeadlineExpresion = processDeadlineExpresion + " AND ";
                processDeadlineExpresion = processDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + " BETWEEN ";
                activityDeadlineExpresion = activityDeadlineExpresion + start.format(TIME_MASK);
                activityDeadlineExpresion = activityDeadlineExpresion + " AND ";
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
            } else if (_comparison == Comparison.LESS_THAN || _comparison == Comparison.LESS_OR_EQUALS || _comparison == Comparison.BEFORE) {
                processDeadlineExpresion = processDeadlineExpresion + _comparison.getSQLExpression();
                processDeadlineExpresion = processDeadlineExpresion + "'" + start.format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + _comparison.getSQLExpression();
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + start.format(TIME_MASK) + "'";
            } else if (_comparison == Comparison.GREATER_THAN || _comparison == Comparison.GREATER_OR_EQUALS || _comparison == Comparison.AFTER) {
                processDeadlineExpresion = processDeadlineExpresion + _comparison.getSQLExpression();
                processDeadlineExpresion = processDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
                activityDeadlineExpresion = activityDeadlineExpresion + _comparison.getSQLExpression();
                activityDeadlineExpresion = activityDeadlineExpresion + "'" + finish.format(TIME_MASK) + "'";
            }
        }
        return "(((" + VarDefinition.getDatabaseColumnName((String)"PREDEFINE_ACTIVITY DEADLINE").toUpperCase() + " IS NULL) OR (" + VarDefinition.getDatabaseColumnName((String)"PREDEFINE_PROCESS DEADLINE").toUpperCase() + " < " + VarDefinition.getDatabaseColumnName((String)"PREDEFINE_ACTIVITY DEADLINE").toUpperCase() + ")) AND (" + activityDeadlineExpresion + ") OR (" + processDeadlineExpresion + "))";
    }

    private Object getDefaultValue() {
        int _kind = this.getKind();
        Comparison _comparison = this.getComparison();
        if (_comparison == Comparison.IS_NULL || _comparison == Comparison.IS_NOT_NULL) {
            return null;
        }
        if (_comparison == Comparison.BETWEEN || _comparison == Comparison.NOT_BETWEEN) {
            switch (_kind) {
                case 3: {
                    return new Double[]{0.0, 0.0};
                }
                case 2: 
                case 4: {
                    return new Long[]{0L, 0L};
                }
                case 6: {
                    return new Time[]{Time.now(), Time.now()};
                }
            }
            return null;
        }
        switch (_kind) {
            case 1: {
                return Boolean.FALSE;
            }
            case 3: {
                return 0.0;
            }
            case 2: 
            case 4: {
                return 0;
            }
            case 5: {
                return "";
            }
            case 6: {
                return Time.now();
            }
            case 7: {
                return new Interval();
            }
        }
        return null;
    }

    private void changedValue() {
        Object oldValue = this.value;
        Object newValue = this.getDefaultValue();
        if (oldValue == null || newValue == null) {
            this.value = newValue;
        } else if (oldValue.getClass().isArray() != newValue.getClass().isArray()) {
            this.value = newValue;
        }
    }

    private void checkOperatorType(Comparison operator) {
        boolean isValidOperator = true;
        if (this.kind != -1) {
            switch (this.kind) {
                case 1: {
                    if (operator == Comparison.IS || operator == Comparison.IS_NULL || operator == Comparison.IS_NOT || operator == Comparison.IS_NOT_NULL) break;
                    isValidOperator = false;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    if (!operator.isTextComparisonOnly()) break;
                    isValidOperator = false;
                    break;
                }
                case 5: {
                    isValidOperator = true;
                    break;
                }
                default: {
                    isValidOperator = false;
                }
            }
        }
        if (!isValidOperator) {
            throw new IllegalArgumentException("Invalid comparator");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object checkValue(Object _value) {
        if (_value == null) return _value;
        if (_value instanceof Date) {
            _value = Time.valueOf((Date)((Date)_value));
        }
        if (this.comparison == Comparison.BETWEEN || this.comparison == Comparison.NOT_BETWEEN) {
            if (!_value.getClass().isArray()) throw new IllegalArgumentException("The value must be an array.");
            Object[] values = _value;
            if (values.length != 2) throw new IllegalArgumentException("Illegal array size (The size must be 2).");
            values[0] = this.getValidValue(values[0]);
            values[1] = this.getValidValue(values[1]);
            if (FilterAttributeAdapter.compareAny(values[0], values[1]) <= 0) return values;
            throw new IllegalArgumentException("The first value of the array must be lower than the second.");
        }
        if (this.kind == -1) return _value;
        return this.getValidValue(_value);
    }

    private Object getValidValue(Object _value) {
        switch (this.kind) {
            case 1: {
                if (!(_value instanceof Boolean)) {
                    return Boolean.valueOf(_value.toString());
                }
                return _value;
            }
            case 2: 
            case 3: 
            case 4: {
                if (!(_value instanceof Number)) {
                    try {
                        return new BigDecimal(_value.toString());
                    }
                    catch (NumberFormatException exception) {
                        throw new IllegalArgumentException("Invalid object type [kind " + Kind.getName((int)this.kind) + "] " + _value.getClass().getName());
                    }
                }
                return _value;
            }
            case 5: {
                if (!(_value instanceof String)) {
                    return _value.toString();
                }
                return _value;
            }
            case 6: {
                if (_value instanceof Date) {
                    return Time.valueOf((Date)((Date)_value));
                }
                if (!(_value instanceof Time) && !(_value instanceof Interval)) {
                    try {
                        _value = Time.valueOf((String)_value.toString());
                    }
                    catch (FormatException timeException) {
                        try {
                            return Interval.valueOf((String)_value.toString());
                        }
                        catch (FormatException intervalException) {
                            throw new IllegalArgumentException("Invalid object type [kind " + Kind.getName((int)this.kind) + "] " + _value.getClass().getName());
                        }
                    }
                }
                return _value;
            }
        }
        throw new IllegalArgumentException("Invalid object type [kind " + Kind.getName((int)this.kind) + "] " + _value.getClass().getName());
    }
}

