/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.Comparison;
import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.InstanceInfo;
import fuego.papi.Ordering;
import fuego.papi.Participant;
import fuego.papi.ParticipantScope;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.papi.ora.InstanceInfoComparator;
import oracle.bpm.papi.ora.view.FilterAttributeAdapter;

public class FilterAdapter
implements Filter {
    private List<FilterAttribute> attributes;
    private boolean caseSensitive = false;
    private boolean matchAll = false;
    private String name = "Filter-" + System.currentTimeMillis();
    private Ordering ordering;
    private SearchScope searchScope = new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.OPEN, null);
    private Set<Filter> subfilters;
    private static final long serialVersionUID = 5582092287871993916L;

    private FilterAdapter() {
        this.attributes = new ArrayList<FilterAttribute>();
        this.subfilters = new HashSet<Filter>();
        this.ordering = new Ordering();
        this.ordering.add("PREDEFINE_RECEIVED TIME", true);
    }

    public static FilterAdapter create() {
        return new FilterAdapter();
    }

    public static FilterAdapter create(Filter filter) {
        FilterAdapter filterAdapter = FilterAdapter.create();
        filterAdapter.setName(filter.getName());
        filterAdapter.setSearchScope(filter.getSearchScope());
        filterAdapter.setMatchAll(filter.isMatchAll());
        filterAdapter.setCaseSensitive(filter.isCaseSensitive());
        filterAdapter.setOrdering(filter.getOrdering());
        for (FilterAttribute filterAttribute : filter.getAttributes()) {
            filterAdapter.addAttribute(filterAttribute.getVariableId(), filterAttribute.getKind(), filterAttribute.getComparison(), filterAttribute.getValue(), filterAttribute.isParametric());
        }
        for (Filter subfilter : filter.getFilters()) {
            filterAdapter.addFilter(subfilter);
        }
        return filterAdapter;
    }

    public void addFilter(Filter subfilter) {
        this.subfilters.add(subfilter);
    }

    public boolean removeFilter(Filter subfilter) {
        return this.subfilters.remove(subfilter);
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.addAll(this.subfilters);
        return filters;
    }

    public List<FilterAttribute> getAttributes() {
        ArrayList<FilterAttribute> result = new ArrayList<FilterAttribute>();
        result.addAll(this.attributes);
        return result;
    }

    public Map<String, List<FilterAttribute>> getAttributesByVariable() {
        TreeMap<String, List<FilterAttribute>> attributesByVariable = new TreeMap<String, List<FilterAttribute>>(String.CASE_INSENSITIVE_ORDER);
        for (FilterAttribute attribute : this.attributes) {
            ArrayList<FilterAttribute> variableAttributes = (ArrayList<FilterAttribute>)attributesByVariable.get(attribute.getVariableId());
            if (variableAttributes == null) {
                variableAttributes = new ArrayList<FilterAttribute>();
                attributesByVariable.put(attribute.getVariableId(), variableAttributes);
            }
            variableAttributes.add(attribute);
        }
        return attributesByVariable;
    }

    public List<FilterAttribute> getAttributesByVariable(String variable) {
        ArrayList<FilterAttribute> attributesByVariable = new ArrayList<FilterAttribute>();
        if (variable != null) {
            for (FilterAttribute attribute : this.attributes) {
                if (!attribute.getVariableId().equalsIgnoreCase(variable)) continue;
                attributesByVariable.add(attribute);
            }
        }
        return attributesByVariable;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Comparator getComparator() {
        return new InstanceInfoComparator(this.getOrdering(), Locale.getDefault());
    }

    public Comparator getComparator(Locale locale) {
        return new InstanceInfoComparator(this.getOrdering(), locale);
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("Filter : ");
        stringBuilder.append(this.getName());
        stringBuilder.append("\n");
        stringBuilder.append("MatchAll : ");
        stringBuilder.append(this.isMatchAll());
        stringBuilder.append("\n");
        stringBuilder.append("CaseSensitive : ");
        stringBuilder.append(this.isCaseSensitive());
        stringBuilder.append("\n");
        stringBuilder.append("SearchScope : ");
        stringBuilder.append(this.getSearchScope().getParticipantScope());
        stringBuilder.append(" | ");
        stringBuilder.append(this.getSearchScope().getStatusScope());
        stringBuilder.append("\n");
        stringBuilder.append("Predicate :\n");
        for (FilterAttribute filterAttribute : this.getAttributes()) {
            stringBuilder.append("     ");
            stringBuilder.append(filterAttribute.getVariableId());
            stringBuilder.append(" ");
            stringBuilder.append(filterAttribute.getComparison().name());
            stringBuilder.append(" ");
            stringBuilder.append(filterAttribute.getValue());
            stringBuilder.append("\n");
        }
        stringBuilder.append("SubFilters :\n");
        for (Filter filter : this.getFilters()) {
            stringBuilder.append("[-----\n");
            stringBuilder.append(filter.getDescription());
            stringBuilder.append(" -----]\n");
        }
        return stringBuilder.toString();
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public boolean isParametric() {
        return false;
    }

    public List<FilterAttribute> getParametricAttributes() {
        return new ArrayList<FilterAttribute>();
    }

    public void setSearchScope(SearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public SearchScope getSearchScope() {
        if (this.searchScope != null) {
            return this.searchScope;
        }
        return new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.OPEN, null);
    }

    public FilterAttribute addAttribute(String variable, Comparison operator, Object value) {
        FilterAttributeAdapter newAttribute = new FilterAttributeAdapter(variable, operator, value);
        if (!this.attributes.contains(newAttribute)) {
            this.attributes.add(newAttribute);
        }
        return newAttribute;
    }

    public void addAttribute(FilterAttribute attribute) {
        if (!this.attributes.contains(attribute)) {
            this.attributes.add(attribute);
        }
    }

    public FilterAttribute addAttribute(VarDefinition variable, Comparison operator, Object value) {
        return this.addAttribute(variable.getId(), operator, value);
    }

    public FilterAttribute addAttribute(VarDefinition variable, Comparison operator, boolean parametric) {
        throw new UnsupportedOperationException("Parametric attributes are not supported");
    }

    public FilterAttribute addAttribute(VarDefinition variable, Comparison operator, Object value, boolean parametric) {
        return this.addAttribute(variable, operator, value);
    }

    public FilterAttribute addAttribute(String variableId, int kind, Comparison operator, Object value, boolean parametric) {
        return this.addAttribute(variableId, operator, value);
    }

    public boolean match(InstanceInfo instance, Participant participant) {
        return false;
    }

    public void removeAttribute(FilterAttribute attribute) {
        this.attributes.remove(attribute);
    }

    public List<FilterAttribute> removeAttributes(String variable) {
        ArrayList<FilterAttribute> removedAttributes = new ArrayList<FilterAttribute>();
        if (variable != null) {
            ArrayList<FilterAttribute> resultAttributes = new ArrayList<FilterAttribute>();
            for (FilterAttribute attribute : this.attributes) {
                if (attribute.getVariableId().equalsIgnoreCase(variable)) {
                    removedAttributes.add(attribute);
                    continue;
                }
                resultAttributes.add(attribute);
            }
            this.attributes = resultAttributes;
        }
        return removedAttributes;
    }

    public FilterAdapter copy() {
        FilterAdapter copy = new FilterAdapter();
        copy.searchScope = new SearchScope(this.searchScope.getParticipantScope(), this.searchScope.getStatusScope(), this.searchScope.getActivityScope());
        copy.matchAll = this.matchAll;
        copy.caseSensitive = this.caseSensitive;
        copy.ordering = this.ordering.copy();
        copy.attributes = new ArrayList<FilterAttribute>();
        copy.attributes.addAll(this.attributes);
        return copy;
    }
}

