/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.view;

import fuego.papi.Activity;
import fuego.papi.EditableActivityView;
import fuego.papi.SearchScope;
import fuego.papi.ViewType;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;

public class ActivityViewAdapter
extends InstancesViewAdapter
implements EditableActivityView {
    private String activity;
    private int activityType;
    private static final long serialVersionUID = 4861281151268396878L;
    public static final String DEFAULT_PRESENTATION = "default_activity";

    private ActivityViewAdapter(String id, String owner, String activity) {
        super(id, owner);
        if (activity != null) {
            this.activity = activity;
        }
    }

    public static ActivityViewAdapter create(String id, String owner, String activity) {
        return new ActivityViewAdapter(id, owner, activity);
    }

    public void setActivity(Activity activity) {
        this.activity = activity.getName();
        this.activityType = activity.getType();
    }

    public void setActivityName(String activityName) {
        this.activity = activityName;
    }

    public String getActivityName() {
        return this.activity;
    }

    public void setActivityType(int activityType) {
        this.activityType = activityType;
    }

    public int getActivityType() {
        return this.activityType;
    }

    @Override
    public FilterAdapter getFilter() {
        FilterAdapter copy = super.getFilter().copy();
        copy.setSearchScope(new SearchScope(super.getFilter().getSearchScope().getParticipantScope(), super.getFilter().getSearchScope().getStatusScope(), this.activity));
        return copy;
    }

    @Override
    public ViewType getType() {
        return ViewType.ACTIVITY_INSTANCES;
    }

    @Override
    public ViewAdapter copy() {
        ActivityViewAdapter copy = (ActivityViewAdapter)super.copy();
        copy.activity = this.activity;
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder description = new StringBuilder(super.toString());
        description.append("\n");
        description.append("\tActivity Name '");
        description.append(this.activity);
        description.append("'\n");
        description.append("\tActivity Type '");
        description.append(this.activityType);
        description.append("'\n");
        return description.toString();
    }

    @Override
    protected String getDefaultPresentation() {
        return DEFAULT_PRESENTATION;
    }
}

