/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.ApplicationsView;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.Ordering;
import fuego.papi.ParticipantScope;
import fuego.papi.Presentation;
import fuego.papi.Process;
import fuego.papi.ProcessServiceSession;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.View;
import fuego.papi.ViewType;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.collections.ProcessList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.query.model.ObjectFactory;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.ProcessIdHelper;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.util.FilterAdapterUtils;
import oracle.bpm.papi.ora.view.ApplicationsViewAdapter;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;
import org.jetbrains.annotations.NotNull;

public class ViewUtils {
    private static final ObjectFactory queryModelFactory = new ObjectFactory();

    public static InstancesView getDefaultInboxView(ProcessList processes) {
        ArrayList<String> assignRoles = new ArrayList<String>();
        ArrayList<String> assignProcesses = new ArrayList<String>();
        for (Process process : processes) {
            assignRoles.addAll(Arrays.asList(process.getRoles()));
            String consolidatedId = ProcessIdHelper.getConsolidatedId(process.getId());
            boolean added = false;
            for (String assignProcess : assignProcesses) {
                if (!assignProcess.equalsIgnoreCase(consolidatedId)) continue;
                added = true;
                break;
            }
            if (added) continue;
            assignProcesses.add(consolidatedId);
        }
        InstancesViewAdapter view = ViewAdapter.createInstancesView("unified_inbox");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(assignRoles.toArray(new String[assignRoles.size()]));
        view.assignProcesses(assignProcesses.toArray(new String[assignProcesses.size()]));
        view.setLabels(LibMsg.INBOX);
        FilterAdapter filter = FilterAdapter.create();
        filter.setSearchScope(new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.ONLY_INPROCESS));
        filter.setName(view.getId());
        view.setFilter(filter);
        return view;
    }

    public static ApplicationsView getDefaultApplicationsxView(ProcessList processes) {
        ArrayList<String> assignRoles = new ArrayList<String>();
        ArrayList<String> assignProcesses = new ArrayList<String>();
        for (Process process : processes) {
            assignRoles.addAll(Arrays.asList(process.getRoles()));
            String consolidatedId = ProcessIdHelper.getConsolidatedId(process.getId());
            boolean added = false;
            for (String assignProcess : assignProcesses) {
                if (!assignProcess.equalsIgnoreCase(consolidatedId)) continue;
                added = true;
                break;
            }
            if (added) continue;
            assignProcesses.add(consolidatedId);
        }
        ApplicationsViewAdapter view = ViewAdapter.createApplicationsView("applications");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(assignRoles.toArray(new String[assignRoles.size()]));
        view.assignProcesses(assignProcesses.toArray(new String[assignProcesses.size()]));
        view.setLabels(LibMsg.APPLICATIONS);
        return view;
    }

    public static View createView(@NotNull ProcessServiceSession session, @NotNull Predicate predicate) throws OperationException {
        return ViewUtils.createView(session, predicate.toString(), predicate);
    }

    public static View createView(@NotNull ProcessServiceSession session, @NotNull String viewId, @NotNull Predicate predicate) throws OperationException {
        PredicateType predicateType = predicate.getPredicateType();
        InstancesViewAdapter instancesView = (InstancesViewAdapter)session.viewCreate(ViewType.INSTANCES, viewId, new String[0]);
        instancesView.setHidden(true);
        instancesView.setReadOnly(true);
        ProcessIdSet processes = FilterAdapterUtils.getProcesses(predicateType);
        processes = processes == null || processes.isEmpty() ? ProcessIdSet.create().addAll((List)session.processesGetIds()) : ProcessIdSet.create().addAll((List)session.processesGetAllVersions(processes));
        instancesView.unassignAllProcesses();
        instancesView.assignProcesses(processes.toArray());
        instancesView.setFilter(FilterAdapterUtils.getFilter((ProcessServiceSessionAdapter)session, predicateType));
        return instancesView;
    }

    public static oracle.bpel.services.workflow.repos.Ordering getWorkflowOrdering(@NotNull ProcessServiceSessionAdapter session, @NotNull InstancesViewAdapter view) throws OperationException {
        oracle.bpel.services.workflow.repos.Ordering workflowOrdering = null;
        Presentation presentation = session.presentationGet(view.getPresentation());
        if (presentation != null && presentation.getOrdering() != null && !presentation.getOrdering().isEmpty()) {
            workflowOrdering = ViewUtils.getWorkflowOrdering(presentation.getOrdering());
        }
        FilterAdapter filter = view.getFilter();
        if (workflowOrdering == null && filter != null && filter.getOrdering() != null && !filter.getOrdering().isEmpty()) {
            workflowOrdering = ViewUtils.getWorkflowOrdering(filter.getOrdering());
        }
        if (workflowOrdering == null) {
            try {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_RECEIVED TIME");
                workflowOrdering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            catch (WorkflowException cause) {
                throw new OperationException((Throwable)cause);
            }
        }
        return workflowOrdering;
    }

    private static oracle.bpel.services.workflow.repos.Ordering getWorkflowOrdering(@NotNull Ordering ordering) throws OperationException {
        oracle.bpel.services.workflow.repos.Ordering workflowOrdering = null;
        try {
            for (Ordering.Entry entry : ordering.toArray()) {
                Column column = VarDefinitionHelper.getColumnForVariable(entry.getVariableId());
                if (workflowOrdering == null) {
                    workflowOrdering = new oracle.bpel.services.workflow.repos.Ordering(column, entry.isAscending(), false);
                    continue;
                }
                workflowOrdering.addClause(column, entry.isAscending(), false);
            }
        }
        catch (WorkflowException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
        return workflowOrdering;
    }
}

