/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserApplicationDataType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.util.jaxb.ObjectFactory;
import oracle.bpm.papi.ora.util.jaxb.PropertiesType;
import oracle.bpm.papi.ora.util.jaxb.PropertyEntry;
import org.jetbrains.annotations.NotNull;

public class PropertiesHelper {
    public static final String PROPERTIES_TYPE = "PART_PROPS";
    private static JAXBContext jaxbContext;
    private static final Object lock;

    public static void storeProperties(ProcessServiceSessionAdapter session, String category, Map<String, Object> propertiesMap) throws OperationException {
        TreeMap<String, Object> notUpdatedProperties = new TreeMap<String, Object>();
        notUpdatedProperties.putAll(propertiesMap);
        UserApplicationDataType userAppData = PropertiesHelper.getUserApplicationData(session, category);
        PropertiesType properties = PropertiesHelper.getProperties(userAppData);
        for (PropertyEntry entry : properties.getProperty()) {
            if (!propertiesMap.containsKey(entry.getKey())) continue;
            Object newValue = propertiesMap.get(entry.getKey());
            entry.setValue(newValue.toString());
            notUpdatedProperties.remove(entry.getKey());
        }
        ObjectFactory objectFactory = new ObjectFactory();
        for (Map.Entry entry : notUpdatedProperties.entrySet()) {
            PropertyEntry propertyEntry = objectFactory.createPropertyEntry();
            propertyEntry.setKey((String)entry.getKey());
            propertyEntry.setValue(entry.getValue().toString());
            properties.getProperty().add(propertyEntry);
        }
        PropertiesHelper.storeUserApplicationData(session, userAppData, category, properties);
    }

    public static Map<String, Object> getPropertiesAsMap(ProcessServiceSessionAdapter session, @NotNull String category) throws OperationException {
        return PropertiesHelper.propertiesToMap(PropertiesHelper.getProperties(session, category));
    }

    private static PropertiesType getProperties(ProcessServiceSessionAdapter session, @NotNull String category) throws OperationException {
        return PropertiesHelper.getProperties(PropertiesHelper.getUserApplicationData(session, category));
    }

    private static PropertiesType getProperties(UserApplicationDataType userAppData) throws OperationException {
        if (userAppData != null) {
            PropertiesType properties = PropertiesHelper.xmlToProperties(userAppData.getData());
            properties.setId(userAppData.getId());
            return properties;
        }
        return new ObjectFactory().createPropertiesType();
    }

    private static UserApplicationDataType getUserApplicationData(ProcessServiceSessionAdapter session, String category) throws OperationException {
        try {
            IUserMetadataService service = session.getWorkflowServiceClient().getUserMetadataService();
            for (UserApplicationDataType userAppData : service.listUserApplicationData((IWorkflowContext)session.getBPMContext(), PROPERTIES_TYPE, null)) {
                if (!userAppData.getName().equalsIgnoreCase(category)) continue;
                return userAppData;
            }
        }
        catch (WorkflowException cause) {
            throw new OperationException((Throwable)cause);
        }
        return null;
    }

    private static Map<String, Object> propertiesToMap(PropertiesType properties) {
        List<PropertyEntry> propertyEntryList = properties.getProperty();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PropertyEntry propertyEntry : propertyEntryList) {
            map.put(propertyEntry.getKey(), propertyEntry.getValue());
        }
        return map;
    }

    private static PropertiesType xmlToProperties(String xml) {
        try {
            JAXBContext jaxbContext = PropertiesHelper.getJaxbContext();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement propertiesXML = (JAXBElement)unmarshaller.unmarshal((Reader)new StringReader(xml));
            return (PropertiesType)propertiesXML.getValue();
        }
        catch (JAXBException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
    }

    private static String propertiesToXML(PropertiesType properties) {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            StringWriter writer = new StringWriter();
            JAXBContext jaxbContext = PropertiesHelper.getJaxbContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(objectFactory.createProperties(properties), (Writer)writer);
            writer.flush();
            return writer.toString();
        }
        catch (JAXBException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
    }

    private static void storeUserApplicationData(ProcessServiceSessionAdapter session, UserApplicationDataType userAppData, String category, PropertiesType properties) throws OperationException {
        IUserMetadataService service = session.getWorkflowServiceClient().getUserMetadataService();
        UserApplicationDataType userApplicationDataType = userAppData;
        if (userApplicationDataType == null) {
            oracle.bpel.services.workflow.user.model.ObjectFactory userObjectFactory = new oracle.bpel.services.workflow.user.model.ObjectFactory();
            userApplicationDataType = userObjectFactory.createUserApplicationDataType();
        }
        userApplicationDataType.setName(category);
        userApplicationDataType.setApplicationDataType(PROPERTIES_TYPE);
        userApplicationDataType.setData(PropertiesHelper.propertiesToXML(properties));
        try {
            if (userApplicationDataType.getId() == null) {
                service.createUserApplicationData((IWorkflowContext)session.getBPMContext(), userApplicationDataType);
            } else {
                service.updateUserApplicationData((IWorkflowContext)session.getBPMContext(), userApplicationDataType);
            }
        }
        catch (WorkflowException cause) {
            throw new OperationException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getJaxbContext() throws JAXBException {
        Object object = lock;
        synchronized (object) {
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((String)PropertiesType.class.getPackage().getName());
            }
        }
        return jaxbContext;
    }

    static {
        lock = new Object();
    }
}

