/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Activity;
import fuego.papi.BatchOperationException;
import fuego.papi.EditableInstancesView;
import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.HistoryView;
import fuego.papi.InstanceInfo;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.Ordering;
import fuego.papi.Participant;
import fuego.papi.ParticipantScope;
import fuego.papi.Presentation;
import fuego.papi.ProcessServiceSession;
import fuego.papi.View;
import fuego.papi.ViewType;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.exception.InstanceNotAvailableException;
import fuego.papi.exception.InstancesException;
import fuego.papi.exception.InstancesNotAvailableInEngineException;
import fuego.papi.utils.ProcessInstance;
import fuego.papi.utils.ProcessInstanceQuery;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.InstanceInfoAdapter;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PresentationHelper;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.mgr.SessionViewManager;
import oracle.bpm.papi.ora.util.FilterQueryUtils;
import oracle.bpm.papi.ora.view.HistoryViewAdapter;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.instancemanagement.model.IProcessInstance;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import org.jetbrains.annotations.NotNull;

public class ProcessInstanceQuery11G
extends ProcessInstanceQuery.PapiImplementation {
    public ProcessInstance processGetInstance(@NotNull ProcessServiceSession session, String instanceId) throws OperationException {
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            IBPMContext bpmContext = this.getBPMContext(session);
            IInstanceQueryService service = this.getInstanceQueryService(session);
            IProcessInstance processInstance = service.getProcessInstance(bpmContext, instanceId);
            ProcessIdSet processes = ProcessIdSet.create().add(processInstance.getProcessDN());
            List<Column> displayColumns = FilterQueryUtils.getDisplayColumns((ProcessServiceSessionAdapter)session, processes);
            List threads = service.queryParallelInstances(this.getBPMContext(session), processInstance, displayColumns);
            instances.add((Object)this.getInstanceInfo(session, processInstance));
            for (IProcessInstance thread : threads) {
                instances.add((Object)this.getInstanceInfo(session, thread));
            }
        }
        catch (Exception exception) {
            throw new InstanceNotAvailableException(instanceId, (Throwable)exception);
        }
        return ProcessInstance.create((Collection)instances);
    }

    public Collection<ProcessInstance> processesGetInstancesByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
        return this.queryInstancesByFilter(session, processes, filter, null, startRow, endRow);
    }

    public int processesCountInstancesByFilter(@NotNull ProcessServiceSession session, @NotNull ProcessIdSet processes, @NotNull Filter filter) throws OperationException, BatchOperationException {
        return -1;
    }

    public InstanceInfoList processesGetInstancesThreadsByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, int startRow, int endRow) throws OperationException, BatchOperationException {
        return this.queryInstancesThreadsByFilter(session, processes, filter, null, startRow, endRow);
    }

    public int processesCountInstancesThreadsByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter) throws OperationException, BatchOperationException {
        return -1;
    }

    public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
        if (viewId == null || viewId.isEmpty()) {
            return new ArrayList<ProcessInstance>();
        }
        View view = session.viewGet(viewId);
        if (!view.getType().isType(ViewType.INSTANCES)) {
            return new ArrayList<ProcessInstance>();
        }
        return this.viewGetInstances(session, (InstancesView)view, startRow, endRow);
    }

    public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, String viewId, String sortVariable, boolean ascending) throws OperationException, BatchOperationException {
        if (viewId == null || viewId.isEmpty()) {
            return new ArrayList<ProcessInstance>();
        }
        View view = session.viewGet(viewId);
        if (!view.getType().isType(ViewType.INSTANCES)) {
            return new ArrayList<ProcessInstance>();
        }
        EditableInstancesView editView = (EditableInstancesView)session.viewEdit((View)((InstancesView)view));
        Ordering ordering = new Ordering();
        ordering.add(sortVariable, ascending);
        Filter filter = editView.getFilter();
        filter.setOrdering(ordering);
        editView.setFilter(filter);
        return this.viewGetInstances(session, (InstancesView)editView);
    }

    public Collection<ProcessInstance> viewGetInstances(ProcessServiceSession session, String viewId, String sortVariable, boolean ascending, int startRow, int endRow) throws OperationException, BatchOperationException {
        if (viewId == null || viewId.isEmpty()) {
            return new ArrayList<ProcessInstance>();
        }
        View view = session.viewGet(viewId);
        if (!view.getType().isType(ViewType.INSTANCES)) {
            return new ArrayList<ProcessInstance>();
        }
        EditableInstancesView editView = (EditableInstancesView)session.viewEdit((View)((InstancesView)view));
        Ordering ordering = new Ordering();
        ordering.add(sortVariable, ascending);
        Filter filter = editView.getFilter();
        filter.setOrdering(ordering);
        editView.setFilter(filter);
        return this.viewGetInstances(session, (InstancesView)editView, startRow, endRow);
    }

    public int viewCountInstances(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
        return -1;
    }

    public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession session, String viewId, int startRow, int endRow) throws OperationException, BatchOperationException {
        if (viewId == null || viewId.isEmpty()) {
            return InstanceInfoList.create();
        }
        View view = session.viewGet(viewId);
        if (!view.getType().isType(ViewType.INSTANCES)) {
            return InstanceInfoList.create();
        }
        return this.viewGetInstancesThreads(session, (InstancesView)view, startRow, endRow);
    }

    public int viewCountInstancesThreads(ProcessServiceSession session, String viewId) throws OperationException, BatchOperationException {
        return -1;
    }

    public Collection<ProcessInstance> viewGetInstances(@NotNull ProcessServiceSession session, InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
        if (view == null) {
            return new ArrayList<ProcessInstance>();
        }
        ProcessServiceSessionAdapter sessionAdapter = this.getSession(session);
        if (view.getType() == ViewType.HISTORY) {
            return this.getHistoryViewInstances(sessionAdapter, (HistoryView)view, startRow, endRow);
        }
        if (view.getId().startsWith("QUICK_SEARCH_FOLDER_ID")) {
            ProcessIdSet processes = ProcessIdSet.create().addAll(view.getAssignedProcesses());
            Presentation presentation = sessionAdapter.presentationGet(view.getPresentation());
            List<Column> displayColumns = this.getDisplayColumns(sessionAdapter, processes, presentation);
            return this.queryProcessInstanceQuickSearch(sessionAdapter, this.getViewQuickSearchKeyword(view), displayColumns, startRow, endRow);
        }
        Presentation presentation = sessionAdapter.presentationGet(view.getPresentation());
        if (presentation == null) {
            presentation = PresentationHelper.getDefaultInstancesPresentation();
        }
        SessionViewManager viewManager = sessionAdapter.getViewManager();
        Filter filter = viewManager.getViewFilter(view, presentation.getOrdering(), viewManager.getDefaultOrdering());
        return this.queryInstancesByFilter(sessionAdapter, ProcessIdSet.create().addAll(view.getAssignedProcesses()), filter, presentation, startRow, endRow);
    }

    public int viewCountInstances(ProcessServiceSession session, InstancesView view) throws OperationException, BatchOperationException {
        return -1;
    }

    public InstanceInfoList viewGetInstancesThreads(ProcessServiceSession session, InstancesView view, int startRow, int endRow) throws OperationException, BatchOperationException {
        if (view == null) {
            return InstanceInfoList.create();
        }
        ProcessServiceSessionAdapter sessionAdapter = this.getSession(session);
        if (view.getType() == ViewType.HISTORY) {
            return this.getHistoryViewInstanceThreads(sessionAdapter, (HistoryView)view, startRow, endRow);
        }
        if (view.getId().startsWith("QUICK_SEARCH_FOLDER_ID")) {
            return this.queryProcessInstanceThreadsQuickSearch(sessionAdapter, this.getViewQuickSearchKeyword(view), startRow, endRow);
        }
        if (view.getAssignedProcesses() == null || view.getAssignedProcesses().length == 0) {
            return InstanceInfoList.create();
        }
        Presentation presentation = sessionAdapter.presentationGet(view.getPresentation());
        if (presentation == null) {
            presentation = PresentationHelper.getDefaultInstancesPresentation();
        }
        SessionViewManager viewManager = sessionAdapter.getViewManager();
        Filter filter = viewManager.getViewFilter(view, presentation.getOrdering(), viewManager.getDefaultOrdering());
        return this.processesGetInstancesThreadsByFilter(sessionAdapter, ProcessIdSet.create().addAll(view.getAssignedProcesses()), filter, startRow, endRow);
    }

    public int viewCountInstancesThreads(ProcessServiceSession session, InstancesView view) throws OperationException, BatchOperationException {
        return -1;
    }

    public InstanceInfoList queryInstancesThreadsByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, Presentation presentation, int startRow, int endRow) throws OperationException, BatchOperationException {
        Predicate predicate;
        ProcessServiceSessionAdapter sessionAdapter = this.getSession(session);
        if (filter == null) {
            return InstanceInfoList.create();
        }
        Participant participant = session.participantCurrent();
        ParticipantScope participantScope = filter.getSearchScope().getParticipantScope();
        if (participantScope == ParticipantScope.ALL && !participant.isAdministrator()) {
            return InstanceInfoList.create();
        }
        if (participantScope == ParticipantScope.ALL_IN_ROLE) {
            return InstanceInfoList.create();
        }
        ProcessIdSet processIds = ProcessIdSet.create();
        if (processes != null) {
            for (String processId : processes) {
                processIds.addAll((List)session.processGetAllVersions(processId));
            }
        }
        if ((predicate = FilterQueryUtils.getQueryPredicate(sessionAdapter, processIds, filter)) == null) {
            return InstanceInfoList.create();
        }
        IInstanceQueryInput instanceQueryInput = FilterQueryUtils.getInstanceQueryInput(filter);
        instanceQueryInput.setStartRow(startRow);
        instanceQueryInput.setEndRow(endRow);
        List<Column> displayColumns = this.getDisplayColumns(sessionAdapter, processes, presentation);
        return this.queryProcessInstanceThreads(sessionAdapter, predicate, instanceQueryInput, FilterQueryUtils.getWorkflowOrdering(sessionAdapter, processes, filter), displayColumns, startRow, endRow);
    }

    private Collection<ProcessInstance> queryInstancesByFilter(ProcessServiceSession session, ProcessIdSet processes, Filter filter, Presentation presentation, int startRow, int endRow) throws OperationException, BatchOperationException {
        ProcessServiceSessionAdapter sessionAdapter = this.getSession(session);
        if (filter == null) {
            return new ArrayList<ProcessInstance>();
        }
        Participant participant = session.participantCurrent();
        ParticipantScope participantScope = filter.getSearchScope().getParticipantScope();
        if (participantScope == ParticipantScope.ALL && !participant.isAdministrator()) {
            return new ArrayList<ProcessInstance>();
        }
        if (participantScope == ParticipantScope.ALL_IN_ROLE) {
            return new ArrayList<ProcessInstance>();
        }
        Predicate predicate = FilterQueryUtils.getQueryPredicate(sessionAdapter, processes, filter);
        IInstanceQueryInput instanceQueryInput = FilterQueryUtils.getInstanceQueryInput(filter);
        instanceQueryInput.setStartRow(startRow);
        instanceQueryInput.setEndRow(endRow);
        List<Column> displayColumns = this.getDisplayColumns(sessionAdapter, processes, presentation);
        return this.queryProcessInstances(sessionAdapter, predicate, instanceQueryInput, FilterQueryUtils.getWorkflowOrdering(sessionAdapter, processes, filter), displayColumns, startRow, endRow);
    }

    private Collection<ProcessInstance> queryProcessInstances(@NotNull ProcessServiceSessionAdapter session, @NotNull Predicate predicate, IInstanceQueryInput queryInput, oracle.bpel.services.workflow.repos.Ordering ordering, List<Column> displayColumns, int startRow, int endRow) throws BatchOperationException, OperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            if (displayColumns == null || displayColumns.isEmpty()) {
                displayColumns = this.getDisplayColumns(session);
            }
            if (ordering == null) {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
                ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            if (queryInput == null) {
                queryInput = new InstanceQueryInput();
                queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
                queryInput.addState("OPEN");
            }
            queryInput.setStartRow(startRow);
            queryInput.setEndRow(endRow);
            IInstanceQueryService processQueryService = session.getBPMServiceClient().getInstanceQueryService();
            if (!session.getBPMContext().getIsAdmin() && queryInput.getAssignmentFilter().equals((Object)IInstanceQueryInput.AssignmentFilter.ALL)) {
                queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.OWNER);
            }
            List processInstances = processQueryService.queryProcessInstances(session.getBPMContext(), displayColumns, predicate, ordering, queryInput);
            for (IProcessInstance processInstance : processInstances) {
                if (this.isStale(session, processInstance)) continue;
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        return this.makeProcessInstance(instances, exceptions);
    }

    private boolean isStale(ProcessServiceSessionAdapter session, IProcessInstance instance) {
        boolean isStale = true;
        if (!"STALE".equals(instance.getSystemAttributes().getState())) {
            try {
                String processLabel = CompositeDNModel.parseCompositeDN((String)instance.getSca().getCompositeDN()).getLabel();
                session.processGet(instance.getProcessDN(), processLabel);
                isStale = false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return isStale;
    }

    private Collection<ProcessInstance> queryViewProcessInstances(@NotNull ProcessServiceSessionAdapter session, @NotNull String viewId, Predicate predicate, oracle.bpel.services.workflow.repos.Ordering ordering, int startRow, int endRow) throws BatchOperationException, OperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            if (ordering == null) {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
                ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            IInstanceQueryService processQueryService = session.getBPMServiceClient().getInstanceQueryService();
            List processInstances = processQueryService.queryViewProcessInstances(session.getBPMContext(), viewId, predicate, ordering, startRow, endRow);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        return this.makeProcessInstance(instances, exceptions);
    }

    private InstanceInfoList queryProcessInstanceThreads(@NotNull ProcessServiceSessionAdapter session, @NotNull Predicate predicate, IInstanceQueryInput queryInput, oracle.bpel.services.workflow.repos.Ordering ordering, List<Column> displayColumns, int startRow, int endRow) throws BatchOperationException, OperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            if (displayColumns == null || displayColumns.isEmpty()) {
                displayColumns = this.getDisplayColumns(session);
            }
            if (ordering == null) {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
                ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            if (queryInput == null) {
                queryInput = new InstanceQueryInput();
                queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
                queryInput.addState("OPEN");
            }
            queryInput.setStartRow(startRow);
            queryInput.setEndRow(endRow);
            IInstanceQueryService processQueryService = session.getBPMServiceClient().getInstanceQueryService();
            List processInstances = processQueryService.queryInstances(session.getBPMContext(), displayColumns, predicate, ordering, queryInput);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        if (!exceptions.isEmpty()) {
            InstanceInfo[] instancesArray;
            throw new InstancesException(instancesArray, exceptions, (instancesArray = (InstanceInfo[])instances.toArray((Object[])new InstanceInfo[instances.size()])).length == 0);
        }
        return instances;
    }

    private InstanceInfoList queryViewProcessInstanceThreads(@NotNull ProcessServiceSessionAdapter session, @NotNull String viewId, Predicate predicate, oracle.bpel.services.workflow.repos.Ordering ordering, int startRow, int endRow) throws BatchOperationException, OperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            if (ordering == null) {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
                ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            }
            IInstanceQueryService processQueryService = session.getBPMServiceClient().getInstanceQueryService();
            List processInstances = processQueryService.queryViewInstances(session.getBPMContext(), viewId, predicate, ordering, startRow, endRow);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        if (!exceptions.isEmpty()) {
            InstanceInfo[] instancesArray;
            throw new InstancesException(instancesArray, exceptions, (instancesArray = (InstanceInfo[])instances.toArray((Object[])new InstanceInfo[instances.size()])).length == 0);
        }
        return instances;
    }

    private InstanceInfo getInstanceInfo(@NotNull ProcessServiceSession session, @NotNull IProcessInstance processInstance) {
        try {
            return session.processGetInstance(processInstance.getSystemAttributes().getProcessInstanceId());
        }
        catch (Exception ignore) {
            try {
                return InstanceInfoAdapter.create(this.getSession(session), processInstance);
            }
            catch (OperationException initCause) {
                throw new OperationRuntimeException((Throwable)initCause);
            }
        }
    }

    private ProcessServiceSessionAdapter getSession(@NotNull ProcessServiceSession session) {
        if (!(session instanceof ProcessServiceSessionAdapter)) {
            throw new IllegalArgumentException("The sesion must be an 11g PAPI Session.");
        }
        return (ProcessServiceSessionAdapter)session;
    }

    private IInstanceQueryService getInstanceQueryService(@NotNull ProcessServiceSession session) {
        return this.getSession(session).getBPMServiceClient().getInstanceQueryService();
    }

    private IBPMContext getBPMContext(@NotNull ProcessServiceSession session) {
        return this.getSession(session).getBPMContext();
    }

    private Collection<ProcessInstance> getHistoryViewInstances(@NotNull ProcessServiceSessionAdapter session, @NotNull HistoryView view, int startRow, int endRow) throws BatchOperationException, OperationException {
        try {
            oracle.bpel.services.workflow.repos.Ordering ordering = FilterQueryUtils.getWorkflowOrdering(view.getFilter());
            String historyViewId = ((HistoryViewAdapter)view).getWorkflowId();
            if (historyViewId != null) {
                Predicate predicate = new Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 1, (Object)"STALE");
                return this.queryViewProcessInstances(session, historyViewId, predicate, ordering, startRow, endRow);
            }
            Predicate predicate = this.getHistoryViewPredicate(session, view);
            if (predicate == null) {
                return new ArrayList<ProcessInstance>();
            }
            ProcessIdSet processes = ProcessIdSet.create().addAll(view.getAssignedProcesses());
            Presentation presentation = session.presentationGet(view.getPresentation());
            List<Column> displayColumns = presentation != null ? this.getDisplayColumns(session, processes, presentation) : this.getDisplayColumns(session);
            InstanceQueryInput queryInput = new InstanceQueryInput();
            queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            queryInput.setStartRow(startRow);
            queryInput.setEndRow(endRow);
            return this.queryProcessInstances(session, predicate, (IInstanceQueryInput)queryInput, ordering, displayColumns, startRow, endRow);
        }
        catch (BatchOperationException exception) {
            throw exception;
        }
        catch (OperationException exception) {
            throw exception;
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
    }

    private InstanceInfoList getHistoryViewInstanceThreads(@NotNull ProcessServiceSessionAdapter session, @NotNull HistoryView view, int startRow, int endRow) throws BatchOperationException, OperationException {
        try {
            Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
            oracle.bpel.services.workflow.repos.Ordering ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            String historyViewId = ((HistoryViewAdapter)view).getWorkflowId();
            if (historyViewId != null) {
                Predicate predicate = new Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 1, (Object)"STALE");
                return this.queryViewProcessInstanceThreads(session, historyViewId, predicate, ordering, startRow, endRow);
            }
            Predicate predicate = this.getHistoryViewPredicate(session, view);
            if (predicate == null) {
                return InstanceInfoList.create();
            }
            ProcessIdSet processes = ProcessIdSet.create().addAll(view.getAssignedProcesses());
            Presentation presentation = session.presentationGet(view.getPresentation());
            List<Column> displayColumns = presentation != null ? this.getDisplayColumns(session, processes, presentation) : this.getDisplayColumns(session);
            InstanceQueryInput queryInput = new InstanceQueryInput();
            queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            queryInput.setStartRow(startRow);
            queryInput.setEndRow(endRow);
            return this.queryProcessInstanceThreads(session, predicate, (IInstanceQueryInput)queryInput, ordering, displayColumns, startRow, endRow);
        }
        catch (BatchOperationException exception) {
            throw exception;
        }
        catch (OperationException exception) {
            throw exception;
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
    }

    private Predicate getHistoryViewPredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull HistoryView view) throws OperationException, BPMException, WorkflowException {
        IInstanceQueryService service = session.getBPMServiceClient().getInstanceQueryService();
        TimeZone timeZone = session.getBPMContext().getTimeZone();
        timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Locale locale = session.getBPMContext().getLocale();
        locale = locale == null ? Locale.getDefault() : locale;
        Calendar endDate = Calendar.getInstance(timeZone, locale);
        endDate.setTime(Time.now().dateValue());
        Calendar startDate = this.getStartHistoryDate(session, view, endDate);
        List instances = service.getInstancesActedByAssignee(session.getBPMContext(), startDate, endDate);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        Predicate predicate = null;
        for (String instanceId : instances) {
            if (predicate == null) {
                predicate = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)instanceId);
                continue;
            }
            predicate.addClause(8, IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)instanceId);
        }
        if (predicate != null) {
            predicate = new Predicate(predicate, 7, new Predicate(IColumnConstants.PROCESS_STATE_COLUMN, 1, (Object)"STALE"));
        }
        return predicate;
    }

    private Calendar getStartHistoryDate(@NotNull ProcessServiceSessionAdapter session, @NotNull HistoryView view, @NotNull Calendar startDate) throws OperationException {
        TimeZone timeZone = session.getBPMContext().getTimeZone();
        timeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        Locale locale = session.getBPMContext().getLocale();
        locale = locale == null ? Locale.getDefault() : locale;
        Calendar endDate = Calendar.getInstance(timeZone, locale);
        endDate.setTime(startDate.getTime());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        if ("history_view/last_day".equalsIgnoreCase(view.getId())) {
            endDate.add(10, -24);
        } else if ("history_view/last_week".equalsIgnoreCase(view.getId())) {
            endDate.add(7, -7);
        } else if ("history_view/last_month".equalsIgnoreCase(view.getId())) {
            endDate.add(2, -1);
        } else if ("history_view/last_three_months".equalsIgnoreCase(view.getId())) {
            endDate.add(2, -3);
        } else {
            endDate.setTime(view.getTo().dateValue());
        }
        return endDate;
    }

    private Collection<ProcessInstance> queryProcessInstanceQuickSearch(@NotNull ProcessServiceSessionAdapter session, String keyword, List<Column> displayColumns, int startRow, int endRow) throws OperationException, BatchOperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            Predicate predicate = FilterQueryUtils.getProcessPredicate(session, ProcessIdSet.create().addAll((List)session.processesGetIds()));
            if (predicate == null) {
                return new ArrayList<ProcessInstance>();
            }
            InstanceQueryInput instanceQueryInput = new InstanceQueryInput();
            instanceQueryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
            instanceQueryInput.setKeyword(keyword);
            instanceQueryInput.setStartRow(startRow);
            instanceQueryInput.addState("OPEN");
            instanceQueryInput.setEndRow(endRow);
            Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
            oracle.bpel.services.workflow.repos.Ordering ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            IInstanceQueryService instanceQueryService = session.getBPMServiceClient().getInstanceQueryService();
            List processInstances = instanceQueryService.queryProcessInstances(session.getBPMContext(), displayColumns, predicate, ordering, (IInstanceQueryInput)instanceQueryInput);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        return this.makeProcessInstance(instances, exceptions);
    }

    private InstanceInfoList queryProcessInstanceThreadsQuickSearch(@NotNull ProcessServiceSessionAdapter session, String keyword, int startRow, int endRow) throws OperationException, BatchOperationException {
        HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
        InstanceInfoList instances = InstanceInfoList.create();
        try {
            Predicate predicate = FilterQueryUtils.getProcessPredicate(session, ProcessIdSet.create().addAll((List)session.processesGetIds()));
            if (predicate == null) {
                return InstanceInfoList.create();
            }
            InstanceQueryInput instanceQueryInput = new InstanceQueryInput();
            instanceQueryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.MY_AND_GROUP);
            instanceQueryInput.setKeyword(keyword);
            instanceQueryInput.setStartRow(startRow);
            instanceQueryInput.setEndRow(endRow);
            Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
            oracle.bpel.services.workflow.repos.Ordering ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            IInstanceQueryService instanceQueryService = session.getBPMServiceClient().getInstanceQueryService();
            List processInstances = instanceQueryService.queryInstances(session.getBPMContext(), this.getDisplayColumns(session), predicate, ordering, (IInstanceQueryInput)instanceQueryInput);
            for (IProcessInstance processInstance : processInstances) {
                instances.add((Object)InstanceInfoAdapter.create(session, processInstance));
            }
        }
        catch (Exception cause) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)cause);
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
        if (!exceptions.isEmpty()) {
            InstanceInfo[] instancesArray;
            throw new InstancesException(instancesArray, exceptions, (instancesArray = (InstanceInfo[])instances.toArray((Object[])new InstanceInfo[instances.size()])).length == 0);
        }
        return instances;
    }

    private String getViewQuickSearchKeyword(@NotNull InstancesView view) {
        String keyword = null;
        if (view.getFilter() != null) {
            for (FilterAttribute attribute : view.getFilter().getAttributes()) {
                if (attribute.getValue() == null) continue;
                if (attribute.getVariableId().equalsIgnoreCase("PREDEFINE_ACTIVITY")) {
                    keyword = Activity.getActivityName((String)attribute.getValue().toString());
                    continue;
                }
                keyword = attribute.getValue().toString();
            }
        }
        return keyword == null ? "" : keyword;
    }

    private List<Column> getDisplayColumns(@NotNull ProcessServiceSessionAdapter session) {
        ProcessIdSet processes = ProcessIdSet.create().addAll((List)session.processesGetIds());
        return FilterQueryUtils.getDisplayColumns(session, processes);
    }

    private List<Column> getDisplayColumns(@NotNull ProcessServiceSessionAdapter session, ProcessIdSet processes, Presentation presentation) {
        boolean hasProcesses;
        boolean hasColumns = presentation != null && presentation.getColumns().length > 0;
        boolean bl = hasProcesses = processes != null && !processes.isEmpty();
        if (!hasColumns && !hasProcesses) {
            processes = ProcessIdSet.create().addAll((List)session.processesGetIds());
            return FilterQueryUtils.getDisplayColumns(session, processes);
        }
        if (!hasColumns) {
            return FilterQueryUtils.getDisplayColumns(session, processes);
        }
        if (!hasProcesses) {
            processes = ProcessIdSet.create().addAll((List)session.processesGetIds());
            return FilterQueryUtils.getDisplayColumns(session, processes, presentation.getColumns());
        }
        return FilterQueryUtils.getDisplayColumns(session, processes, presentation.getColumns());
    }
}

