/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.ParticipantScope;
import fuego.papi.ProcessServiceSession;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import fuego.papi.collections.ProcessIdSet;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import oracle.bpel.services.workflow.query.model.ClauseType;
import oracle.bpel.services.workflow.query.model.ColumnType;
import oracle.bpel.services.workflow.query.model.ObjectFactory;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.query.model.TaskPredicateType;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.helper.ComparisonHelper;
import oracle.bpm.papi.ora.view.FilterAdapter;
import org.jetbrains.annotations.NotNull;

public class FilterStoragedUtils {
    private static final ObjectFactory queryModelFactory = new ObjectFactory();
    private static final String PAPI_TABLE = "FUEGO_PAPI";
    private static final String PAPI_PARTICIPANT_SCOPE_COLUMN = "FUEGO_PARTICIPANT_SCOPE";
    private static final String PAPI_STATUS_SCOPE_COLUMN = "FUEGO_STATUS_SCOPE";
    private static final String PAPI_ACTIVITY_SCOPE_COLUMN = "FUEGO_ACTIVITY_SCOPE";
    private static final String PAPI_ASSIGNED_PROCESS_COLUMN = "FUEGO_ASSIGNED_PROCESS";
    private static final String NULL = "[NULL]";

    public static TaskPredicateType getTaskPredicate(@NotNull Filter filter, @NotNull String[] processes) {
        ProcessIdSet processIdSet = ProcessIdSet.create();
        processIdSet.addAll(processes);
        return FilterStoragedUtils.getTaskPredicate(filter, processIdSet);
    }

    public static TaskPredicateType getTaskPredicate(@NotNull Filter filter, @NotNull ProcessIdSet processes) {
        TaskPredicateType taskPredicate = queryModelFactory.createTaskPredicateType();
        taskPredicate.setPredicate(FilterStoragedUtils.getPredicate(filter, processes));
        return taskPredicate;
    }

    public static PredicateType getPredicate(@NotNull Filter filter, @NotNull String[] processes) {
        ProcessIdSet processIdSet = ProcessIdSet.create();
        processIdSet.addAll(processes);
        return FilterStoragedUtils.getPredicate(filter, processIdSet);
    }

    public static PredicateType getPredicate(@NotNull Filter filter, @NotNull ProcessIdSet processes) {
        int joinOperation = filter.isMatchAll() ? 7 : 8;
        PredicateType scopeAndAttributesPredicate = queryModelFactory.createPredicateType();
        scopeAndAttributesPredicate.setLhs(FilterStoragedUtils.getSearchScopePredicate(filter.getSearchScope()));
        scopeAndAttributesPredicate.setLogicalOperator(Predicate.getOperationName((int)7));
        scopeAndAttributesPredicate.setRhs(FilterStoragedUtils.getAttributesPredicate(filter.getAttributes(), filter.isMatchAll(), filter.isCaseSensitive()));
        PredicateType subfilterPredicate = FilterStoragedUtils.getSubfiltersPredicate(filter.getFilters(), filter.isMatchAll());
        PredicateType filterPredicate = queryModelFactory.createPredicateType();
        filterPredicate.setLhs(scopeAndAttributesPredicate);
        filterPredicate.setLogicalOperator(Predicate.getOperationName((int)joinOperation));
        filterPredicate.setRhs(subfilterPredicate);
        PredicateType processPredicate = queryModelFactory.createPredicateType();
        if (!processes.isEmpty()) {
            ColumnType processColumn = queryModelFactory.createColumnType();
            processColumn.setColumnName(PAPI_ASSIGNED_PROCESS_COLUMN);
            processColumn.setTableName(PAPI_TABLE);
            for (String process : processes) {
                ClauseType clause = queryModelFactory.createClauseType();
                clause.setColumn(processColumn);
                clause.setOperator(Predicate.getOperationName((int)0));
                clause.setValue(process);
                clause.setJoinOperator(Predicate.getOperationName((int)8));
                processPredicate.getClause().add(clause);
            }
        }
        PredicateType predicate = queryModelFactory.createPredicateType();
        predicate.setLhs(processPredicate);
        predicate.setLogicalOperator(Predicate.getOperationName((int)joinOperation));
        predicate.setRhs(filterPredicate);
        return predicate;
    }

    public static ProcessIdSet getStoragedAssignedProcesses(@NotNull TaskPredicateType taskPredicate) {
        ProcessIdSet processes = ProcessIdSet.create();
        PredicateType predicate = taskPredicate.getPredicate();
        if (predicate != null && predicate.getLhs() != null) {
            for (Object clauseObject : predicate.getLhs().getClause()) {
                ClauseType clause = (ClauseType)clauseObject;
                processes.add(clause.getValue());
            }
        }
        return processes;
    }

    public static Filter getStoragedFilter(@NotNull ProcessServiceSession session, @NotNull TaskPredicateType taskPredicate) {
        PredicateType predicate = taskPredicate.getPredicate();
        if (predicate != null && predicate.getRhs() != null) {
            return FilterStoragedUtils.getStoragedFilter(session, predicate.getRhs());
        }
        return FilterAdapter.create();
    }

    public static Filter getStoragedFilter(@NotNull ProcessServiceSession session, @NotNull PredicateType predicate) {
        FilterAdapter filterAdapter = FilterAdapter.create();
        String logicalOperator = predicate.getLogicalOperator();
        if (logicalOperator != null) {
            int joinOperation = Predicate.getOperationNumber((String)logicalOperator);
            filterAdapter.setMatchAll(joinOperation == 7);
        }
        if (predicate.getLhs() != null) {
            PredicateType filterPredicate = predicate.getLhs();
            if (filterPredicate.getLhs() != null) {
                filterAdapter.setSearchScope(FilterStoragedUtils.getStoragedSearchScope(filterPredicate.getLhs()));
            }
            if (filterPredicate.getRhs() != null) {
                filterAdapter = FilterStoragedUtils.getStoragedFilterAttributes(session, filterAdapter, filterPredicate.getRhs());
            }
        }
        if (predicate.getRhs() != null) {
            filterAdapter = FilterStoragedUtils.getStoragedSubfilters(session, filterAdapter, predicate.getRhs());
        }
        return filterAdapter;
    }

    public static Object getObjectAttributeValue(int kind, String value) {
        if (value != null) {
            switch (kind) {
                case 1: {
                    return Boolean.valueOf(value);
                }
                case 3: {
                    return Double.valueOf(value);
                }
                case 2: 
                case 4: {
                    return Long.valueOf(value);
                }
                case 7: {
                    return Interval.valueOf((String)value);
                }
                case 5: {
                    return value;
                }
                case 6: {
                    try {
                        return Interval.valueOf((String)value);
                    }
                    catch (FormatException notIntervaleException) {
                        try {
                            return Time.valueOf((String)value);
                        }
                        catch (FormatException notTimeException) {
                            try {
                                Date date = DateFormat.getInstance().parse(value);
                                return Time.valueOf((Date)date);
                            }
                            catch (ParseException notDateException) {
                                throw new IllegalArgumentException("Invalid Time String value [" + value + "]");
                            }
                        }
                    }
                }
            }
            return value;
        }
        return null;
    }

    private static PredicateType getAttributesPredicate(@NotNull List<FilterAttribute> attributes, boolean matchAll, boolean caseSensitive) {
        PredicateType predicate = queryModelFactory.createPredicateType();
        for (FilterAttribute attribute : attributes) {
            predicate.getClause().add(FilterStoragedUtils.getAttributeClause(attribute, matchAll, caseSensitive));
        }
        return predicate;
    }

    private static ClauseType getAttributeClause(@NotNull FilterAttribute attribute, boolean matchAll, boolean caseSensitive) {
        int joinOperator = matchAll ? 7 : 8;
        int operation = ComparisonHelper.getWorkflowComparison(attribute.getComparison());
        ColumnType column = queryModelFactory.createColumnType();
        column.setColumnName(attribute.getVariableId());
        column.setTableName(PAPI_TABLE);
        ClauseType clause = queryModelFactory.createClauseType();
        clause.setColumn(column);
        clause.setValue(FilterStoragedUtils.getStringAttributeValue(attribute.getKind(), attribute.getValue()));
        clause.setJoinOperator(Predicate.getOperationName((int)joinOperator));
        clause.setIgnoreCase(!caseSensitive);
        clause.setOperator(Predicate.getOperationName((int)operation));
        return clause;
    }

    private static String getStringAttributeValue(int kind, Object value) {
        if (value != null) {
            switch (kind) {
                case 1: {
                    if (value instanceof Boolean) {
                        return value.toString();
                    }
                    return Boolean.FALSE.toString();
                }
                case 3: {
                    if (value instanceof Number) {
                        Double doubleValue = ((Number)value).doubleValue();
                        return doubleValue.toString();
                    }
                    return "0.0";
                }
                case 2: 
                case 4: {
                    if (value instanceof Number) {
                        Long longValue = ((Number)value).longValue();
                        return longValue.toString();
                    }
                    return "0";
                }
                case 7: {
                    if (value instanceof Interval) {
                        return value.toString();
                    }
                    return "0";
                }
                case 5: {
                    return value.toString();
                }
                case 6: {
                    if (value instanceof Time) {
                        return value.toString();
                    }
                    if (value instanceof Date) {
                        Time time = Time.valueOf((Date)((Date)value));
                        return time.toString();
                    }
                    return NULL;
                }
            }
            return value.toString();
        }
        return NULL;
    }

    private static PredicateType getSearchScopePredicate(@NotNull SearchScope searchScope) {
        ColumnType statusScopeColumn = queryModelFactory.createColumnType();
        statusScopeColumn.setColumnName(PAPI_STATUS_SCOPE_COLUMN);
        statusScopeColumn.setTableName(PAPI_TABLE);
        ClauseType statusScopeClause = queryModelFactory.createClauseType();
        statusScopeClause.setColumn(statusScopeColumn);
        statusScopeClause.setValue(searchScope.getStatusScope().name());
        statusScopeClause.setOperator(Predicate.getOperationName((int)0));
        statusScopeClause.setJoinOperator(Predicate.getOperationName((int)7));
        ColumnType participantScopeColumn = queryModelFactory.createColumnType();
        participantScopeColumn.setColumnName(PAPI_PARTICIPANT_SCOPE_COLUMN);
        participantScopeColumn.setTableName(PAPI_TABLE);
        ClauseType participantScopeClause = queryModelFactory.createClauseType();
        participantScopeClause.setColumn(participantScopeColumn);
        participantScopeClause.setValue(searchScope.getParticipantScope().name());
        participantScopeClause.setOperator(Predicate.getOperationName((int)0));
        participantScopeClause.setJoinOperator(Predicate.getOperationName((int)7));
        ClauseType activityScopeClause = null;
        if (searchScope.getActivityScope() != null && !searchScope.getActivityScope().isEmpty()) {
            ColumnType activityScopeColumn = queryModelFactory.createColumnType();
            activityScopeColumn.setColumnName(PAPI_ACTIVITY_SCOPE_COLUMN);
            activityScopeColumn.setTableName(PAPI_TABLE);
            activityScopeClause = queryModelFactory.createClauseType();
            activityScopeClause.setColumn(participantScopeColumn);
            activityScopeClause.setValue(searchScope.getActivityScope());
            activityScopeClause.setOperator(Predicate.getOperationName((int)0));
            activityScopeClause.setJoinOperator(Predicate.getOperationName((int)7));
        }
        oracle.bpel.services.workflow.query.model.Predicate predicate = queryModelFactory.createPredicate();
        predicate.getClause().add(statusScopeClause);
        predicate.getClause().add(participantScopeClause);
        if (activityScopeClause != null) {
            predicate.getClause().add(activityScopeClause);
        }
        return predicate;
    }

    private static PredicateType getSubfiltersPredicate(@NotNull List<Filter> subfilters, boolean matchAll) {
        int joinOperation = matchAll ? 7 : 8;
        PredicateType predicate = null;
        for (Filter subfilter : subfilters) {
            if (predicate == null) {
                predicate = FilterStoragedUtils.getPredicate(subfilter, ProcessIdSet.create());
                continue;
            }
            PredicateType rhs = predicate;
            predicate = queryModelFactory.createPredicateType();
            predicate.setLhs(FilterStoragedUtils.getPredicate(subfilter, ProcessIdSet.create()));
            predicate.setLogicalOperator(Predicate.getOperationName((int)joinOperation));
            predicate.setRhs(rhs);
        }
        return predicate == null ? queryModelFactory.createPredicateType() : predicate;
    }

    private static SearchScope getStoragedSearchScope(@NotNull PredicateType predicate) {
        SearchScope searchScope = new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.ONLY_INPROCESS);
        for (Object clauseObject : predicate.getClause()) {
            ClauseType clause = (ClauseType)clauseObject;
            String column = clause.getColumn().getColumnName();
            if (PAPI_PARTICIPANT_SCOPE_COLUMN.equalsIgnoreCase(column)) {
                searchScope.setParticipantScope(ParticipantScope.valueOf((String)clause.getValue()));
                continue;
            }
            if (PAPI_STATUS_SCOPE_COLUMN.equalsIgnoreCase(column)) {
                searchScope.setStatusScope(StatusScope.valueOf((String)clause.getValue()));
                continue;
            }
            if (!PAPI_ACTIVITY_SCOPE_COLUMN.equalsIgnoreCase(column)) continue;
            searchScope.setActivityScope(clause.getValue());
        }
        return searchScope;
    }

    private static FilterAdapter getStoragedFilterAttributes(@NotNull ProcessServiceSession session, @NotNull FilterAdapter filter, @NotNull PredicateType predicate) {
        for (Object clauseObject : predicate.getClause()) {
            ClauseType clause = (ClauseType)clauseObject;
            VarDefinition variable = session.variableGet(clause.getColumn().getColumnName());
            if (variable == null) continue;
            Object value = FilterStoragedUtils.getObjectAttributeValue(variable.getKind(), clause.getValue());
            int operator = Predicate.getOperationNumber((String)clause.getOperator());
            filter.addAttribute(variable, ComparisonHelper.getComparisonFromWorkflowOperator(operator), value);
        }
        return filter;
    }

    private static FilterAdapter getStoragedSubfilters(@NotNull ProcessServiceSession session, @NotNull FilterAdapter filter, @NotNull PredicateType predicate) {
        if (predicate.getLhs() == null && predicate.getRhs() == null) {
            filter.addFilter(FilterStoragedUtils.getStoragedFilter(session, predicate));
        } else {
            if (predicate.getLhs() != null) {
                filter.addFilter(FilterStoragedUtils.getStoragedFilter(session, predicate.getLhs()));
            }
            if (predicate.getRhs() != null) {
                FilterStoragedUtils.getStoragedSubfilters(session, filter, predicate.getRhs());
            }
        }
        return filter;
    }
}

