/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Activity;
import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.Ordering;
import fuego.papi.ParticipantScope;
import fuego.papi.Presentation;
import fuego.papi.Process;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.exception.NoPermissionException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.ComparisonHelper;
import oracle.bpm.papi.ora.helper.ParticipantScopeHelper;
import oracle.bpm.papi.ora.helper.PriorityHelper;
import oracle.bpm.papi.ora.helper.StatusScopeHelper;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.metadata.ActivityTypeHelper;
import oracle.bpm.papi.ora.org.ParticipantAdapter;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import org.jetbrains.annotations.NotNull;

public class FilterQueryUtils {
    private static final String ASSIGNEE_TYPE_SEPARATOR = ",";
    private static final String ASSIGNEE_USER = ",user";
    private static final List<Column> initInstanceColumns = new ArrayList<Column>();
    private static final List<Column> defaultDisplayColumns = new ArrayList<Column>();

    public static Predicate getQueryPredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull Filter filter) throws OperationException {
        try {
            Predicate filterPredicate = null;
            TreeSet<String> processedPredicates = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (String process : processes) {
                Predicate currentPredicate = FilterQueryUtils.getQueryPredicate(session, process, filter);
                if (currentPredicate == null || processedPredicates.contains(currentPredicate.toString())) continue;
                filterPredicate = filterPredicate == null ? currentPredicate : new Predicate(currentPredicate, 8, filterPredicate);
                processedPredicates.add(currentPredicate.toString());
            }
            if (filterPredicate == null && filter.isMatchAll() && !filter.getAttributes().isEmpty()) {
                return null;
            }
            filterPredicate = FilterQueryUtils.setParticipantScopePredicate(session, filter, filterPredicate);
            Predicate processPredicate = FilterQueryUtils.getProcessPredicate(session, processes);
            Predicate predicate = processPredicate == null ? filterPredicate : (filterPredicate == null ? processPredicate : new Predicate(processPredicate, 7, filterPredicate));
            return predicate;
        }
        catch (WorkflowException initCause) {
            throw new OperationException((Throwable)initCause);
        }
    }

    public static IInstanceQueryInput getInstanceQueryInput(@NotNull Filter filter) {
        ParticipantScope participantScope = filter.getSearchScope().getParticipantScope();
        StatusScope statusScope = filter.getSearchScope().getStatusScope();
        InstanceQueryInput queryInput = new InstanceQueryInput();
        queryInput.setAssignmentFilter(ParticipantScopeHelper.getOBPIAssignment(participantScope));
        for (String obpiState : StatusScopeHelper.getObpiState(statusScope)) {
            queryInput.addState(obpiState);
        }
        return queryInput;
    }

    public static Ordering getWorkflowOrdering(@NotNull Filter filter) {
        try {
            Ordering workflowOrdering = null;
            if (filter.getOrdering() != null && !filter.getOrdering().isEmpty()) {
                for (Ordering.Entry entry : filter.getOrdering().toArray()) {
                    Column column = VarDefinitionHelper.getColumnForVariable(entry.getVariableId());
                    if (workflowOrdering == null) {
                        workflowOrdering = new Ordering(column, entry.isAscending(), false);
                        continue;
                    }
                    workflowOrdering.addClause(column, entry.isAscending(), false);
                }
            } else {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_RECEIVED TIME");
                workflowOrdering = new Ordering(column, true, false);
            }
            return workflowOrdering;
        }
        catch (WorkflowException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
    }

    public static Ordering getWorkflowOrdering(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull Filter filter) {
        try {
            Ordering workflowOrdering = null;
            if (filter.getOrdering() != null && !filter.getOrdering().isEmpty()) {
                TreeSet<String> addedVariables = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (Ordering.Entry entry : filter.getOrdering().toArray()) {
                    Column column = VarDefinitionHelper.getColumnForVariable(entry.getVariableId());
                    if (column == null) {
                        for (String processId : processes) {
                            try {
                                column = VarDefinitionHelper.getColumnForVariable(session, processId, entry.getVariableId());
                            }
                            catch (OperationException e) {
                                // empty catch block
                            }
                            if (column == null || addedVariables.contains(column.getName())) continue;
                            addedVariables.add(column.getName());
                            if (workflowOrdering == null) {
                                workflowOrdering = new Ordering(column, entry.isAscending(), true);
                                continue;
                            }
                            workflowOrdering.addClause(column, entry.isAscending(), true);
                        }
                        continue;
                    }
                    if (addedVariables.contains(column.getName())) continue;
                    addedVariables.add(column.getName());
                    if (workflowOrdering == null) {
                        workflowOrdering = new Ordering(column, entry.isAscending(), true);
                        continue;
                    }
                    workflowOrdering.addClause(column, entry.isAscending(), true);
                }
            } else {
                Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_RECEIVED TIME");
                workflowOrdering = new Ordering(column, true, false);
            }
            return workflowOrdering;
        }
        catch (WorkflowException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
    }

    public static List<Column> getDisplayColumns(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull Presentation.Column[] columns) {
        TreeSet<Column> displayColumns = new TreeSet<Column>(new ColumnComparator());
        displayColumns.addAll(FilterQueryUtils.getInitInstanceColumns());
        for (String processId : processes) {
            for (Presentation.Column column : columns) {
                try {
                    Column _column = VarDefinitionHelper.getColumnForVariable(session, processId, column.getId());
                    if (_column == null) continue;
                    displayColumns.add(_column);
                }
                catch (OperationException e) {
                    // empty catch block
                }
            }
        }
        if (displayColumns.isEmpty()) {
            return FilterQueryUtils.getDisplayColumns(session, processes);
        }
        ArrayList<Column> result = new ArrayList<Column>();
        result.addAll(displayColumns);
        return result;
    }

    public static List<Column> getDisplayColumns(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes) {
        TreeSet<Column> columns = new TreeSet<Column>(new ColumnComparator());
        columns.addAll(FilterQueryUtils.getInitInstanceColumns());
        for (String processId : processes) {
            try {
                Process process = session.processGet(processId);
                for (VarDefinition variable : process.getVariables()) {
                    Column column = VarDefinitionHelper.getColumnForVariable(session, processId, variable.getId());
                    if (column == null) continue;
                    columns.add(column);
                }
            }
            catch (OperationException e) {
            }
        }
        if (columns.isEmpty()) {
            return FilterQueryUtils.getDisplayColumns();
        }
        ArrayList<Column> result = new ArrayList<Column>();
        result.addAll(columns);
        return result;
    }

    public static List<Column> getDisplayColumns() {
        return defaultDisplayColumns;
    }

    public static List<Column> getInitInstanceColumns() {
        return initInstanceColumns;
    }

    public static Predicate getProcessPredicate(ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes) throws OperationException {
        Predicate processPredicate = null;
        try {
            for (String process : processes) {
                String processDNWithLabel;
                if (processPredicate == null) {
                    processPredicate = new Predicate(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)process);
                } else {
                    processPredicate.addClause(8, IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)process);
                }
                if (session == null || (processDNWithLabel = session.getProcessManager().getProcessDNWithLabel(process)) == null) continue;
                processPredicate.addClause(8, IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN, 0, (Object)processDNWithLabel);
            }
        }
        catch (Exception initCause) {
            throw new OperationException((Throwable)initCause);
        }
        return processPredicate;
    }

    private static Predicate setParticipantScopePredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull Filter filter, Predicate filterPredicate) throws OperationException {
        ParticipantAdapter participant = (ParticipantAdapter)session.participantCurrent();
        ParticipantScope participantScope = filter.getSearchScope().getParticipantScope();
        switch (participantScope) {
            case ALL: {
                if (participant.isAdministrator()) {
                    return filterPredicate;
                }
                throw new NoPermissionException(participant.getUid());
            }
            case ALL_IN_ROLE: {
                throw new NoPermissionException(participant.getUid());
            }
        }
        return filterPredicate;
    }

    private static Predicate getQueryPredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull Filter filter) throws OperationException {
        boolean matchAll = filter.isMatchAll();
        int joinOperation = matchAll ? 7 : 8;
        Predicate predicate = null;
        if (filter.getAttributes() != null && !filter.getAttributes().isEmpty() && (predicate = FilterQueryUtils.getQueryAttributesPredicate(session, processId, filter.getAttributes(), matchAll, filter.isCaseSensitive())) == null && matchAll) {
            return null;
        }
        if (filter.getFilters() != null && !filter.getFilters().isEmpty()) {
            for (Filter subfilter : filter.getFilters()) {
                Predicate filterPredicate = FilterQueryUtils.getQueryPredicate(session, processId, subfilter);
                if (filterPredicate == null && matchAll) {
                    return null;
                }
                if (predicate == null) {
                    predicate = filterPredicate;
                    continue;
                }
                try {
                    predicate = new Predicate(predicate, joinOperation, filterPredicate);
                }
                catch (WorkflowException initCause) {
                    throw new OperationException((Throwable)initCause);
                }
            }
        }
        return predicate;
    }

    private static Predicate getQueryAttributesPredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull List<FilterAttribute> attributes, boolean matchAll, boolean caseSensitive) throws OperationException {
        int joinOperator = matchAll ? 7 : 8;
        Predicate predicate = null;
        ArrayList<Predicate> attributesPredicate = new ArrayList<Predicate>();
        for (FilterAttribute attribute : attributes) {
            if (predicate == null || FilterQueryUtils.addAttributeAsPredicate(session, processId, attribute, caseSensitive)) {
                Predicate attributePredicate = FilterQueryUtils.getQueryAttributePredicate(session, processId, attribute, caseSensitive);
                if (attributePredicate == null && matchAll) {
                    return null;
                }
                if (predicate == null) {
                    predicate = attributePredicate;
                    continue;
                }
                attributesPredicate.add(attributePredicate);
                continue;
            }
            if ((predicate = FilterQueryUtils.setQueryAttributeClause(predicate, session, processId, attribute, joinOperator, caseSensitive)) != null || !matchAll) continue;
            return null;
        }
        for (Predicate attributePredicate : attributesPredicate) {
            try {
                predicate = new Predicate(predicate, joinOperator, attributePredicate);
            }
            catch (WorkflowException initCause) {
                throw new OperationException((Throwable)initCause);
            }
        }
        return predicate;
    }

    private static Predicate setQueryAttributeClause(@NotNull Predicate predicate, @NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull FilterAttribute attribute, int joinOperator, boolean caseSensitive) throws OperationException {
        Column column = VarDefinitionHelper.getColumnForVariable(session, processId, attribute.getVariableId());
        if (column != null) {
            int comparison = ComparisonHelper.getWorkflowComparison(attribute.getComparison());
            Object value = attribute.getValue();
            Object bpelValue = null;
            if (value != null && !value.toString().isEmpty()) {
                bpelValue = FilterQueryUtils.getBpelValue(column, value);
            }
            try {
                if (bpelValue == null) {
                    switch (comparison) {
                        case 0: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 12: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 21: {
                            predicate.addClause(joinOperator, column, 21, bpelValue);
                            break;
                        }
                        default: {
                            predicate.addClause(joinOperator, column, 22, bpelValue);
                            break;
                        }
                    }
                }
                predicate.addClause(joinOperator, column, comparison, FilterQueryUtils.getSQLValue(bpelValue, comparison), caseSensitive);
            }
            catch (WorkflowException initCause) {
                throw new OperationException((Throwable)initCause);
            }
        } else if (joinOperator == 7) {
            return null;
        }
        return predicate;
    }

    private static Predicate getQueryAttributePredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull FilterAttribute attribute, boolean caseSensitive) throws OperationException {
        Column column = VarDefinitionHelper.getColumnForVariable(session, processId, attribute.getVariableId());
        if (column != null) {
            int comparison = ComparisonHelper.getWorkflowComparison(attribute.getComparison());
            Object value = attribute.getValue();
            if (comparison < 0) {
                if ((comparison == -1 || comparison == -2) && value != null && value.getClass().isArray()) {
                    Object[] arrayValue = (Object[])value;
                    Object startBpelValue = VarDefinitionHelper.getBpelVariableValue(column, arrayValue[0]);
                    Object finishBpelValue = VarDefinitionHelper.getBpelVariableValue(column, arrayValue[1]);
                    try {
                        Predicate predicate;
                        if (comparison == -1) {
                            predicate = new Predicate(column, 3, startBpelValue);
                            predicate.addClause(7, column, 5, finishBpelValue);
                        } else {
                            predicate = new Predicate(column, 4, startBpelValue);
                            predicate.addClause(8, column, 2, finishBpelValue);
                        }
                        return predicate;
                    }
                    catch (WorkflowException initCause) {
                        throw new OperationException((Throwable)initCause);
                    }
                }
                throw new OperationException((Throwable)new IllegalArgumentException("Invalid filter attribute comparison."));
            }
            if (value != null && value instanceof Interval) {
                return FilterQueryUtils.getQueryIntervalPredicate(column, comparison, (Interval)value);
            }
            Object bpelValue = null;
            if (value != null && !value.toString().isEmpty()) {
                if (column == IColumnConstants.PROCESS_ASSIGNEES_COLUMN) {
                    String stringValue;
                    String assignee = stringValue = value.toString();
                    String assigneeType = ASSIGNEE_USER;
                    int typeSeparatorIndex = assignee.lastIndexOf(ASSIGNEE_TYPE_SEPARATOR);
                    if (typeSeparatorIndex > 0) {
                        assignee = stringValue.substring(0, typeSeparatorIndex);
                        if (typeSeparatorIndex < stringValue.length()) {
                            assigneeType = stringValue.substring(typeSeparatorIndex + 1);
                        }
                    }
                    ObjectFactory objectFactory = new ObjectFactory();
                    try {
                        IdentityType identityType = objectFactory.createIdentityType();
                        identityType.setId(FilterQueryUtils.getSQLStringValue(assignee, comparison));
                        identityType.setType(assigneeType);
                        Predicate assigneeAttr = new Predicate(IColumnConstants.PROCESS_ASSIGNEEATTRIBUTE_COLUMN, comparison, identityType);
                        assigneeAttr.addClause(7, IColumnConstants.PROCESS_ASSIGNEE_TASKID_COLUMN, 0, IColumnConstants.PROCESS_ID_COLUMN);
                        return assigneeAttr;
                    }
                    catch (WorkflowException initCause) {
                        throw new OperationException((Throwable)initCause);
                    }
                }
                bpelValue = FilterQueryUtils.getBpelValue(column, value);
            }
            try {
                if (bpelValue == null) {
                    switch (comparison) {
                        case 0: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 12: 
                        case 14: 
                        case 16: 
                        case 18: 
                        case 21: {
                            return new Predicate(column, 21, bpelValue);
                        }
                    }
                    return new Predicate(column, 22, bpelValue);
                }
                return new Predicate(column, comparison, FilterQueryUtils.getSQLValue(bpelValue, comparison), caseSensitive);
            }
            catch (WorkflowException initCause) {
                throw new OperationException((Throwable)initCause);
            }
        }
        return null;
    }

    private static boolean addAttributeAsPredicate(@NotNull ProcessServiceSessionAdapter session, @NotNull String processId, @NotNull FilterAttribute attribute, boolean caseSensitive) throws OperationException {
        Column column = VarDefinitionHelper.getColumnForVariable(session, processId, attribute.getVariableId());
        if (column != null) {
            int comparison = ComparisonHelper.getWorkflowComparison(attribute.getComparison());
            Object value = attribute.getValue();
            if (!(comparison < 0 || value != null && value instanceof Interval)) {
                return value != null && !value.toString().isEmpty() && column == IColumnConstants.PROCESS_ASSIGNEES_COLUMN;
            }
        }
        return true;
    }

    private static Object getBpelValue(@NotNull Column column, @NotNull Object value) throws OperationException {
        Object bpelValue = null;
        if (column == IColumnConstants.PROCESS_ACTIVITYID_COLUMN) {
            String activity = value.toString();
            String activityName = Activity.getActivityName((String)activity);
            int indexOf = activityName.indexOf("#");
            bpelValue = activityName.substring(indexOf + 1);
        } else if (column == IColumnConstants.PROCESS_INSTANCE_PRIORITY_COLUMN) {
            if (value instanceof Number) {
                bpelValue = PriorityHelper.getBpelPriority(((Number)value).intValue());
            } else {
                try {
                    bpelValue = PriorityHelper.getBpelPriority(Integer.parseInt(value.toString()));
                }
                catch (NumberFormatException ignoreException) {}
            }
        } else if (column == IColumnConstants.PROCESS_ACTIVITYNAME_COLUMN) {
            bpelValue = value instanceof Number ? (value == null ? null : ActivityTypeHelper.getBpmnType(((Number)value).intValue()).name()) : value.toString();
        } else if (column == IColumnConstants.PROCESS_ACTIVITYTYPE_COLUMN) {
            if (value instanceof Number) {
                BpmnType bpmnType = ActivityTypeHelper.getBpmnType(((Number)value).intValue());
                bpelValue = bpmnType.name();
            } else {
                bpelValue = value.toString().toUpperCase();
            }
        } else {
            bpelValue = VarDefinitionHelper.getBpelVariableValue(column, value);
        }
        return bpelValue;
    }

    private static Predicate getQueryIntervalPredicate(@NotNull Column column, int comparison, @NotNull Interval interval) throws OperationException {
        Time now = Time.now();
        Date from = now.sub(interval).dateValue();
        Date to = now.add(interval).dateValue();
        try {
            switch (comparison) {
                case 4: {
                    return new Predicate(column, 4, (Object)from);
                }
                case 2: {
                    return new Predicate(column, 2, (Object)to);
                }
                case 5: {
                    return new Predicate(column, 5, (Object)from);
                }
                case 3: {
                    return new Predicate(column, 3, (Object)to);
                }
                case 1: {
                    return new Predicate(new Predicate(column, 4, (Object)from), 8, new Predicate(column, 2, (Object)to));
                }
            }
            return new Predicate(new Predicate(column, 3, (Object)from), 7, new Predicate(column, 5, (Object)to));
        }
        catch (WorkflowException initCause) {
            throw new OperationException((Throwable)initCause);
        }
    }

    private static Object getSQLValue(Object value, int operator) {
        if (value != null && value instanceof String) {
            return FilterQueryUtils.getSQLStringValue(value.toString(), operator);
        }
        return value;
    }

    private static String getSQLStringValue(String value, int operator) {
        String _value = "";
        switch (operator) {
            case 12: 
            case 13: {
                if (!value.startsWith("%")) {
                    _value = _value + "%";
                }
                _value = _value + value;
                if (value.endsWith("%")) break;
                _value = _value + "%";
                break;
            }
            case 14: 
            case 15: {
                _value = _value + value;
                if (value.endsWith("%")) break;
                _value = _value + "%";
                break;
            }
            case 16: 
            case 17: {
                if (!value.startsWith("%")) {
                    _value = _value + "%";
                }
                _value = _value + value;
                break;
            }
            default: {
                _value = value;
            }
        }
        return _value;
    }

    static {
        initInstanceColumns.add(IColumnConstants.PROCESS_ACTIVITYID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_ACTIVITYNAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_APPLICATIONCONTEXT_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_APPLICATIONNAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPONENTNAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPONENTTYPE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEDN_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEINSTANCEID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITENAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_COMPOSITEVERSION_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_CREATEDDATE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_CREATOR_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_DUEDATE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_ENDDATE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_EXPIRATIONDATE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_EXPIRATIONDURATION_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_ID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_IDENTITYCONTEXT_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_INSTANCEID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_MAIN_THREAD_REAL_STATE);
        initInstanceColumns.add(IColumnConstants.PROCESS_NUMBER_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_NUMBEROFTIMESMODIFIED_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_OWNERGROUP_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_OWNERROLE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_OWNERUSER_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PARENTCOMPONENTINSTANCEID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PARENTID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PARENTTHREAD_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PARENTVERSION_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PROCESSDEFINITIONNAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_PROCESSNAME_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_STATE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_STEP_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_THREAD_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_TITLE_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_VERSION_COLUMN);
        initInstanceColumns.add(IColumnConstants.PROCESS_VERSIONREASON_COLUMN);
        try {
            Field[] constantfields;
            Class<?> tableConstantsClass = Class.forName("oracle.bpm.services.instancequery.IColumnConstants");
            for (Field constantField : constantfields = tableConstantsClass.getFields()) {
                Column column;
                Class<?> constantClass = constantField.getType();
                String name = constantField.getName();
                if (!"oracle.bpel.services.workflow.repos.Column".equals(constantClass.getName()) || !name.startsWith("PROCESS_") || !(column = (Column)constantField.get(null)).getTableName().equalsIgnoreCase(IColumnConstants.PROCESS_TABLE.getName())) continue;
                defaultDisplayColumns.add(column);
            }
        }
        catch (Exception exception) {
            defaultDisplayColumns.addAll(initInstanceColumns);
        }
    }

    private static final class ColumnComparator
    implements Comparator<Column> {
        private ColumnComparator() {
        }

        @Override
        public int compare(Column leftColumn, Column rightColumn) {
            if (leftColumn == rightColumn) {
                return 0;
            }
            if (leftColumn == null) {
                return -1;
            }
            if (rightColumn == null) {
                return 1;
            }
            int compare = leftColumn.getTable().getName().compareTo(rightColumn.getTable().getName());
            return compare != 0 ? compare : leftColumn.getName().compareTo(rightColumn.getName());
        }
    }
}

