/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Comparison;
import fuego.papi.FilterAttribute;
import fuego.papi.OperationException;
import fuego.papi.ParticipantScope;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import fuego.papi.collections.ProcessIdSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpel.services.workflow.query.model.ClauseType;
import oracle.bpel.services.workflow.query.model.ColumnType;
import oracle.bpel.services.workflow.query.model.ObjectFactory;
import oracle.bpel.services.workflow.query.model.PredicateType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.ComparisonHelper;
import oracle.bpm.papi.ora.helper.PriorityHelper;
import oracle.bpm.papi.ora.helper.StatusScopeHelper;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.metadata.ActivityTypeHelper;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.FilterAttributeAdapter;
import oracle.bpm.services.instancequery.IColumnConstants;
import org.jetbrains.annotations.NotNull;

public class FilterAdapterUtils {
    private static final ObjectFactory queryModelFactory = new ObjectFactory();

    public static FilterAdapter getFilter(@NotNull ProcessServiceSessionAdapter session, @NotNull PredicateType predicate) throws OperationException {
        ProcessIdSet processes = FilterAdapterUtils.getProcesses(predicate);
        StatusScope statusScope = FilterAdapterUtils.getStatusScope(predicate);
        PredicateType filterPredicate = FilterAdapterUtils.removeProcesses(predicate);
        if (filterPredicate != null) {
            filterPredicate = FilterAdapterUtils.removeStates(filterPredicate);
        }
        FilterAdapter filter = FilterAdapter.create();
        if (filterPredicate != null) {
            filter = FilterAdapterUtils.getFilter(session, processes, filterPredicate);
        }
        filter.getSearchScope().setStatusScope(statusScope);
        if (session.getBPMContext().getIsAdmin()) {
            filter.getSearchScope().setParticipantScope(ParticipantScope.ALL);
        } else if (session.participantCurrent().isProcessOwner()) {
            filter.getSearchScope().setParticipantScope(ParticipantScope.PROCESS_ROLES);
        } else {
            filter.getSearchScope().setParticipantScope(ParticipantScope.PARTICIPANT_ROLES);
        }
        return filter;
    }

    public static StatusScope getStatusScope(@NotNull PredicateType predicate) {
        return StatusScopeHelper.getPAPIStatus((List<String>)FilterAdapterUtils.getColumnValues(predicate, IColumnConstants.PROCESS_STATE_COLUMN));
    }

    public static ProcessIdSet getProcesses(@NotNull PredicateType predicate) {
        ProcessIdSet processes = ProcessIdSet.create();
        processes.addAll((List)FilterAdapterUtils.getColumnValues(predicate, IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN));
        return processes;
    }

    private static FilterAdapter getFilter(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull PredicateType predicate) throws OperationException {
        FilterAdapter filter = FilterAdapter.create();
        if (predicate.getLogicalOperator() != null) {
            int joinOperation = Predicate.getOperationNumber((String)predicate.getLogicalOperator());
            filter.setMatchAll(joinOperation == 7);
        }
        if (predicate.getClause() != null && !predicate.getClause().isEmpty()) {
            List<FilterAttribute> attributes = FilterAdapterUtils.getAttributes(session, processes, predicate.getClause());
            for (FilterAttribute attribute : attributes) {
                filter.addAttribute(attribute);
            }
        }
        if (predicate.getLhs() != null) {
            filter.addFilter(FilterAdapterUtils.getFilter(session, processes, predicate.getLhs()));
        }
        if (predicate.getRhs() != null) {
            filter.addFilter(FilterAdapterUtils.getFilter(session, processes, predicate.getRhs()));
        }
        return filter;
    }

    private static List<FilterAttribute> getAttributes(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull List clauses) throws OperationException {
        ArrayList<FilterAttribute> filterAttributes = new ArrayList<FilterAttribute>();
        for (Object clauseObject : clauses) {
            Object value;
            ClauseType clause = (ClauseType)clauseObject;
            Column column = Column.getColumn((String)clause.getColumn().getColumnName());
            int operator = Predicate.getOperationNumber((String)clause.getOperator());
            VarDefinition variable = FilterAdapterUtils.getVarDefinition(session, processes, column);
            if (variable == null) continue;
            Comparison comparison = ComparisonHelper.getComparisonFromWorkflowOperator(operator);
            try {
                value = VarDefinitionHelper.getPapiVariableValue(clause);
            }
            catch (NumberFormatException initCause) {
                if (variable.hasRanges()) {
                    value = clause.getValue();
                }
                throw new OperationException((Throwable)initCause);
            }
            if (variable.getId().equalsIgnoreCase("PREDEFINE_PRIORITY")) {
                if (value instanceof Number) {
                    value = PriorityHelper.getPapiPriority(((Number)value).intValue());
                }
            } else if (variable.hasRanges() && (value == null && comparison != Comparison.IS_NULL && comparison != Comparison.IS_NOT_NULL || value instanceof String)) {
                Tuple<Comparison, Object> rangeCondition = FilterAdapterUtils.getRangeCondition(variable, value);
                comparison = (Comparison)rangeCondition.getFirst();
                value = rangeCondition.getSecond();
            } else if (variable.getId().equalsIgnoreCase("PREDEFINE_ACTIVITY_TYPE")) {
                value = value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(ActivityTypeHelper.getActivityType(value.toString().toUpperCase()));
            }
            filterAttributes.add(new FilterAttributeAdapter(variable, comparison, value));
        }
        return filterAttributes;
    }

    private static VarDefinition getVarDefinition(@NotNull ProcessServiceSessionAdapter session, @NotNull ProcessIdSet processes, @NotNull Column column) throws OperationException {
        ProcessIdSet searcheableProcesses = processes;
        if (searcheableProcesses.isEmpty()) {
            searcheableProcesses = ProcessIdSet.create().addAll((List)session.processesGetIds());
        }
        for (String process : searcheableProcesses) {
            VarDefinition variable = VarDefinitionHelper.getVariableForColumn(session, process, column);
            if (variable == null) continue;
            return variable;
        }
        return null;
    }

    private static Tuple<Comparison, Object> getRangeCondition(VarDefinition variable, Object value) {
        BigDecimal[] rangeValue;
        Comparison comparison;
        boolean hasMin = true;
        Object min = null;
        boolean hasMax = true;
        Object max = null;
        BigDecimal[] start = null;
        BigDecimal[] finish = null;
        for (VarDefinition.Range range : variable.getRanges()) {
            if (value != null && range.getName().equalsIgnoreCase(value.toString())) {
                start = range.getStart();
                finish = range.getFinish();
                break;
            }
            if (hasMin) {
                if (min == null || range.getStart() == null) {
                    min = range.getStart();
                    hasMin = min != null;
                } else if (range.getStart().compareTo((BigDecimal)min) < 0) {
                    min = range.getStart();
                }
            }
            if (!hasMax) continue;
            if (max == null || range.getFinish() == null) {
                max = range.getFinish();
                hasMax = max != null;
                continue;
            }
            if (range.getFinish().compareTo((BigDecimal)max) <= 0) continue;
            max = range.getFinish();
        }
        if (start == null && finish == null) {
            if (min == null && max == null) {
                throw new IllegalArgumentException("Invalid range arguments.");
            }
            if (min == null) {
                comparison = Comparison.GREATER_THAN;
                rangeValue = max;
            } else if (max == null) {
                comparison = Comparison.LESS_THAN;
                rangeValue = min;
            } else {
                comparison = Comparison.NOT_BETWEEN;
                rangeValue = new BigDecimal[]{min, max};
            }
        } else if (start == null) {
            comparison = Comparison.LESS_OR_EQUALS;
            rangeValue = finish;
        } else if (finish == null) {
            comparison = Comparison.GREATER_OR_EQUALS;
            rangeValue = start;
        } else {
            comparison = Comparison.BETWEEN;
            rangeValue = new BigDecimal[]{start, finish};
        }
        return Tuple.create((Object)comparison, rangeValue);
    }

    private static PredicateType removeProcesses(@NotNull PredicateType predicate) {
        return FilterAdapterUtils.removeColumn(predicate, IColumnConstants.PROCESS_PROCESSDEFINITIONID_COLUMN);
    }

    private static PredicateType removeStates(@NotNull PredicateType predicate) {
        return FilterAdapterUtils.removeColumn(predicate, IColumnConstants.PROCESS_STATE_COLUMN);
    }

    private static StringList getColumnValues(@NotNull PredicateType predicate, @NotNull Column column) {
        StringList values = StringList.create();
        if (predicate.getClause() != null && !predicate.getClause().isEmpty()) {
            for (Object clauseObject : predicate.getClause()) {
                String columnName;
                ClauseType clause = (ClauseType)clauseObject;
                ColumnType columnType = clause.getColumn();
                if (columnType == null || !(columnName = columnType.getColumnName()).equalsIgnoreCase(column.getName())) continue;
                values.add((Object)clause.getValue());
            }
        }
        if (predicate.getLhs() != null) {
            values.addAll((Collection)FilterAdapterUtils.getColumnValues(predicate.getLhs(), column));
        }
        if (predicate.getRhs() != null) {
            values.addAll((Collection)FilterAdapterUtils.getColumnValues(predicate.getRhs(), column));
        }
        return values;
    }

    private static PredicateType removeColumn(@NotNull PredicateType predicate, @NotNull Column column) {
        PredicateType resultPredicate = queryModelFactory.createPredicateType();
        resultPredicate.setLogicalOperator(predicate.getLogicalOperator());
        if (predicate.getClause() != null && !predicate.getClause().isEmpty()) {
            for (Object clauseObject : predicate.getClause()) {
                String columnName;
                ClauseType clause = (ClauseType)clauseObject;
                ColumnType columnType = clause.getColumn();
                if (columnType == null || (columnName = columnType.getColumnName()).equalsIgnoreCase(column.getName())) continue;
                resultPredicate.getClause().add(clause);
            }
        }
        if (predicate.getLhs() != null) {
            resultPredicate.setLhs(FilterAdapterUtils.removeColumn(predicate.getLhs(), column));
        }
        if (predicate.getRhs() != null) {
            resultPredicate.setRhs(FilterAdapterUtils.removeColumn(predicate.getRhs(), column));
        }
        if (resultPredicate.getClause() != null && !resultPredicate.getClause().isEmpty() || resultPredicate.getLhs() != null && resultPredicate.getRhs() != null) {
            return resultPredicate;
        }
        if (resultPredicate.getLhs() == null && resultPredicate.getRhs() != null) {
            return resultPredicate.getRhs();
        }
        if (resultPredicate.getLhs() != null && resultPredicate.getRhs() == null) {
            return resultPredicate.getLhs();
        }
        return null;
    }
}

