/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Arguments;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.metadata.config.model.InputParamType;
import oracle.bpel.services.workflow.metadata.config.model.TaskDisplayParamsType;
import oracle.bpel.services.workflow.metadata.config.model.WorkflowConfigurationType;
import oracle.bpel.services.workflow.metadata.taskdefinition.model.TaskDefinition;
import oracle.bpel.services.workflow.task.impl.WorkflowUtil;
import oracle.bpel.services.workflow.task.model.DisplayInfoType;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.lang.Cast;
import oracle.xml.jaxb.JaxbNode;
import org.jetbrains.annotations.NotNull;

public class ExecutionURLUtils {
    private static final String HUMAN_TASK_URL = "humanTaskURL";
    private static final String IS_11G = "is11g";
    private static final String SEVER_NAME = "serverName";
    private static final String SEVER_PORT = "serverPort";
    private static final String SEVER_SCHEME = "serverScheme";
    private static final String APPLICATION_NAME = "worklist";

    public static Arguments buildTaskDetailsArguments(IWorkflowContext iworkflowContext, Task task, Arguments inputArgs, IWorkflowServiceClient workflowServiceClient) {
        Arguments result = Arguments.create();
        if (task != null) {
            ExecutionURLUtils.setTaskDetailsURLToArgs(iworkflowContext, task, inputArgs, workflowServiceClient, result);
        }
        result.putArgument(IS_11G, (Object)Boolean.TRUE);
        return result;
    }

    private static String getConstructedURL(String hostname, String port, String uri, Map<String, String> parameters) {
        try {
            String object = hostname + ":" + port + uri;
            return ExecutionURLUtils.getConstructedURL(object, parameters);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static String getConstructedURL(String uri, Map<String, String> parameters) {
        int index1 = uri.indexOf("?");
        if (index1 >= 0) {
            String[] parameterArray;
            String parameterStr = uri.substring(index1 + 1);
            uri = uri.substring(0, index1);
            for (String p : parameterArray = parameterStr.split("&")) {
                String value;
                String name;
                if (p.contains("=")) {
                    String[] paramValue = p.split("=");
                    name = paramValue[0];
                    value = paramValue.length >= 2 ? paramValue[1] : "";
                } else {
                    name = p;
                    value = "";
                }
                parameters.put(name, value);
            }
        }
        StringBuilder buffer = new StringBuilder(uri);
        try {
            if (parameters != null) {
                if (buffer.toString().contains("?")) {
                    buffer.append("&");
                } else {
                    buffer.append("?");
                }
                Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> valuePair = it.next();
                    String name = valuePair.getKey();
                    String value = valuePair.getValue();
                    buffer.append(name).append("=").append(URLEncoder.encode(value, "UTF-8"));
                    if (!it.hasNext()) continue;
                    buffer.append("&");
                }
            }
        }
        catch (Exception exc) {
            return null;
        }
        return buffer.toString();
    }

    private static void setTaskDetailsURLToArgs(IWorkflowContext iworkflowContext, @NotNull Task task, Arguments inputArgs, IWorkflowServiceClient workflowServiceClient, Arguments outputArgs) {
        String url;
        Locale locale;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("bpmWorklistTaskId", task.getSystemAttributes().getTaskId());
        parameters.put("bpmWorklistContext", iworkflowContext.getToken());
        TimeZone timezone = iworkflowContext.getTimeZone();
        if (timezone != null) {
            parameters.put("tz", timezone.getID());
        }
        if ((locale = iworkflowContext.getLocale()) != null) {
            parameters.put("lg", locale.getLanguage());
            parameters.put("cy", locale.getCountry());
        }
        parameters.put("bpmWorklistHttpURL", (String)inputArgs.getArgument("bpmWorklistHttpURL"));
        parameters.put("bpmWorklistLogout", (String)inputArgs.getArgument("bpmWorklistLogout"));
        parameters.put("bpmWorklistLogin", (String)inputArgs.getArgument("bpmWorklistLogin"));
        if (inputArgs.containsArgument("parentURL")) {
            parameters.put("parentURL", (String)inputArgs.getArgument("parentURL"));
        }
        if (inputArgs.containsArgument("bpmBrowserWindowStatus")) {
            parameters.put("bpmBrowserWindowStatus", (String)inputArgs.getArgument("bpmBrowserWindowStatus"));
        }
        if ((url = ExecutionURLUtils.buildTaskDisplayURL(workflowServiceClient, iworkflowContext, task, APPLICATION_NAME, parameters, (String)inputArgs.getArgument(SEVER_SCHEME), (String)inputArgs.getArgument(SEVER_NAME), (String)inputArgs.getArgument(SEVER_PORT))) != null) {
            outputArgs.putArgument(HUMAN_TASK_URL, (Object)url);
        }
    }

    private static String buildTaskDisplayURL(IWorkflowServiceClient wfSvcClient, IWorkflowContext ctx, @NotNull Task taskObject, String applicationName, Map<String, String> parameters, String serverScheme, String serverName, String serverPort) {
        String instanceLvlUrl = taskObject.getTaskDisplayUrl();
        if (instanceLvlUrl != null && !instanceLvlUrl.trim().isEmpty()) {
            if (!ExecutionURLUtils.hasScheme(instanceLvlUrl)) {
                try {
                    instanceLvlUrl = serverScheme + "://" + ExecutionURLUtils.getConstructedURL(serverName, serverPort, instanceLvlUrl, ExecutionURLUtils.evaluateInputParameters(wfSvcClient, ctx, taskObject));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                instanceLvlUrl = ExecutionURLUtils.getConstructedURL(instanceLvlUrl, ExecutionURLUtils.evaluateInputParameters(wfSvcClient, ctx, taskObject));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return instanceLvlUrl;
        }
        if (applicationName == null) {
            applicationName = APPLICATION_NAME;
        }
        String taskDefinitionId = taskObject.getSystemAttributes().getTaskDefinitionId();
        String url = null;
        if (taskDefinitionId.trim().equals("http://xmlns.oracle.com/bpel/workflow/taskDefinition/DefaultToDoTaskDefinition")) {
            String urlPrefix = ExecutionURLUtils.getDefaultURLPrefix(serverScheme, serverName, serverPort);
            String pattern = taskObject.getSystemAttributes().getWorkflowPattern();
            if (pattern != null && pattern.equals("TODO")) {
                url = urlPrefix + "/DefaultToDoTaskFlow/faces/adf.task-flow?_id=DefaultToDoTaskDefinition_TaskFlow&_document=DefaultToDoTaskDefinition_TaskFlow.xml";
                url = ExecutionURLUtils.getConstructedURL(url, parameters);
            }
            return url;
        }
        List displayInfoList = taskObject.getSystemAttributes().getDisplayInfo();
        String hostName = null;
        String uri = null;
        String httpPort = null;
        String httpsPort = null;
        if (displayInfoList != null && !displayInfoList.isEmpty()) {
            DisplayInfoType info = (DisplayInfoType)displayInfoList.get(0);
            hostName = info.getHostname();
            uri = info.getUri();
            httpPort = info.getHttpPort();
            httpsPort = info.getHttpsPort();
        }
        if (hostName != null) {
            boolean ssl = (httpPort == null || httpPort.trim().isEmpty() || "0".equals(httpPort.trim())) && httpsPort != null && !httpsPort.trim().isEmpty() && !"0".equals(httpsPort.trim());
            url = ssl ? "https://" + ExecutionURLUtils.getConstructedURL(hostName, httpsPort, uri, parameters) : "http://" + ExecutionURLUtils.getConstructedURL(hostName, httpPort, uri, parameters);
        }
        return url;
    }

    private static String getDefaultURLPrefix(String serverScheme, String serverName, String serverPort) {
        return serverScheme.concat("://").concat(serverName).concat(":").concat(serverPort);
    }

    private static boolean hasScheme(String instanceLvlUrl) {
        return instanceLvlUrl.trim().startsWith("http://") || instanceLvlUrl.trim().startsWith("https://");
    }

    private static Map<String, String> evaluateInputParameters(IWorkflowServiceClient wfSvcClient, IWorkflowContext wfCtx, Task task) throws Exception {
        List inputParams;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        TaskDefinition taskDefinition = wfSvcClient.getTaskMetadataService().getTaskDefinitionById(wfCtx, task.getTaskDefinitionId(), task.getMdsLabel());
        WorkflowConfigurationType workflowConfig = taskDefinition.getWorkflowConfiguration();
        TaskDisplayParamsType taskDisplayParams = workflowConfig.getTaskDisplayParams();
        if (taskDisplayParams != null && (inputParams = (List)Cast.force((Object)taskDisplayParams.getInputParam())) != null) {
            for (InputParamType param : inputParams) {
                String paramValue;
                String paramName = param.getName();
                if ("STATIC".equals(param.getType())) {
                    paramValue = param.getValue();
                } else {
                    try {
                        paramValue = WorkflowUtil.getStringValueForXPath((String)param.getValue(), (Task)task, (JaxbNode)((JaxbNode)workflowConfig));
                    }
                    catch (Exception e) {
                        throw new WorkflowException(30065, (Object[])new String[]{"inputParam", e.getMessage(), task.getTaskDefinitionId()}, (Throwable)e);
                    }
                }
                if (paramValue == null) {
                    paramValue = "";
                }
                parameters.put(paramName, paramValue);
            }
        }
        return parameters;
    }
}

