/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Activity;
import fuego.papi.InstanceEvent;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.OperationRuntimeException;
import fuego.papi.ProcessDiagram;
import fuego.papi.ProcessServiceSession;
import fuego.papi.collections.InstanceEventList;
import fuego.papi.utils.AuditTrail;
import fuego.papi.utils.ProcessInstance;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.papi.ora.InstanceEventAdapter;
import oracle.bpm.papi.ora.InstanceInfoAdapter;
import oracle.bpm.papi.ora.ProcessDiagramAdapter;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import oracle.bpm.services.instancequery.IAuditInstance;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.util.AuditTrail;

public class AuditTrailAdapter
extends fuego.papi.utils.AuditTrail {
    private AuditTrail auditTrail;
    private Map<String, AuditTrail.AuditNode> papiNodes;
    private AuditTrail.AuditNode papiRootNode;
    private List<AuditTrail.AuditNode> papiTableNodes;

    public AuditTrailAdapter(ProcessServiceSession session, String instanceId) throws OperationException {
        super(session, instanceId);
        if (!(session instanceof ProcessServiceSessionAdapter)) {
            throw new IllegalArgumentException("The ProcessServiceSession must be an 11g session.");
        }
        this.papiNodes = new TreeMap<String, AuditTrail.AuditNode>(String.CASE_INSENSITIVE_ORDER);
    }

    public AuditTrailAdapter(String instanceId, Activity[] activities, Locale locale) {
        super(instanceId, activities, locale);
        throw new UnsupportedOperationException("Constructor not supported in 11g.");
    }

    public AuditTrail.AuditNode getNode(String id) {
        return this.papiNodes.get(id);
    }

    public AuditTrail.AuditNode getRootNode() {
        if (this.papiRootNode == null) {
            throw new IllegalStateException("AuditTrail not initialized correctly.");
        }
        return this.papiRootNode;
    }

    public List<AuditTrail.AuditNode> getAuditTableNodes() {
        return this.papiTableNodes;
    }

    @Deprecated
    public final void load(InstanceEvent[] instanceEvents) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public final void load(List<InstanceEvent> instanceEvents) {
        if (instanceEvents == null || instanceEvents.isEmpty()) {
            this.auditTrail = AuditTrail.create(new ArrayList());
        } else {
            this.instanceId = instanceEvents.get(0).getInstanceId();
        }
        try {
            this.load();
        }
        catch (OperationException operationException) {
            throw new OperationRuntimeException((Throwable)operationException);
        }
    }

    public final void load(ProcessServiceSession processServiceSession) throws OperationException {
        if (!(processServiceSession instanceof ProcessServiceSessionAdapter)) {
            throw new IllegalArgumentException("The ProcessServiceSession must be an 11g session.");
        }
        this.session = processServiceSession;
        this.load();
    }

    public final void load() throws OperationException {
        try {
            this.auditTrail = AuditTrail.create(this.getAuditInstances());
        }
        catch (BPMException causeException) {
            throw new OperationException((Throwable)causeException);
        }
        this.loadPapiNodes();
    }

    public Iterator iterator() {
        return this.getRootNode().getDescendants().iterator();
    }

    public void print(PrintStream out) {
        out.println(this.auditTrail.toString());
    }

    public String getImage(Locale locale) throws OperationException {
        if (this.session == null) {
            throw new IllegalStateException("The ProcessServiceSession must not be null");
        }
        if (!(this.session instanceof ProcessServiceSessionAdapter)) {
            throw new IllegalArgumentException("The ProcessServiceSession must be an 11g session.");
        }
        InstanceInfo instanceInfo = this.session.processGetInstance(this.instanceId);
        if (instanceInfo instanceof ProcessInstance) {
            instanceInfo = ((ProcessInstance)instanceInfo).getRoot();
        }
        if (!(instanceInfo instanceof InstanceInfoAdapter)) {
            throw new IllegalArgumentException("The ProcessServiceSession must be an 11g session.");
        }
        String processLabel = ((InstanceInfoAdapter)instanceInfo).getProcessLabel();
        try {
            ProcessServiceSessionAdapter adapter = (ProcessServiceSessionAdapter)this.session;
            ProcessAdapter process = adapter.getProcessManager().getProcess(instanceInfo.getProcessId(), processLabel);
            return this.getImage(new ProcessDiagramAdapter(process), locale);
        }
        catch (BPMException initCause) {
            throw new OperationException((Throwable)initCause);
        }
    }

    public String getImage(ProcessDiagram processDiagram, Locale locale) {
        if (!(processDiagram instanceof ProcessDiagramAdapter)) {
            throw new IllegalArgumentException("The ProcessServiceSession must be an 11g session.");
        }
        if (locale != null) {
            processDiagram.setLocale(locale);
        }
        this.highlight((ProcessDiagramAdapter)processDiagram);
        return processDiagram.getImage();
    }

    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    private void highlight(ProcessDiagramAdapter processDiagram) {
        try {
            processDiagram.highlightActivityPath(this.getEvents());
        }
        catch (BPMException initCause) {
            throw new OperationRuntimeException((Throwable)initCause);
        }
        catch (OperationException initCause) {
            throw new OperationRuntimeException((Throwable)initCause);
        }
    }

    private List<IAuditInstance> getAuditInstances() throws BPMException, OperationException {
        if (this.session == null || this.instanceId == null) {
            throw new IllegalStateException("AuditTrail not initialized correctly.");
        }
        ProcessServiceSessionAdapter sessionAdapter = (ProcessServiceSessionAdapter)this.session;
        IInstanceQueryService service = sessionAdapter.getBPMServiceClient().getInstanceQueryService();
        return service.queryAuditInstanceByProcessId(sessionAdapter.getBPMContext(), this.instanceId);
    }

    private InstanceEventList getEvents() throws BPMException, OperationException {
        if (this.session == null || this.instanceId == null) {
            throw new IllegalStateException("AuditTrail not initialized correctly.");
        }
        return this.session.instanceGetEvents(this.instanceId);
    }

    private void loadPapiNodes() {
        this.papiRootNode = null;
        this.papiNodes.clear();
        if (this.auditTrail != null) {
            this.papiRootNode = this.addPapiNode(null, this.auditTrail.getRootNode());
        }
        if (this.papiTableNodes != null) {
            this.papiTableNodes.clear();
        } else {
            this.papiTableNodes = new ArrayList<AuditTrail.AuditNode>();
        }
        List nodes = this.auditTrail.getTableNodes();
        for (AuditTrail.Node node : nodes) {
            AuditNodeAdapter papiNode = new AuditNodeAdapter(null, node);
            String activityType = node.getActivityType();
            this.papiTableNodes.add((AuditTrail.AuditNode)papiNode);
            for (AuditTrail.Node childNode : node.getChildren()) {
                String childType = childNode.getActivityType();
                if (childType == null || activityType == null || !activityType.equals(childType)) continue;
                papiNode.addChild((AuditTrail.AuditNode)new AuditNodeAdapter(null, childNode));
            }
        }
    }

    private AuditTrail.AuditNode addPapiNode(AuditTrail.AuditNode parentNode, AuditTrail.Node node) {
        AuditNodeAdapter papiNode = new AuditNodeAdapter(parentNode, node);
        this.papiNodes.put(papiNode.getId(), (AuditTrail.AuditNode)papiNode);
        for (AuditTrail.Node childNode : node.getChildren()) {
            papiNode.addChild(this.addPapiNode((AuditTrail.AuditNode)papiNode, childNode));
        }
        return papiNode;
    }

    private int getPapiNodeType(AuditTrail.NodeType nodeType) {
        switch (nodeType) {
            case FLOW_ELEMENT: {
                return 2;
            }
            case THREAD: {
                return 1;
            }
            case AUDIT: {
                return 3;
            }
            case GROUP_THREAD: {
                return 2;
            }
            case ROOT: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid oracle.bpm.services.util.AuditTrail.NodeType");
    }

    private class AuditNodeAdapter
    extends AuditTrail.AuditNode11g {
        AuditTrail.Node node;

        private AuditNodeAdapter(AuditTrail.AuditNode parentNode, AuditTrail.Node node) {
            super((fuego.papi.utils.AuditTrail)AuditTrailAdapter.this, (InstanceEvent)InstanceEventAdapter.create(node.getAuditInstance()), AuditTrailAdapter.this.getPapiNodeType(node.getType()), parentNode, node.getId());
            this.node = node;
        }

        public String getActivityName() {
            IAuditInstance auditInstance = this.node.getAuditInstance();
            if (auditInstance.getFlowElementType() != null && auditInstance.getFlowElementType().equalsIgnoreCase("PROCESS") && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_SUSPENDED && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_RESUMED && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_UPDATED) {
                return "";
            }
            switch (this.node.getType()) {
                case THREAD: 
                case GROUP_THREAD: 
                case ROOT: {
                    return "";
                }
            }
            return ((InstanceEventAdapter)this.event).getActivityId().getActivityName();
        }

        public String getActivityId() {
            IAuditInstance auditInstance = this.node.getAuditInstance();
            if (auditInstance.getFlowElementType() != null && auditInstance.getFlowElementType().equalsIgnoreCase("PROCESS") && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_SUSPENDED && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_RESUMED && auditInstance.getOperation() != AuditInstanceOperation.INSTANCE_UPDATED) {
                return "";
            }
            switch (this.node.getType()) {
                case THREAD: 
                case GROUP_THREAD: 
                case ROOT: {
                    return "";
                }
            }
            return ((InstanceEventAdapter)this.event).getActivityId().getIdString();
        }

        public String getActivityTypeString() {
            return this.node.getActivityType();
        }

        public String getEvent() {
            return this.node.getEventName(this.getLocale());
        }

        public String getDescription() {
            return this.node.getDescription();
        }

        public AuditTrail.Node getNode() {
            return this.node;
        }

        public boolean isHasPayload() {
            return this.node.getAuditInstance().hasPayload();
        }

        public long getLoopCount() {
            return this.node.getAuditInstance() != null ? this.node.getAuditInstance().getLoopCount() : 0L;
        }

        public long getInstanceCount() {
            return this.node != null ? (this.node.getAuditInstance() != null ? (this.node.getAuditInstance().getInstanceCount() != null ? this.node.getAuditInstance().getInstanceCount() : 0L) : 0L) : 0L;
        }

        public String getComment() {
            return this.node.getAuditInstance().getComment();
        }

        public String getOperation() {
            return this.node.getAuditInstance().getOperation().toString();
        }

        public String getTargetActivityId() {
            return this.node.getAuditInstance().getTargetActivity();
        }

        public String getAuditActivityLabel() {
            return this.node.getAuditInstance().getLabel();
        }

        public Long getUserTaskNumber() {
            return this.node.getAuditInstance().getUserTaskNumber() != null ? this.node.getAuditInstance().getUserTaskNumber() : 0L;
        }

        public Calendar getCreateTime() {
            return this.node.getCreateTime();
        }

        public Calendar getEndTime() {
            return this.node.getEndTime();
        }

        public String getLocation() {
            return this.node.getLocation();
        }

        public String getOutcome() {
            return this.node.getOutcome();
        }

        public Long getDuration() {
            return this.node.getDuration();
        }

        public boolean isFlowElement() {
            return this.node.getType() != null && this.node.getType().equals((Object)AuditTrail.NodeType.FLOW_ELEMENT);
        }
    }
}

