/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.util;

import fuego.papi.Arguments;
import fuego.papi.OperationException;
import fuego.papi.ProcessServiceSession;
import fuego.papi.utils.ApplicationExecution;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.ExceptionHelper;
import oracle.bpm.papi.ora.util.ExecutionURLUtils;
import oracle.bpm.services.client.IBPMServiceClient;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.instancemanagement.IInstanceManagementService;
import org.jetbrains.annotations.NotNull;

public class ApplicationExecution11G
implements ApplicationExecution.ApplicationExecutionImplementation {
    public Arguments beginExecution(@NotNull ProcessServiceSession session, @NotNull String processId, @NotNull Arguments args) throws OperationException {
        ProcessServiceSessionAdapter sessionAdapter = (ProcessServiceSessionAdapter)session;
        IBPMContext ctx = sessionAdapter.getBPMContext();
        IBPMServiceClient bpmServiceClient = sessionAdapter.getBPMServiceClient();
        IWorkflowServiceClient workflowServiceClient = sessionAdapter.getWorkflowServiceClient();
        IInstanceManagementService service = bpmServiceClient.getInstanceManagementService();
        try {
            Task task = service.createProcessInstanceTask(ctx, processId);
            args = ExecutionURLUtils.buildTaskDetailsArguments((IWorkflowContext)ctx, task, args, workflowServiceClient);
            args.putArgument("taskId", (Object)task.getSystemAttributes().getTaskId());
            return args;
        }
        catch (BPMException e) {
            throw ExceptionHelper.wrapException(e);
        }
    }
}

