/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.org;

import oracle.tip.pc.services.identity.BPMAppRole;
import org.jetbrains.annotations.NotNull;

public class RoleAdapter {
    private BPMAppRole bpmAppRole;
    private String componentName;
    private String roleName;
    public static final String PATH_SEPARTOR = ".";
    public static final String PROCESS_OWNER_ROLE = "ProcessOwner";

    private RoleAdapter(@NotNull BPMAppRole bpmAppRole) {
        this.bpmAppRole = bpmAppRole;
        this.roleName = "";
        this.componentName = "";
        String bpmAppRoleName = bpmAppRole.getName();
        if (bpmAppRoleName != null) {
            int indexOf = bpmAppRoleName.indexOf(PATH_SEPARTOR);
            if (indexOf < 1 || indexOf + 1 == bpmAppRoleName.length()) {
                this.roleName = bpmAppRoleName;
            } else {
                this.roleName = bpmAppRoleName.substring(indexOf + 1);
                this.componentName = bpmAppRoleName.substring(0, indexOf);
            }
        }
    }

    public static RoleAdapter create(@NotNull BPMAppRole bpmAppRole) {
        return new RoleAdapter(bpmAppRole);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getLabel() {
        return (this.componentName != null && !this.componentName.isEmpty() ? "[" + this.componentName + "] " : "") + this.roleName;
    }

    public BPMAppRole getBpmAppRole() {
        return this.bpmAppRole;
    }

    public boolean isProcessOwner() {
        return this.roleName.equalsIgnoreCase(PROCESS_OWNER_ROLE);
    }

    public boolean isProcessOwner(@NotNull String componentName) {
        return this.componentName.equalsIgnoreCase(componentName) && this.roleName.equalsIgnoreCase(PROCESS_OWNER_ROLE);
    }
}

