/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.org;

import fuego.papi.OperationRuntimeException;
import fuego.papi.Participant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import oracle.bpel.services.workflow.common.model.Participant;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lang.Str;
import oracle.bpm.papi.ora.helper.PrincipleRefTypeFactory;
import oracle.bpm.papi.ora.mgr.OrganizationManager;
import oracle.bpm.papi.ora.org.RoleAdapter;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityNotFoundException;
import oracle.tip.pc.services.identity.BPMUser;
import org.jetbrains.annotations.NotNull;

public class ParticipantAdapter
extends fuego.papi.Participant {
    private BPMUser bpmUser;
    private Collection<RoleAdapter> roles;
    private static final long serialVersionUID = 2208089347933343575L;
    public static final String PERMISSIONS = "ADEXPGRS";

    private ParticipantAdapter(BPMUser bpmUser, boolean isAdministrator) throws BPMIdentityException {
        super(bpmUser.getDisplayName(), bpmUser.getFirstName(), bpmUser.getLastName(), bpmUser.getName(), null, bpmUser.getEmail(), new Participant.RoleAssignment[0], isAdministrator);
        this.rolesId_d = null;
        this.bpmUser = bpmUser;
        this.roles = null;
    }

    public static ParticipantAdapter create(@NotNull BPMUser bpmUser, boolean isAdministrator) throws BPMIdentityException {
        return new ParticipantAdapter(bpmUser, isAdministrator);
    }

    public static int getPermissionValue(String permission) {
        int p = permission.length() != 1 ? -1 : PERMISSIONS.indexOf(Character.toUpperCase(permission.charAt(0)));
        return p == -1 ? -1 : 1 << p;
    }

    public static String[] getPossiblePermissions() {
        return Str.chars((String)PERMISSIONS);
    }

    public boolean hasRole(String role, String parameter) {
        return super.hasRole(role);
    }

    public BPMUser getBpmUser() {
        return this.bpmUser;
    }

    public Participant getWorkflowParticipant() {
        return PrincipleRefTypeFactory.createParticipant(this.getBpmUser().getName());
    }

    public Collection<RoleAdapter> getBPMAppRoles() {
        try {
            this.roles = ParticipantAdapter.loadBPMAppRoles(this.bpmUser);
            if (this.roles == null) {
                this.roles = new ArrayList<RoleAdapter>();
            }
        }
        catch (BPMIdentityException cause) {
            throw new OperationRuntimeException((Throwable)cause);
        }
        return this.roles;
    }

    public boolean isProcessOwner() {
        for (RoleAdapter role : this.getBPMAppRoles()) {
            if (!role.isProcessOwner()) continue;
            return true;
        }
        return false;
    }

    public boolean isProcessOwner(String processId) {
        try {
            return this.isProcessOwner(ComponentDNModel.parseComponentDN((String)processId));
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
    }

    public boolean isProcessOwner(ComponentDNModel processDN) {
        String compositeName = processDN.getCompositeDN().getCompositeName();
        for (RoleAdapter role : this.getBPMAppRoles()) {
            if (!role.isProcessOwner(compositeName)) continue;
            return true;
        }
        return false;
    }

    protected SortedStringMap<Participant.RoleAssignment> getRolesId() {
        this.rolesId_d = SortedStringMap.createCaseInsensitive();
        for (Participant.RoleAssignment role : ParticipantAdapter.getRoleAssignments(this.getBPMAppRoles(), PERMISSIONS)) {
            this.rolesId_d.put((Object)role.id, (Object)role);
        }
        return this.rolesId_d;
    }

    private static Participant.RoleAssignment[] getRoleAssignments(Collection<RoleAdapter> roles, String permissions) {
        if (roles == null) {
            return new Participant.RoleAssignment[0];
        }
        ArrayList<Participant.RoleAssignment> roleAssignments = new ArrayList<Participant.RoleAssignment>();
        for (RoleAdapter roleAdapter : roles) {
            roleAssignments.add(new Participant.RoleAssignment(roleAdapter.getBpmAppRole().getName(), -1, permissions));
        }
        return roleAssignments.toArray(new Participant.RoleAssignment[roleAssignments.size()]);
    }

    private static Collection<RoleAdapter> loadBPMAppRoles(BPMUser bpmUser) throws BPMIdentityException {
        TreeMap<String, RoleAdapter> roleAssignmentMap = new TreeMap<String, RoleAdapter>(String.CASE_INSENSITIVE_ORDER);
        try {
            for (Object roleObject : bpmUser.getAppRoles(false, OrganizationManager.APPLICATION_ROLES)) {
                BPMAppRole role = (BPMAppRole)roleObject;
                roleAssignmentMap.put(role.getName(), RoleAdapter.create(role));
            }
        }
        catch (BPMIdentityNotFoundException bPMIdentityNotFoundException) {
            // empty catch block
        }
        return roleAssignmentMap.values();
    }
}

