/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.mgr;

import fuego.papi.Activity;
import fuego.papi.ActivityView;
import fuego.papi.ApplicationsView;
import fuego.papi.AttachmentsView;
import fuego.papi.BatchOperationException;
import fuego.papi.BookmarkView;
import fuego.papi.Comparison;
import fuego.papi.ConsultationsView;
import fuego.papi.EditableView;
import fuego.papi.Filter;
import fuego.papi.HistoryView;
import fuego.papi.InstanceId;
import fuego.papi.InstanceInfo;
import fuego.papi.InstancesView;
import fuego.papi.OperationException;
import fuego.papi.Ordering;
import fuego.papi.ParticipantScope;
import fuego.papi.Presentation;
import fuego.papi.Process;
import fuego.papi.ProcessService;
import fuego.papi.SearchScope;
import fuego.papi.StatusScope;
import fuego.papi.VarDefinition;
import fuego.papi.View;
import fuego.papi.ViewOperationException;
import fuego.papi.ViewType;
import fuego.papi.collections.ActivityList;
import fuego.papi.collections.AttachmentList;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.exception.AttachmentsNotAvailableException;
import fuego.papi.exception.AttachmentsNotAvailableInProcessException;
import fuego.papi.exception.InstancesException;
import fuego.papi.exception.InstancesNotAvailableInEngineException;
import fuego.papi.exception.InvalidViewTypeException;
import fuego.papi.exception.ViewHasChildrenException;
import fuego.papi.exception.ViewNotFoundException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleRefType;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.model.UserViewDetail;
import oracle.bpel.services.workflow.user.model.ViewGrantType;
import oracle.bpel.services.workflow.user.model.ViewSummaryType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PresentationHelper;
import oracle.bpm.papi.ora.helper.PrincipleRefTypeFactory;
import oracle.bpm.papi.ora.helper.VarDefinitionHelper;
import oracle.bpm.papi.ora.helper.ViewHelper;
import oracle.bpm.papi.ora.view.ApplicationsViewAdapter;
import oracle.bpm.papi.ora.view.FilterAdapter;
import oracle.bpm.papi.ora.view.HistoryViewAdapter;
import oracle.bpm.papi.ora.view.InstancesViewAdapter;
import oracle.bpm.papi.ora.view.PresentationAdapter;
import oracle.bpm.papi.ora.view.ViewAdapter;
import oracle.bpm.services.instancequery.IColumnConstants;
import oracle.bpm.services.instancequery.IInstanceQueryInput;
import oracle.bpm.services.instancequery.IInstanceQueryService;
import oracle.bpm.services.instancequery.impl.InstanceQueryInput;
import org.jetbrains.annotations.NotNull;

public class SessionViewManager {
    private transient SortedMap<String, View> cache = null;
    private Ordering defaultOrdering = new Ordering();
    private boolean refresh = true;
    private ProcessServiceSessionAdapter session = null;
    private static final VarDefinition varProcessId = VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_PROCESS");
    private static final VarDefinition varInstanceIn = VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_INSTANCE NUMBER");
    private static final VarDefinition varThreadIn = VarDefinition.getDefaultVarDefinition((String)"PREDEFINE_COPY");
    private static final char NEXT_CHAR = '\u00ff';
    protected static String LAST_VIEW_ACCESS_CAT = "fuego-lastViewAccess";

    public SessionViewManager(ProcessServiceSessionAdapter session) {
        this.session = session;
    }

    public void setDefaultOrdering(Ordering defaultOrdering) {
        this.defaultOrdering = defaultOrdering;
    }

    public Ordering getDefaultOrdering() {
        return this.defaultOrdering;
    }

    public Map<String, View> getChildrenViews(String viewId) {
        return this.getCache().subMap(viewId + "/", viewId + "/" + '\u00ff');
    }

    public EditableView getEditableView(View view) {
        ViewAdapter editView = ((ViewAdapter)view).copy();
        editView.setCustom(true);
        editView.setOwner(this.session.participantCurrent().getUid());
        editView.setTransient(true);
        this.put((View)editView);
        return editView;
    }

    public Collection<String> getViewsIds() {
        TreeSet<String> ids = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ids.addAll(this.getCache().keySet());
        return ids;
    }

    public View getParentView(String viewId) {
        String parentViewId = ViewAdapter.getParentId(viewId);
        return (View)this.getCache().get(parentViewId);
    }

    public Collection<View> getViews() {
        HashSet<View> views = new HashSet<View>();
        views.addAll(this.getCache().values());
        return views;
    }

    public boolean containsView(String viewId) {
        return this.getCache().containsKey(viewId);
    }

    public EditableView createView(ViewType viewType, String viewId, String[] assignedProcesses) throws OperationException {
        if (viewType == ViewType.ACTIVITY_INSTANCES || viewType == ViewType.BOOKMARKS || viewType == ViewType.CONSULTATIONS || viewType == ViewType.HISTORY) {
            throw new ViewOperationException(viewId);
        }
        ViewAdapter view = ViewAdapter.create(viewType, viewId, this.session.participantCurrent().getUid());
        view.setTransient(true);
        view.setCustom(true);
        view.assignProcesses(assignedProcesses);
        this.put((View)view);
        return view;
    }

    public synchronized void deleteView(String viewId) {
        Object entry = this.getCache().remove(viewId);
        if (entry != null) {
            this.refresh();
        }
    }

    public View getView(String viewId) throws OperationException {
        if (viewId == null) {
            throw new ViewNotFoundException(viewId);
        }
        View view = (View)this.getCache().get(viewId);
        if (view == null) {
            throw new ViewNotFoundException(viewId);
        }
        return view;
    }

    public View getView(String viewId, ViewType expectedType) throws OperationException {
        View view = this.getView(viewId);
        if (view.getType() != expectedType) {
            throw new InvalidViewTypeException(view.getType(), expectedType);
        }
        return view;
    }

    public boolean hasViews() {
        return !this.getCache().isEmpty();
    }

    public synchronized void put(View view) {
        TreeMap<String, Object> views = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        views.put(view.getId(), view);
        String parentViewId = ViewAdapter.getParentId(view.getId());
        while (parentViewId != null) {
            if (!this.getCache().containsKey(parentViewId)) {
                ViewAdapter parentView = ViewAdapter.create(ViewType.FOLDER, parentViewId, this.session.participantCurrent().getUid());
                parentView.setTransient(true);
                views.put(parentView.getId(), parentView);
            }
            parentViewId = ViewAdapter.getParentId(parentViewId);
        }
        this.getCache().putAll(views);
    }

    public void refresh() {
        this.refresh = true;
    }

    public void release() {
        this.cache = new TreeMap<String, View>(String.CASE_INSENSITIVE_ORDER);
        this.refresh();
    }

    public void removeView(String viewId, boolean checkForChildren) throws OperationException {
        if (checkForChildren && this.viewHasChildren(viewId)) {
            String owner = this.session.participantCurrent().getUid();
            Map<String, View> children = this.getChildrenViews(viewId);
            for (View view : children.values()) {
                if (!view.getOwner().equalsIgnoreCase(owner)) continue;
                throw new ViewHasChildrenException(viewId);
            }
        }
        this.removeView(viewId);
    }

    public AttachmentList getAttachmentsForView(AttachmentsView view) throws BatchOperationException {
        AttachmentList attachments = AttachmentList.create();
        HashMap<String, AttachmentsNotAvailableInProcessException> errors = new HashMap<String, AttachmentsNotAvailableInProcessException>();
        ProcessIdSet viewAssignedProcesses = ProcessIdSet.create().addAll(view.getAssignedProcesses());
        for (String processId : this.session.processesGetAllVersions(viewAssignedProcesses)) {
            try {
                AttachmentList _attachments = this.session.processGetWorkingAttachments(processId);
                attachments.addAll((Collection)_attachments);
            }
            catch (OperationException exception) {
                errors.put(processId, new AttachmentsNotAvailableInProcessException(processId, (Throwable)exception));
            }
        }
        if (!errors.isEmpty()) {
            throw new AttachmentsNotAvailableException((List)attachments, errors);
        }
        return attachments;
    }

    public synchronized void removeView(String viewId) throws OperationException {
        try {
            InstancesViewAdapter instancesView;
            View view = (View)this.getCache().get(viewId);
            if (view instanceof InstancesViewAdapter && (instancesView = (InstancesViewAdapter)view).getWorkflowId() != null) {
                this.session.getWorkflowServiceClient().getUserMetadataService().deleteUserTaskView((IWorkflowContext)this.session.getBPMContext(), instancesView.getWorkflowId());
            }
        }
        catch (WorkflowException e) {
            throw new OperationException((Throwable)e);
        }
        this.deleteView(viewId);
    }

    public synchronized void storeView(View view) throws OperationException {
        if (view.isReadOnly() && !view.getOwner().equalsIgnoreCase(this.session.participantCurrent().getUid())) {
            throw new ViewOperationException(view.getId());
        }
        View cacheView = (View)this.getCache().get(view.getId());
        if (cacheView != null && cacheView.getType() != view.getType()) {
            throw new InvalidViewTypeException(view.getType(), cacheView.getType());
        }
        ViewAdapter storedView = ((ViewAdapter)view).copy();
        storedView.setCustom(true);
        storedView.setTransient(false);
        storedView.setOwner(this.session.participantCurrent().getUid());
        storedView.unassignAllProcesses();
        storedView.assignProcesses(this.getAllVersions(view.getAssignedProcesses()));
        if (storedView instanceof InstancesViewAdapter) {
            try {
                UserViewDetail storedUserViewDetail;
                IUserMetadataService service = this.session.getWorkflowServiceClient().getUserMetadataService();
                IBPMContext workflowContext = this.session.getBPMContext();
                Presentation presentation = this.session.presentationGet(storedView.getPresentation());
                String workflowId = ((InstancesViewAdapter)view).getWorkflowId();
                if ((workflowId == null || workflowId.isEmpty()) && cacheView != null) {
                    workflowId = ((InstancesViewAdapter)cacheView).getWorkflowId();
                }
                UserViewDetail userViewDetail = ((InstancesViewAdapter)storedView).getUserViewDetail();
                userViewDetail.setId(workflowId);
                userViewDetail.setPresentationId(((PresentationAdapter)presentation).getWorkflowId());
                if (workflowId == null) {
                    PrincipleRefType owner = PrincipleRefTypeFactory.createPrincipleRefParticipant("");
                    owner.setName(this.session.getBPMContext().getUser());
                    owner.setRealm(this.session.getBPMContext().getIdentityContext());
                    userViewDetail.setOwner(owner);
                    storedUserViewDetail = service.createUserTaskView((IWorkflowContext)workflowContext, userViewDetail);
                } else {
                    storedUserViewDetail = service.updateUserTaskView((IWorkflowContext)workflowContext, userViewDetail);
                }
                if (storedUserViewDetail != null) {
                    ((InstancesViewAdapter)storedView).setUserViewDetail(this.session, storedUserViewDetail);
                }
            }
            catch (WorkflowException e) {
                throw new ViewOperationException(e.getMessage());
            }
        }
        this.put((View)storedView);
    }

    public View getParentView(View view) throws OperationException {
        String parentViewId = view.getParentId();
        if (parentViewId == null) {
            return null;
        }
        View parentView = this.getView(parentViewId);
        if (parentView == null) {
            parentView = this.createView(ViewType.FOLDER, parentViewId, view.getAssignedProcesses());
        }
        return parentView;
    }

    public View updateView(View view, StringList processes) {
        Presentation presentation = this.session.presentationGet(view.getPresentation());
        ViewAdapter editView = ((ViewAdapter)view).copy();
        editView.setTransient(view.isTransient());
        editView.setPresentation(presentation == null ? null : presentation.getId());
        ProcessIdSet viewAssignedProcesses = ProcessIdSet.create().addAll(view.getAssignedProcesses());
        editView.unassignAllProcesses();
        editView.assignProcesses(this.session.processesGetAllVersions(viewAssignedProcesses, processes).toArray());
        return editView;
    }

    public boolean viewHasChildren(String viewId) {
        Map<String, View> children = this.getChildrenViews(viewId);
        return children != null && !children.isEmpty();
    }

    public ActivityList getActivityForView(ActivityView view) {
        String[] processIds;
        ActivityList activities = ActivityList.create();
        String activityName = view.getActivityName();
        for (String processId : processIds = view.getAssignedProcesses()) {
            try {
                Activity activity;
                Process process = this.session.processGet(processId);
                if (process == null || (activity = process.getActivity(activityName)) == null) continue;
                activities.add((Object)activity);
            }
            catch (OperationException e) {
                Log.logWarning((Throwable)e);
            }
        }
        return activities;
    }

    public ActivityList getApplicationsForView(ApplicationsView view) throws OperationException, BatchOperationException {
        ProcessIdSet processes = ProcessIdSet.create();
        processes.addAll(view.getAssignedProcesses());
        return this.session.processesGetApplications(processes);
    }

    public Filter getViewFilter(InstancesView view, Ordering presentationOrdering, Ordering sessionDefaultOrdering) throws OperationException, BatchOperationException {
        Filter filter;
        switch (view.getType()) {
            case BOOKMARKS: {
                filter = this.viewMakeBookmarkFilter((BookmarkView)view);
                break;
            }
            case CONSULTATIONS: {
                filter = this.viewMakeConstultationsFilter((ConsultationsView)view);
                break;
            }
            case HISTORY: {
                filter = ProcessService.createFilter();
                break;
            }
            default: {
                filter = view.getFilter();
            }
        }
        if (filter != null) {
            Ordering filterOrdering = filter.getOrdering();
            if (filterOrdering != null && filterOrdering.getEntryCount() > 0) {
                if (presentationOrdering != null && presentationOrdering.getEntryCount() > 0) {
                    int size = presentationOrdering.getEntryCount();
                    for (int i = 0; i < size; ++i) {
                        Ordering.Entry orderingEntry = presentationOrdering.getEntry(i);
                        filterOrdering.add(orderingEntry.getVariableId(), orderingEntry.isAscending());
                    }
                }
            } else {
                filterOrdering = presentationOrdering != null && presentationOrdering.getEntryCount() > 0 ? presentationOrdering : sessionDefaultOrdering;
            }
            filter.setOrdering(filterOrdering);
        }
        return filter;
    }

    public InstanceInfoList getInstancesByView(InstancesView view) throws OperationException, BatchOperationException {
        Filter filter;
        switch (view.getType()) {
            case HISTORY: {
                return this.getInstancesByHistoryView((HistoryView)view);
            }
        }
        Presentation presentation = this.session.presentationGet(view.getPresentation());
        if (presentation == null) {
            presentation = PresentationHelper.getDefaultInstancesPresentation();
        }
        if ((filter = this.getViewFilter(view, presentation.getOrdering(), this.defaultOrdering)) != null) {
            ProcessIdSet processes = ProcessIdSet.create();
            processes.addAll(this.getAllVersions(view.getAssignedProcesses()));
            return this.session.processesGetInstancesByFilter(processes, filter);
        }
        return InstanceInfoList.create();
    }

    public View refreshView(String viewId) throws OperationException {
        View view = this.getView(viewId);
        if (view == null) {
            throw new ViewNotFoundException(viewId);
        }
        this.deleteView(viewId);
        return this.getView(viewId);
    }

    private String[] getAllVersions(String[] processIds) {
        if (processIds == null || processIds.length == 0) {
            return new String[0];
        }
        ProcessIdSet processIdSet = ProcessIdSet.create().addAll(processIds);
        StringList versions = this.session.processesGetAllVersions(processIdSet);
        if (versions == null) {
            return new String[0];
        }
        return (String[])versions.toArray((Object[])new String[versions.size()]);
    }

    private InstanceInfoList getInstancesByHistoryView(HistoryView view) throws BatchOperationException {
        try {
            IInstanceQueryService service = this.session.getBPMServiceClient().getInstanceQueryService();
            Calendar startDate = Calendar.getInstance(this.session.participantLocale());
            startDate.setTime(Time.now().dateValue());
            Calendar endDate = this.getEndHistoryDate(view, startDate);
            List instances = service.getInstancesActedByAssignee(this.session.getBPMContext(), startDate, endDate);
            if (instances == null || instances.isEmpty()) {
                return InstanceInfoList.create();
            }
            Predicate predicate = null;
            for (String instanceId : instances) {
                if (predicate == null) {
                    predicate = new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)instanceId);
                    continue;
                }
                predicate = new Predicate(predicate, 8, new Predicate(IColumnConstants.PROCESS_ID_COLUMN, 0, (Object)instanceId));
            }
            Column column = VarDefinitionHelper.getColumnForVariable("PREDEFINE_CREATION TIME");
            oracle.bpel.services.workflow.repos.Ordering ordering = new oracle.bpel.services.workflow.repos.Ordering(column, true, false);
            InstanceQueryInput queryInput = new InstanceQueryInput();
            queryInput.setAssignmentFilter(IInstanceQueryInput.AssignmentFilter.ALL);
            queryInput.addState("OPEN");
            return this.session.processesGetInstancesByPredicate(predicate, (IInstanceQueryInput)queryInput, ordering);
        }
        catch (Exception causeException) {
            InstancesNotAvailableInEngineException exception = new InstancesNotAvailableInEngineException("Engine", (Throwable)causeException);
            HashMap<String, InstancesNotAvailableInEngineException> exceptions = new HashMap<String, InstancesNotAvailableInEngineException>();
            exceptions.put(exception.getEngineName(), exception);
            throw new InstancesException(new InstanceInfo[0], exceptions, true);
        }
    }

    private Calendar getEndHistoryDate(@NotNull HistoryView view, @NotNull Calendar startDate) throws OperationException {
        Calendar endDate = Calendar.getInstance(this.session.participantLocale());
        endDate.setTime(startDate.getTime());
        endDate.set(10, 0);
        endDate.set(12, 0);
        endDate.set(13, 0);
        if ("history_view/last_day".equalsIgnoreCase(view.getId())) {
            endDate.add(10, -24);
        } else if ("history_view/last_week".equalsIgnoreCase(view.getId())) {
            endDate.add(7, -7);
        } else if ("history_view/last_month".equalsIgnoreCase(view.getId())) {
            endDate.add(2, -1);
        } else if ("history_view/last_three_months".equalsIgnoreCase(view.getId())) {
            endDate.add(2, -3);
        } else {
            endDate.setTime(view.getTo().dateValue());
        }
        return endDate;
    }

    private Filter viewMakeBookmarkFilter(BookmarkView view) throws OperationException {
        StringList instances = this.session.instancesGetBookmarks();
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        FilterAdapter bookmarkFilter = FilterAdapter.create();
        bookmarkFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
        bookmarkFilter.setMatchAll(true);
        Filter viewFilter = view.getFilter();
        bookmarkFilter.addFilter(viewFilter);
        FilterAdapter refineFilter = FilterAdapter.create();
        refineFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
        refineFilter.setMatchAll(false);
        for (String instanceId : instances) {
            String processId = InstanceId.getLocalProcessId((String)instanceId);
            int instanceIn = InstanceId.getInstanceIn((String)instanceId);
            int threadIn = InstanceId.getThreadIn((String)instanceId);
            FilterAdapter instanceFilter = FilterAdapter.create();
            instanceFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
            instanceFilter.setMatchAll(true);
            instanceFilter.addAttribute(varProcessId, Comparison.IS, processId);
            instanceFilter.addAttribute(varInstanceIn, Comparison.IS, instanceIn);
            instanceFilter.addAttribute(varThreadIn, Comparison.IS, threadIn);
            refineFilter.addFilter(instanceFilter);
        }
        bookmarkFilter.addFilter(refineFilter);
        return bookmarkFilter;
    }

    private Filter viewMakeConstultationsFilter(ConsultationsView view) throws OperationException {
        StringList instances = this.session.instancesGetConsults();
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        FilterAdapter consultationFilter = FilterAdapter.create();
        consultationFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
        consultationFilter.setMatchAll(true);
        Filter viewFilter = view.getFilter();
        consultationFilter.addFilter(viewFilter);
        FilterAdapter refineFilter = FilterAdapter.create();
        refineFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
        refineFilter.setMatchAll(false);
        for (String instanceId : instances) {
            String processId = InstanceId.getLocalProcessId((String)instanceId);
            int instanceIn = InstanceId.getInstanceIn((String)instanceId);
            int threadIn = InstanceId.getThreadIn((String)instanceId);
            FilterAdapter instanceFilter = FilterAdapter.create();
            instanceFilter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
            instanceFilter.setMatchAll(true);
            instanceFilter.addAttribute(varProcessId, Comparison.IS, processId);
            instanceFilter.addAttribute(varInstanceIn, Comparison.IS, instanceIn);
            instanceFilter.addAttribute(varThreadIn, Comparison.IS, threadIn);
            refineFilter.addFilter(instanceFilter);
        }
        consultationFilter.addFilter(refineFilter);
        return consultationFilter;
    }

    private SortedMap<String, View> getCache() {
        if (this.refresh || this.cache == null) {
            this.fill();
        }
        return this.cache;
    }

    private synchronized void fill() {
        InstancesViewAdapter viewAdapter;
        UserViewDetail view;
        this.refresh = false;
        TreeMap<String, ViewAdapter> views = new TreeMap<String, ViewAdapter>(String.CASE_INSENSITIVE_ORDER);
        IUserMetadataService service = this.session.getWorkflowServiceClient().getUserMetadataService();
        IBPMContext workflowContext = this.session.getBPMContext();
        try {
            List grantedViews = service.listGrantedUserViews((IWorkflowContext)workflowContext, IUserMetadataService.UserTaskViewType.PROCESS_VIEW, null, IUserMetadataService.UserTaskViewGrantType.SHARE_DEFINITION, false);
            for (ViewGrantType viewGrant : grantedViews) {
                view = service.getUserTaskViewDetails((IWorkflowContext)workflowContext, viewGrant.getViewId());
                viewAdapter = ViewAdapter.createInstancesView(this.session, view);
                if (viewAdapter.getAssignedProcesses() == null || viewAdapter.getAssignedProcesses().length == 0) {
                    viewAdapter.assignProcesses(this.session.processesGetIds().toArray());
                }
                views.put(viewAdapter.getId(), viewAdapter);
            }
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            List userViews = service.listUserViews((IWorkflowContext)workflowContext, IUserMetadataService.UserTaskViewType.PROCESS_VIEW, null);
            for (ViewSummaryType summaryView : userViews) {
                view = service.getUserTaskViewDetails((IWorkflowContext)workflowContext, summaryView.getId());
                viewAdapter = ViewAdapter.createInstancesView(this.session, view);
                if (viewAdapter.getAssignedProcesses() == null || viewAdapter.getAssignedProcesses().length == 0) {
                    viewAdapter.assignProcesses(this.session.processesGetIds().toArray());
                }
                views.put(viewAdapter.getId(), viewAdapter);
            }
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        String[] processIds = new String[]{};
        InstancesViewAdapter inboxView = ViewHelper.getDefaultInboxView(processIds);
        ApplicationsViewAdapter applicationsView = ViewHelper.getDefaultApplicationsView(processIds);
        views.put(inboxView.getId(), inboxView);
        views.put(applicationsView.getId(), applicationsView);
        try {
            List standardViews = service.listUserViews((IWorkflowContext)workflowContext, IUserMetadataService.UserTaskViewType.STDPROCESS_VIEW, null);
            List<ViewAdapter> historyViews = ViewHelper.getDefaultHitoryViews();
            for (ViewSummaryType viewSummaryType : standardViews) {
                UserViewDetail userViewDetail = service.getUserTaskViewDetails((IWorkflowContext)workflowContext, viewSummaryType.getId());
                for (ViewAdapter viewAdapter2 : historyViews) {
                    if (userViewDetail.getName().equals("MY_UPDATED_PROCESSES_1DAY") && viewAdapter2.getId().equals("history_view/last_day")) {
                        ((HistoryViewAdapter)viewAdapter2).setBpelId(userViewDetail.getId());
                        continue;
                    }
                    if (userViewDetail.getName().equals("MY_UPDATED_PROCESSES_1WEEK") && viewAdapter2.getId().equals("history_view/last_week")) {
                        ((HistoryViewAdapter)viewAdapter2).setBpelId(userViewDetail.getId());
                        continue;
                    }
                    if (userViewDetail.getName().equals("MY_UPDATED_PROCESSES_30DAYS") && viewAdapter2.getId().equals("history_view/last_month")) {
                        ((HistoryViewAdapter)viewAdapter2).setBpelId(userViewDetail.getId());
                        continue;
                    }
                    if (!userViewDetail.getName().equals("MY_UPDATED_PROCESSES_90DAYS") || !viewAdapter2.getId().equals("history_view/last_three_months")) continue;
                    ((HistoryViewAdapter)viewAdapter2).setBpelId(userViewDetail.getId());
                }
            }
            for (ViewAdapter viewAdapter2 : historyViews) {
                views.put(viewAdapter2.getId(), viewAdapter2);
            }
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        if (this.cache != null) {
            for (View view3 : this.cache.values()) {
                if (!view3.isTransient() || !view3.getOwner().equals(this.session.participantCurrent().getUid()) || view3.getType() == ViewType.FOLDER && this.getChildrenViews(view3.getId()).isEmpty()) continue;
                views.put(view3.getId(), (ViewAdapter)view3);
            }
        }
        StringList processes = StringList.EMPTY;
        TreeMap<String, View> updatedViews = new TreeMap<String, View>(String.CASE_INSENSITIVE_ORDER);
        for (View view2 : views.values()) {
            if (view2.getAssignedProcesses().length <= 0 && !view2.getOwner().equalsIgnoreCase(this.session.participantCurrent().getUid()) && view2.getType() != ViewType.FOLDER && view2.isCustom()) continue;
            updatedViews.put(view2.getId(), this.updateView(view2, processes));
        }
        this.cache = updatedViews;
    }
}

