/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.mgr;

import fuego.papi.Activity;
import fuego.papi.BatchOperationException;
import fuego.papi.OperationException;
import fuego.papi.ProcessNotAvailableException;
import fuego.papi.collections.ActivityList;
import fuego.papi.collections.ElementIdSet;
import fuego.papi.collections.ProcessIdSet;
import fuego.papi.collections.ProcessList;
import fuego.papi.exception.ApplicationsNotAvailableException;
import fuego.papi.exception.ApplicationsNotAvailableInProcessException;
import fuego.papi.exception.ProcessNotFoundException;
import fuego.papi.exception.ProcessesNotAvailableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabelType;
import oracle.bpel.services.workflow.runtimeconfig.model.PayloadMappingType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.metadata.GlobalCreationActivityAdapter;
import oracle.bpm.papi.ora.metadata.GlobalCreationLightActivity;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.services.common.exception.BPMException;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.common.model.CompositeDNModel;
import oracle.bpm.services.internal.processmodel.IProcessModelService;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import oracle.bpm.services.processmetadata.IProcessMetadataService;
import oracle.bpm.services.processmetadata.ProcessMetadataSummary;
import oracle.bpm.services.processmetadata.StatusEnum;
import org.jetbrains.annotations.NotNull;

public class SessionProcessManager {
    private transient Map<String, DeployedProcess> deployedProcesses;
    private boolean refresh = true;
    private ProcessServiceSessionAdapter session;
    private static final Object LOCK = new Object();
    private static final String SUBTYPE_CALLABLE = "CALLABLE";
    private static final int PROCESSCACHE_SIZE_DEFAULT = 200;
    private static final int VARMAPPINGCACHE_SIZE_DEFAULT = 500;
    private static final LRUCache<String, ProcessAdapter> cache = new LRUCache(200);
    private static final LRUCache<String, Map<String, String>> variableMappingCache = new LRUCache(500);

    private SessionProcessManager(ProcessServiceSessionAdapter session) {
        this.session = session;
    }

    public static SessionProcessManager create(@NotNull ProcessServiceSessionAdapter session) {
        return new SessionProcessManager(session);
    }

    public static void cleanStaticCaches() {
        if (cache != null) {
            cache.clear();
        }
        if (variableMappingCache != null) {
            variableMappingCache.clear();
        }
    }

    public void refresh() {
        this.refresh = true;
    }

    public StringList getProcessIds() throws BPMException, OperationException {
        return this.getProcessIds(StatusEnum.ACTIVE, StatusEnum.RETIRED, StatusEnum.SUSPENDED);
    }

    public StringList getActiveProcessIds() throws BPMException, OperationException {
        return this.getProcessIds(StatusEnum.ACTIVE);
    }

    public ProcessAdapter getProcess(@NotNull String processId, String label) throws OperationException, BPMException {
        if (label == null || label.trim().isEmpty()) {
            return this.getProcess(processId);
        }
        ComponentDNModel processDN = ComponentDNModel.parseComponentDN((String)processId);
        CompositeDNModel compositeDN = CompositeDNModel.buildCompositeDN((String)processDN.getCompositeDN().getApplicationName(), (String)processDN.getCompositeDN().getCompositeName(), (String)processDN.getCompositeDN().getRevision(), (String)label);
        ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)processDN.getCompositeDN().getApplicationName(), (String)processDN.getCompositeDN().getCompositeName(), (String)processDN.getCompositeDN().getRevision(), (String)label, (String)processDN.getComponentName());
        ComponentDNModel revisionDN = componentDN.getComponentRevisionDN();
        DeployedProcess deployedProcess = this.getDeployedProcesses().get(revisionDN.getDNString());
        if (deployedProcess == null || !deployedProcess.getMDSLabel().equals(label)) {
            try {
                IProcessMetadataService service = this.session.getBPMServiceClient().getProcessMetadataService();
                ProcessMetadataSummary processSummary = service.getProcessMetadataSummary(this.session.getBPMContext(), compositeDN.getDNString(), componentDN.getComponentName());
                if (processSummary == null) {
                    throw new ProcessNotFoundException(componentDN.getDNString());
                }
                deployedProcess = new DeployedProcess();
                deployedProcess.setComponentDN(componentDN.getComponentRevisionDN());
                deployedProcess.setMDSLabel(label);
            }
            catch (BPMException initCause) {
                throw new OperationException((Throwable)initCause);
            }
        } else {
            componentDN = revisionDN;
        }
        return SessionProcessManager.getProcess(this.session, componentDN, deployedProcess);
    }

    public ProcessAdapter getProcess(@NotNull String processId) throws OperationException, BPMException {
        ComponentDNModel componentDN = ComponentDNModel.parseComponentDN((String)processId).getComponentRevisionDN();
        DeployedProcess deployedProcess = this.getDeployedProcesses().get(componentDN.getDNString());
        if (deployedProcess == null) {
            this.refresh();
            deployedProcess = this.getDeployedProcesses().get(componentDN.getDNString());
        }
        if (deployedProcess == null) {
            throw new ProcessNotAvailableException(processId);
        }
        return SessionProcessManager.getProcess(this.session, componentDN, deployedProcess);
    }

    public ProcessList getProcesses() throws BatchOperationException {
        StringList processIds;
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        try {
            processIds = this.getProcessIds();
        }
        catch (Exception cause) {
            exceptions.put("All processes", cause);
            throw new ProcessesNotAvailableException((List)ProcessList.create(), exceptions);
        }
        ProcessList processList = ProcessList.create();
        for (String processId : processIds) {
            try {
                processList.add((Object)this.getProcess(processId));
            }
            catch (ProcessNotAvailableException cause) {
                exceptions.put(processId, cause);
            }
            catch (OperationException cause) {
                exceptions.put(processId, new ProcessNotAvailableException(processId, (Throwable)cause));
            }
            catch (BPMException cause) {
                exceptions.put(processId, new ProcessNotAvailableException(processId, (Throwable)cause));
            }
        }
        if (exceptions.size() > 0) {
            throw new ProcessesNotAvailableException((List)processList, exceptions);
        }
        return processList;
    }

    public ProcessIdSet getVersions(@NotNull String processId, @NotNull StringList processIds) throws BPMException {
        ComponentDNModel componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)processId);
        ProcessIdSet processes = ProcessIdSet.create();
        for (String _processId : processIds) {
            ComponentDNModel _componentDN = ComponentDNModel.parseConsolidatedComponentDN((String)_processId);
            if (componentDN.compareConsolidatedDNTo(_componentDN) != 0) continue;
            processes.add(_processId);
        }
        return processes;
    }

    public ProcessIdSet getAllVersions(@NotNull String processId) throws BPMException, OperationException {
        return this.getVersions(processId, this.getProcessIds());
    }

    public ProcessIdSet getAllVersions(@NotNull ProcessIdSet processes) throws BPMException, OperationException {
        StringList processIds = this.getProcessIds();
        ProcessIdSet processIdSet = ProcessIdSet.create();
        for (String processId : processes) {
            processIdSet.addAll((ElementIdSet)this.getVersions(processId, processIds));
        }
        return processIdSet;
    }

    public ProcessIdSet getActiveVersions(@NotNull String processId) throws BPMException, OperationException {
        return this.getVersions(processId, this.getActiveProcessIds());
    }

    public ActivityList getApplications(@NotNull ProcessIdSet processes) throws BatchOperationException {
        ActivityList applications = ActivityList.create();
        TreeMap<String, ApplicationsNotAvailableInProcessException> exceptions = new TreeMap<String, ApplicationsNotAvailableInProcessException>();
        try {
            Map<String, DeployedProcess> _deployedProcesses = this.getDeployedProcesses();
            for (String processId : processes) {
                Collection<Activity> globalActivities;
                DeployedProcess deployedProcess = _deployedProcesses.get(processId);
                String mdsPartition = deployedProcess == null ? null : deployedProcess.getComponentDN().getCompositeDN().getApplicationName();
                if ("Player".equals(mdsPartition) || deployedProcess == null || deployedProcess.getStatus() == StatusEnum.SUSPENDED || (globalActivities = deployedProcess.getGlobalActivities().values()) == null || globalActivities.isEmpty()) continue;
                for (Activity aGlobalActivity : globalActivities) {
                    aGlobalActivity.setIsDefaultRevision(deployedProcess.isIsDefaultRevision());
                }
                ProcessAdapter process = this.getProcess(processId);
                if (process == null) {
                    applications.addAll(globalActivities);
                    continue;
                }
                for (Activity globalActivity : globalActivities) {
                    Activity processGlobalActivity = process.getActivity(globalActivity.getName());
                    processGlobalActivity.setIsDefaultRevision(deployedProcess.isIsDefaultRevision());
                    if (processGlobalActivity == null) {
                        globalActivity.setIsDefaultRevision(deployedProcess.isIsDefaultRevision());
                        applications.add((Object)globalActivity);
                        continue;
                    }
                    processGlobalActivity.setCategory(globalActivity.getCategory());
                    ((GlobalCreationActivityAdapter)processGlobalActivity).setTagList(((GlobalCreationLightActivity)globalActivity).getTagList());
                    ((GlobalCreationActivityAdapter)processGlobalActivity).setApplicationLinkDisplayName(((GlobalCreationLightActivity)globalActivity).getApplicationLinkDisplayName());
                    applications.add((Object)processGlobalActivity);
                }
            }
        }
        catch (Exception causeException) {
            for (String processId : processes) {
                exceptions.put(processId, new ApplicationsNotAvailableInProcessException(processId, (Throwable)causeException));
            }
        }
        if (exceptions.isEmpty()) {
            return applications;
        }
        throw new ApplicationsNotAvailableException((List)applications, exceptions);
    }

    public String getProcessDNWithLabel(String processId) throws Exception {
        if (processId.indexOf("*") < 0) {
            return null;
        }
        ProcessAdapter processAdapter = this.getProcess(processId);
        if (processAdapter == null || processAdapter.getMDSLabel() == null || processAdapter.getMDSLabel().equals("")) {
            return null;
        }
        String dnWithLabel = null;
        try {
            String label = processAdapter.getMDSLabel();
            ComponentDNModel withoutLabelModel = processAdapter.getProcessComponentDN();
            dnWithLabel = withoutLabelModel.getCompositeDN().getApplicationName() + "/" + withoutLabelModel.getCompositeDN().getCompositeName() + '!' + withoutLabelModel.getCompositeDN().getRevision() + "*" + label + "/" + withoutLabelModel.getComponentName();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        return dnWithLabel;
    }

    public Map<String, String> getVariableMapping(@NotNull String processId) throws OperationException {
        Map<String, String> mappings = variableMappingCache.get(processId.toUpperCase());
        if (mappings == null) {
            mappings = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                String processDNWithLabel;
                IRuntimeConfigService svc = this.session.getWorkflowServiceClient().getRuntimeConfigService();
                List payloadMappingsList = svc.getBPMProcessPayloadMappings((IWorkflowContext)this.session.getBPMContext(), processId);
                if (payloadMappingsList.size() == 0 && (processDNWithLabel = this.getProcessDNWithLabel(processId)) != null) {
                    payloadMappingsList = svc.getBPMProcessPayloadMappings((IWorkflowContext)this.session.getBPMContext(), processDNWithLabel);
                }
                for (PayloadMappingType payloadMapping : payloadMappingsList) {
                    AttributeLabelType attributeLabel = payloadMapping.getLabel();
                    if (payloadMapping.getPayloadAttribute() == null || attributeLabel == null || attributeLabel.getTaskAttribute() == null) continue;
                    mappings.put(payloadMapping.getPayloadAttribute(), attributeLabel.getTaskAttribute());
                }
                variableMappingCache.put(processId.toUpperCase(), mappings);
            }
            catch (Exception cause) {
                throw new OperationException((Throwable)cause);
            }
        }
        return mappings;
    }

    public void release() {
        this.deployedProcesses = new TreeMap<String, DeployedProcess>(String.CASE_INSENSITIVE_ORDER);
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessAdapter getProcess(@NotNull ProcessServiceSessionAdapter session, @NotNull ComponentDNModel componentDN, @NotNull DeployedProcess deployedProcess) throws OperationException, BPMException {
        Object object;
        boolean isRevisionDN = componentDN.getCompositeDN().getLabel() == null || componentDN.getCompositeDN().getLabel().trim().isEmpty();
        String componentDNStr = componentDN.getDNString();
        ProcessAdapter processAdapter = cache.get(componentDNStr);
        if (processAdapter != null && isRevisionDN) {
            variableMappingCache.invalidate(componentDNStr.toUpperCase());
            if (!processAdapter.getMDSLabel().equals(deployedProcess.getMDSLabel())) {
                object = LOCK;
                synchronized (object) {
                    cache.put(componentDNStr, null);
                }
            }
        }
        if (processAdapter == null) {
            object = LOCK;
            synchronized (object) {
                processAdapter = cache.get(componentDNStr);
                if (processAdapter == null) {
                    IProcessModelPackage modelPackage;
                    try {
                        IProcessModelService service = session.getBPMServiceClient().getProcessModelService();
                        modelPackage = service.getProcessModel(session.getBPMContext(), componentDN.getCompositeDN().getDNString(), componentDN.getComponentName());
                    }
                    catch (RuntimeException initCause) {
                        throw new ProcessNotAvailableException(componentDNStr, (Throwable)initCause);
                    }
                    if (modelPackage == null) {
                        throw new ProcessNotFoundException(componentDNStr);
                    }
                    processAdapter = new ProcessAdapter(componentDN, modelPackage, deployedProcess.getMDSLabel());
                    processAdapter.getProcess().setDefaultLabel(deployedProcess.getDefaultLabel());
                    cache.put(componentDNStr, processAdapter);
                }
            }
            processAdapter.setIsActive(deployedProcess.getStatus() == StatusEnum.ACTIVE);
        }
        return processAdapter;
    }

    private StringList getProcessIds(StatusEnum ... statusEnums) throws BPMException, OperationException {
        StringList processIds = StringList.create();
        for (ComponentDNModel componentDN : this.getProcessesComponentDN(statusEnums)) {
            processIds.add((Object)componentDN.getDNString());
        }
        return processIds;
    }

    private List<ComponentDNModel> getProcessesComponentDN(StatusEnum ... statusEnums) throws BPMException, OperationException {
        ArrayList<ComponentDNModel> processes = new ArrayList<ComponentDNModel>();
        block0: for (DeployedProcess deployedProcess : this.getDeployedProcesses().values()) {
            for (StatusEnum statusEnum : statusEnums) {
                if (deployedProcess.getStatus() != null && deployedProcess.getStatus() != statusEnum) continue;
                processes.add(deployedProcess.getComponentDN());
                continue block0;
            }
        }
        return processes;
    }

    private Map<String, DeployedProcess> getDeployedProcesses() throws BPMException, OperationException {
        if (this.refresh || this.deployedProcesses == null) {
            this.fillDeployedProcesses();
        }
        return this.deployedProcesses;
    }

    private void fillDeployedProcesses() throws BPMException, OperationException {
        this.refresh = false;
        TreeMap<String, DeployedProcess> _deployedProcesses = new TreeMap<String, DeployedProcess>(String.CASE_INSENSITIVE_ORDER);
        IProcessMetadataService service = this.session.getBPMServiceClient().getProcessMetadataService();
        List processes = service.listProcessMetadataSummary(this.session.getBPMContext(), null, null, null);
        for (ProcessMetadataSummary process : processes) {
            if (SUBTYPE_CALLABLE.equals(process.getSubType())) continue;
            DeployedProcess deployedProcess = DeployedProcess.create(process);
            _deployedProcesses.put(deployedProcess.getComponentDN().getDNString(), deployedProcess);
        }
        List applicationProcesses = service.getInitiatableProcesses(this.session.getBPMContext());
        for (ProcessMetadataSummary applicationProcess : applicationProcesses) {
            boolean hasUri;
            if (SUBTYPE_CALLABLE.equals(applicationProcess.getSubType())) continue;
            boolean bl = hasUri = applicationProcess.isSetTaskDisplayInfo() && applicationProcess.getTaskDisplayInfo().isSetUri() && !applicationProcess.getTaskDisplayInfo().getUri().isEmpty();
            if (applicationProcess.getStatus() != StatusEnum.ACTIVE || !hasUri) continue;
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)applicationProcess.getDomainName(), (String)applicationProcess.getCompositeName(), (String)applicationProcess.getRevision(), (String)"", (String)applicationProcess.getProcessName());
            DeployedProcess deployedProcess = (DeployedProcess)_deployedProcesses.get(componentDN.getDNString());
            if (deployedProcess == null) {
                deployedProcess = DeployedProcess.create(applicationProcess);
                _deployedProcesses.put(deployedProcess.getComponentDN().getDNString(), deployedProcess);
            }
            Activity activity = this.getGlobalActivity(applicationProcess);
            deployedProcess.setDefaultLabel(applicationProcess.getProcessLabel());
            if (activity == null) continue;
            deployedProcess.addGlobalActivity(activity);
        }
        this.deployedProcesses = _deployedProcesses;
    }

    private Activity getGlobalActivity(@NotNull ProcessMetadataSummary processSummary) throws BPMException, OperationException {
        boolean isInLane;
        boolean hasGlobalCreationTask = processSummary.isSetHasGlobalCreationTasks() && processSummary.isHasGlobalCreationTasks() != false;
        boolean bl = isInLane = processSummary.isSetHasSwimlaneRole() && processSummary.isHasSwimlaneRole() != false;
        if (hasGlobalCreationTask && isInLane) {
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)processSummary.getDomainName(), (String)processSummary.getCompositeName(), (String)processSummary.getRevision(), (String)processSummary.getLabel(), (String)processSummary.getProcessName());
            String activityName = GlobalCreationActivityAdapter.getGlobalActivityName(processSummary.getGlobalCreationTaskActivityName());
            String label = "[" + processSummary.getCompositeName() + "]" + processSummary.getProcessName() + " v" + processSummary.getRevision();
            return GlobalCreationLightActivity.create(componentDN, componentDN.getComponentName(), activityName, label, processSummary.getApplicationLinkDisplayName(), processSummary.getCategory(), processSummary.getTagList());
        }
        return null;
    }

    private static class DeployedProcess
    implements Comparable<DeployedProcess> {
        private ComponentDNModel componentDN;
        private String defaultLabel;
        private Map<String, Activity> globalActivities;
        private boolean isDefaultRevision = false;
        private String mdsLabel = null;
        private StatusEnum status;

        private DeployedProcess() {
        }

        public static DeployedProcess create(@NotNull ProcessMetadataSummary process) {
            ComponentDNModel componentDN = ComponentDNModel.buildComponentDN((String)process.getDomainName(), (String)process.getCompositeName(), (String)process.getRevision(), (String)"", (String)process.getProcessName());
            DeployedProcess deployedProcess = new DeployedProcess();
            deployedProcess.setComponentDN(componentDN);
            deployedProcess.setStatus(process.getStatus());
            deployedProcess.setMDSLabel(process.getLabel());
            deployedProcess.setGlobalActivities(new TreeMap<String, Activity>(String.CASE_INSENSITIVE_ORDER));
            if (process.isSetIsDefaultRevision()) {
                deployedProcess.setIsDefaultRevision(process.isIsDefaultRevision());
            } else {
                deployedProcess.setIsDefaultRevision(false);
            }
            return deployedProcess;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public void setDefaultLabel(String defaultLabel) {
            this.defaultLabel = defaultLabel;
        }

        public ComponentDNModel getComponentDN() {
            return this.componentDN;
        }

        public void setComponentDN(ComponentDNModel componentDN) {
            this.componentDN = componentDN;
        }

        public StatusEnum getStatus() {
            return this.status;
        }

        public void setStatus(StatusEnum status) {
            this.status = status;
        }

        public void setMDSLabel(String label) {
            this.mdsLabel = label;
        }

        public String getMDSLabel() {
            return this.mdsLabel;
        }

        public Map<String, Activity> getGlobalActivities() {
            return this.globalActivities;
        }

        public void setGlobalActivities(Map<String, Activity> globalActivities) {
            this.globalActivities = globalActivities;
        }

        public void addGlobalActivity(Activity globalActivity) {
            this.globalActivities.put(globalActivity.getName(), globalActivity);
        }

        @Override
        public int compareTo(DeployedProcess deployedProcess) {
            if (deployedProcess == null) {
                return 1;
            }
            if (this == deployedProcess) {
                return 0;
            }
            return this.getComponentDN().compareTo(deployedProcess.getComponentDN());
        }

        public void setIsDefaultRevision(boolean isDefaultRevision) {
            this.isDefaultRevision = isDefaultRevision;
        }

        public boolean isIsDefaultRevision() {
            return this.isDefaultRevision;
        }
    }

    public static class LRUCache<K, V> {
        private int cacheSize;
        private LinkedHashMap<K, V> map;
        private static final float hashTableLoadFactor = 0.75f;

        public LRUCache(int cacheSize) {
            this.cacheSize = cacheSize;
            int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
            this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > LRUCache.this.cacheSize;
                }
            };
        }

        public synchronized V get(K key) {
            return this.map.get(key);
        }

        public synchronized void put(K key, V value) {
            this.map.put(key, value);
        }

        public synchronized void clear() {
            this.map.clear();
        }

        public synchronized int usedEntries() {
            return this.map.size();
        }

        public synchronized Collection<Map.Entry<K, V>> getAll() {
            return new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
        }

        public synchronized void invalidate(K componentDNStr) {
            this.map.remove(componentDNStr);
        }
    }
}

