/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.mgr;

import fuego.papi.EditablePresentation;
import fuego.papi.OperationException;
import fuego.papi.Presentation;
import fuego.papi.ViewOperationException;
import fuego.papi.exception.CannotRemoveViewException;
import java.util.Collection;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpel.services.bpm.common.IBPMContext;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.common.model.PrincipleListType;
import oracle.bpel.services.workflow.common.model.PrincipleListTypeImpl;
import oracle.bpel.services.workflow.common.model.PrincipleRefTypeImpl;
import oracle.bpel.services.workflow.user.IUserMetadataService;
import oracle.bpel.services.workflow.user.impl.UserMetadataUtil;
import oracle.bpel.services.workflow.user.model.PresentationType;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.helper.PresentationHelper;
import oracle.bpm.papi.ora.view.PresentationAdapter;
import oracle.bpm.services.common.logger.BPMLogger;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMUser;

public class SessionPresentationManager {
    private transient SortedMap<String, Presentation> cache = null;
    private boolean refresh = true;
    private ProcessServiceSessionAdapter session = null;
    private transient SortedMap<String, String> workflowPapiMapping = null;

    public SessionPresentationManager(ProcessServiceSessionAdapter session) {
        this.session = session;
    }

    public Collection<String> getIds() {
        TreeSet<String> ids = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ids.addAll(this.getCache().keySet());
        return ids;
    }

    public Collection<String> getIds(fuego.papi.PresentationType presentationType) {
        TreeSet<String> ids = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Presentation presentation : this.getCache().values()) {
            if (presentation.getType() != presentationType) continue;
            ids.add(presentation.getId());
        }
        return ids;
    }

    public Collection<Presentation> getPresentations() {
        HashSet<Presentation> presentations = new HashSet<Presentation>();
        presentations.addAll(this.getCache().values());
        return presentations;
    }

    public boolean containsPresentation(String presentationId) {
        return this.getCache().containsKey(presentationId);
    }

    public Presentation createPresentation(fuego.papi.PresentationType presentationType, String presentationId, Presentation.Column[] columns) throws ViewOperationException {
        PresentationAdapter presentation = PresentationAdapter.create(presentationType, presentationId, columns, this.session.participantCurrent().getUid());
        this.put((Presentation)presentation);
        return presentation;
    }

    public EditablePresentation getEditablePresentation(Presentation presentation) {
        PresentationAdapter editPresentation = null;
        String participant = this.session.participantCurrent().getUid();
        if (!presentation.isReadOnly() || presentation.getOwner().equalsIgnoreCase(participant)) {
            editPresentation = ((PresentationAdapter)presentation).copy();
            this.put((Presentation)editPresentation);
        }
        return editPresentation;
    }

    public synchronized void delete(String presentationId) {
        this.getCache().remove(presentationId);
        Presentation defaultPresentation = PresentationHelper.getDefaultPresentation(presentationId);
        if (defaultPresentation != null) {
            this.getCache().put(defaultPresentation.getId(), defaultPresentation);
        }
    }

    public void remove(String presentationId) throws ViewOperationException {
        try {
            Presentation presentation = this.get(presentationId);
            if (presentation != null && ((PresentationAdapter)presentation).getWorkflowId() != null) {
                IBPMContext bpmContext = this.session.getBPMContext();
                String workflowId = ((PresentationAdapter)presentation).getWorkflowId();
                this.session.getWorkflowServiceClient().getUserMetadataService().deletePresentation((IWorkflowContext)bpmContext, workflowId);
            }
        }
        catch (WorkflowException cause) {
            throw new CannotRemoveViewException("Presentation:" + presentationId, (Throwable)cause);
        }
        this.delete(presentationId);
    }

    public void store(Presentation presentation) throws ViewOperationException {
        String participant = this.session.participantCurrent().getUid();
        if (presentation.isReadOnly() && !presentation.getOwner().equalsIgnoreCase(participant)) {
            throw new ViewOperationException("Presentation:" + presentation.getId());
        }
        Presentation cachePresentation = (Presentation)this.getCache().get(presentation.getId());
        if (cachePresentation != null && cachePresentation.getType() != presentation.getType()) {
            throw new ViewOperationException("Presentation:" + presentation.getId());
        }
        PresentationAdapter presentationAdapter = (PresentationAdapter)presentation;
        IUserMetadataService service = this.session.getWorkflowServiceClient().getUserMetadataService();
        if (this.session.isAdministrator()) {
            try {
                PrincipleListTypeImpl principleList = new PrincipleListTypeImpl();
                BPMUser bpmUser = this.session.getBPMUser();
                for (Object object : bpmUser.getAppRoles(true)) {
                    BPMAppRole role = (BPMAppRole)object;
                    PrincipleRefTypeImpl principleRefType = new PrincipleRefTypeImpl();
                    principleRefType.setName(role.getName());
                    principleRefType.setRealm(role.getRealmName());
                    principleRefType.setType("application_role");
                    principleList.getParticipant().add(principleRefType);
                }
                presentationAdapter.getWorkflowPresentation().setGrantees((PrincipleListType)principleList);
            }
            catch (OperationException cause) {
                ViewOperationException viewOperationException = new ViewOperationException("Presentation:" + presentation.getId());
                viewOperationException.initCause((Throwable)cause);
                throw viewOperationException;
            }
            catch (BPMIdentityException cause) {
                ViewOperationException viewOperationException = new ViewOperationException("Presentation:" + presentation.getId());
                viewOperationException.initCause((Throwable)cause);
                throw viewOperationException;
            }
        }
        try {
            String workflowId = presentationAdapter.getWorkflowId();
            if (workflowId == null && cachePresentation != null) {
                workflowId = ((PresentationAdapter)cachePresentation).getWorkflowId();
            }
            oracle.bpel.services.workflow.user.model.Presentation workflowPresentation = presentationAdapter.getWorkflowPresentation();
            workflowPresentation.setId(workflowId);
            workflowPresentation = workflowId == null ? UserMetadataUtil.getInstance().createPresentationFromType(service.createPresentation((IWorkflowContext)this.session.getBPMContext(), (PresentationType)workflowPresentation)) : UserMetadataUtil.getInstance().createPresentationFromType(service.updatePresentation((IWorkflowContext)this.session.getBPMContext(), (PresentationType)workflowPresentation));
            presentationAdapter.setWorkflowPresentation(this.session, workflowPresentation);
        }
        catch (WorkflowException cause) {
            ViewOperationException exception = new ViewOperationException("Presentation: " + presentation.getId());
            exception.initCause((Throwable)cause);
            throw exception;
        }
        this.put((Presentation)presentationAdapter);
    }

    public Presentation get(String presentationId) {
        String papiId;
        Presentation presentation = (Presentation)this.getCache().get(presentationId);
        if (presentation == null && (papiId = (String)this.getWorkflowPapiMapping().get(presentationId)) != null) {
            presentation = (Presentation)this.getCache().get(papiId);
        }
        return presentation;
    }

    public synchronized void put(Presentation presentation) {
        this.getCache().put(presentation.getId(), presentation);
        String workflowId = ((PresentationAdapter)presentation).getWorkflowId();
        if (workflowId != null) {
            this.getWorkflowPapiMapping().put(workflowId, presentation.getId());
        }
    }

    public void refresh() {
        this.refresh = true;
    }

    public void release() {
        this.cache = new TreeMap<String, Presentation>(String.CASE_INSENSITIVE_ORDER);
        this.refresh();
    }

    private SortedMap<String, Presentation> getCache() {
        if (this.refresh || this.cache == null) {
            this.fill();
        }
        return this.cache;
    }

    private SortedMap<String, String> getWorkflowPapiMapping() {
        if (this.refresh || this.workflowPapiMapping == null) {
            this.fill();
        }
        return this.workflowPapiMapping;
    }

    private synchronized void fill() {
        PresentationAdapter presentationAdapter;
        oracle.bpel.services.workflow.user.model.Presentation workflowPresentation;
        this.refresh = false;
        TreeMap<String, Presentation> participantPresentations = new TreeMap<String, Presentation>(String.CASE_INSENSITIVE_ORDER);
        for (Presentation presentation : PresentationHelper.getDefaultPresentations()) {
            participantPresentations.put(presentation.getId(), presentation);
        }
        if (this.cache != null) {
            for (Presentation presentation : this.cache.values()) {
                if (presentation.getOwner() == null || !presentation.getOwner().equalsIgnoreCase(this.session.participantCurrent().getUid())) continue;
                participantPresentations.put(presentation.getId(), presentation);
            }
        }
        IUserMetadataService service = this.session.getWorkflowServiceClient().getUserMetadataService();
        try {
            for (PresentationType presentation : service.listGrantedPresentations((IWorkflowContext)this.session.getBPMContext(), IUserMetadataService.PresentationDataType.PROCESS, null, false)) {
                workflowPresentation = UserMetadataUtil.getInstance().createPresentationFromType(presentation);
                presentationAdapter = PresentationAdapter.create(this.session, workflowPresentation);
                participantPresentations.put(presentationAdapter.getId(), (Presentation)presentationAdapter);
            }
        }
        catch (WorkflowException exception) {
            BPMLogger.log((Throwable)exception);
        }
        try {
            for (PresentationType presentation : service.listPresentations((IWorkflowContext)this.session.getBPMContext(), IUserMetadataService.PresentationDataType.PROCESS, null)) {
                workflowPresentation = UserMetadataUtil.getInstance().createPresentationFromType(presentation);
                presentationAdapter = PresentationAdapter.create(this.session, workflowPresentation);
                participantPresentations.put(presentationAdapter.getId(), (Presentation)presentationAdapter);
            }
        }
        catch (WorkflowException exception) {
            BPMLogger.log((Throwable)exception);
        }
        TreeMap<String, String> _bpelPapiMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Presentation presentation : participantPresentations.values()) {
            String workflowId = ((PresentationAdapter)presentation).getWorkflowId();
            if (workflowId == null) continue;
            _bpelPapiMapping.put(workflowId, presentation.getId());
        }
        this.cache = participantPresentations;
        this.workflowPapiMapping = _bpelPapiMapping;
    }
}

