/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.mgr;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;

public class SessionManager {
    private Map<ProcessServiceSessionAdapter, Object> sessionsCache = null;

    public SessionManager() {
        WeakHashMap map = new WeakHashMap();
        this.sessionsCache = Collections.synchronizedMap(map);
    }

    public void add(ProcessServiceSessionAdapter session) {
        if (session.getId() == null) {
            session.setId(this.createUUID());
        }
        this.sessionsCache.put(session, null);
    }

    public ProcessServiceSessionAdapter getAnySession() {
        ProcessServiceSessionAdapter[] sessions;
        for (ProcessServiceSessionAdapter session : sessions = this.getSessions()) {
            if (session == null || !session.isOpened()) continue;
            return session;
        }
        return null;
    }

    public ProcessServiceSessionAdapter getSession(String sessionId) {
        ProcessServiceSessionAdapter[] sessions;
        for (ProcessServiceSessionAdapter session : sessions = this.getSessions()) {
            if (session == null || !session.getId().equals(sessionId)) continue;
            return session;
        }
        return null;
    }

    public ProcessServiceSessionAdapter[] getSessions() {
        return this.sessionsCache.keySet().toArray(new ProcessServiceSessionAdapter[this.sessionsCache.size()]);
    }

    public boolean isEmpty() {
        return this.sessionsCache.isEmpty();
    }

    public void remove(ProcessServiceSessionAdapter session) {
        if (session.getId() != null) {
            this.sessionsCache.remove(session);
        }
    }

    public int size() {
        return this.sessionsCache.size();
    }

    public void release() {
        this.sessionsCache.clear();
    }

    private String createUUID() {
        return UUID.randomUUID().toString();
    }
}

