/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.mgr;

import fuego.papi.OperationException;
import fuego.papi.collections.ParticipantList;
import fuego.papi.exception.ParticipantNotFoundException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.papi.ora.Constants;
import oracle.bpm.papi.ora.ProcessServiceSessionAdapter;
import oracle.bpm.papi.ora.org.ParticipantAdapter;
import oracle.tip.pc.services.identity.BPMAppRole;
import oracle.tip.pc.services.identity.BPMGroup;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.pc.services.identity.ComplexSearchFilter;
import oracle.tip.pc.services.identity.SearchFilter;

public class OrganizationManager {
    private static final String PERMISSIONS = "ADEXPGRS";
    public static final String APPLICATION_ROLES = Constants.DEFAULT_APPLICATION;

    public static ParticipantAdapter lookupParticipant(ProcessServiceSessionAdapter session) throws OperationException {
        return OrganizationManager.lookupParticipant(session, session.getBPMContext().getUser(), session.getBPMContext().getIsAdmin());
    }

    public static ParticipantAdapter lookupParticipant(ProcessServiceSessionAdapter session, String globalUserId, boolean isAdministrator) throws OperationException {
        try {
            BPMIdentityService identityService = session.getProcessService().getBPMIdentityService();
            BPMUser user = identityService.lookupUser(globalUserId);
            if (user != null) {
                return ParticipantAdapter.create(user, isAdministrator);
            }
            throw new ParticipantNotFoundException(globalUserId);
        }
        catch (BPMIdentityException cause) {
            throw new OperationException((Throwable)cause);
        }
    }

    public static ParticipantList searchParticipantByName(ProcessServiceSessionAdapter session, String participantName) throws OperationException {
        ParticipantList participants = ParticipantList.create();
        try {
            BPMIdentityService identityService = session.getProcessService().getBPMIdentityService();
            ComplexSearchFilter filter = identityService.getSearchFilterInstance(BPMUser.class, "displayName", "EQUAL", participantName);
            filter.setLogicalOperator("OR");
            filter.addFilterComponent((SearchFilter)identityService.getSearchFilterInstance(BPMUser.class, "firstName", "EQUAL", participantName));
            filter.addFilterComponent((SearchFilter)identityService.getSearchFilterInstance(BPMUser.class, "lastName", "EQUAL", participantName));
            for (Object userObject : identityService.searchUsers((SearchFilter)filter)) {
                participants.add((Object)ParticipantAdapter.create((BPMUser)userObject, false));
            }
        }
        catch (BPMIdentityException cause) {
            throw new OperationException((Throwable)cause);
        }
        return participants;
    }

    public static BPMAppRole lookupBPMAppRole(ProcessServiceSessionAdapter session, String roleId) throws OperationException {
        try {
            return session.getProcessService().getBPMIdentityService().lookupAppRole(roleId, null);
        }
        catch (BPMIdentityException causeException) {
            throw new OperationException((Throwable)causeException);
        }
    }

    public static List<BPMAppRole> getBPMAppRoles(ProcessServiceSessionAdapter session) throws OperationException {
        return OrganizationManager.getBPMRoles(session, Constants.DEFAULT_APPLICATION);
    }

    public static List<BPMAppRole> getBPMRoles(ProcessServiceSessionAdapter session, String application) throws OperationException {
        ArrayList<BPMAppRole> bpmAppRoles = new ArrayList<BPMAppRole>();
        try {
            List list = session.getProcessService().getBPMIdentityService().getAppRoles(application);
            for (Object roleObject : list) {
                bpmAppRoles.add((BPMAppRole)roleObject);
            }
        }
        catch (BPMIdentityException causeException) {
            throw new OperationException((Throwable)causeException);
        }
        return bpmAppRoles;
    }

    public static List<BPMGroup> getBPMGroups(ProcessServiceSessionAdapter session) throws OperationException {
        ArrayList<BPMGroup> bpmGroups = new ArrayList<BPMGroup>();
        try {
            List groupObjects = session.getProcessService().getBPMIdentityService().searchGroups(null);
            for (Object groupObject : groupObjects) {
                bpmGroups.add((BPMGroup)groupObject);
            }
        }
        catch (BPMIdentityException causeException) {
            throw new OperationException((Throwable)causeException);
        }
        return bpmGroups;
    }

    public static BPMGroup lookupBPMGroup(ProcessServiceSessionAdapter session, String groupId) throws OperationException {
        try {
            return session.getProcessService().getBPMIdentityService().lookupGroup(groupId);
        }
        catch (BPMIdentityException causeException) {
            throw new OperationException((Throwable)causeException);
        }
    }
}

