/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.VarDefinition;
import java.util.ArrayList;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.data.BusinessVariableType;
import oracle.bpm.papi.ora.VarDefinitionAdapter;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.processes.DataObject;

public class VarDefinitionFactory {
    public static VarDefinition create(String project, DataObject dataObject) {
        ProjectDataObject projectDataObject;
        boolean isMeasure = false;
        boolean isDimension = false;
        boolean isCounter = false;
        boolean isAttribute = false;
        boolean hasRanges = false;
        ArrayList<VarDefinition.Range> ranges = null;
        if (dataObject instanceof ProjectDataObject && (projectDataObject = (ProjectDataObject)dataObject).isBusiness()) {
            BusinessVariableData businessData;
            BusinessVariableType businessType = projectDataObject.getBusinessVariableType();
            if (businessType != null) {
                isMeasure = businessType == BusinessVariableType.MEASURE;
                isDimension = businessType == BusinessVariableType.DIMENSION;
                isCounter = businessType == BusinessVariableType.COUNTER;
                boolean bl = isAttribute = businessType == BusinessVariableType.ATTRIBUTE;
            }
            if ((businessData = projectDataObject.getBusinessVariableData()) != null) {
                boolean bl = hasRanges = !businessData.isEmpty();
                if (hasRanges) {
                    ranges = new ArrayList<VarDefinition.Range>();
                    for (BusinessVariableData.Range businessRange : businessData.getRange()) {
                        VarDefinition.Range range = new VarDefinition.Range(businessRange.getName(), businessRange.getStart(), businessRange.getFinish());
                        ranges.add(range);
                    }
                }
            }
        }
        return new VarDefinitionAdapter(project, dataObject.getId(), dataObject.getType().getKind(), "", dataObject.getSize(), dataObject.getType().getScale(), isMeasure, isDimension, isCounter, isAttribute, dataObject.getLabelMap(), hasRanges, ranges);
    }
}

