/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.Activity;
import fuego.papi.Task;
import fuego.papi.TaskArgument;
import fuego.papi.VarDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import oracle.bpm.papi.ora.metadata.ActivityAdapter;
import oracle.bpm.papi.ora.metadata.TaskArgumentAdapter;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.type.Argument;

public class TaskAdapter
implements Task {
    private ActivityAdapter activity;
    private oracle.bpel.services.workflow.task.model.Task humanWorkflowTask;
    private HumanTask task;

    public TaskAdapter(oracle.bpel.services.workflow.task.model.Task humanWorkflowTask) {
        this.humanWorkflowTask = humanWorkflowTask;
    }

    public TaskAdapter(ActivityAdapter activityAdapter, HumanTask humanTask) {
        this.activity = activityAdapter;
        this.task = humanTask;
    }

    public VarDefinition[] getVariablesToShow() {
        return this.activity.getProcess().getVariables();
    }

    public Activity getActivity() {
        return this.activity;
    }

    public String getActivityId() {
        return this.activity.getId();
    }

    public TaskArgument[] getArguments() {
        ArrayList<TaskArgumentAdapter> arguments = new ArrayList<TaskArgumentAdapter>();
        if (this.task != null) {
            for (Argument argument : this.task.getArguments()) {
                arguments.add(new TaskArgumentAdapter(argument));
            }
        }
        return arguments.toArray(new TaskArgument[arguments.size()]);
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return this.activity.getDescription(locale);
    }

    public void setDocumentation(Locale locale, String fileName) {
        this.activity.setDocumentation(locale, fileName);
    }

    @Deprecated
    public String getDocumentation(Locale locale) {
        return this.activity.getDocumentation(locale);
    }

    public boolean isDecision() {
        return this.activity.hasType(0x100002);
    }

    public boolean isExternal() {
        return true;
    }

    public oracle.bpel.services.workflow.task.model.Task getHumanWorkflowTask() {
        return this.humanWorkflowTask;
    }

    public String getExternalUrl() {
        return this.getHumanWorkflowTask() != null ? this.getHumanWorkflowTask().getTaskDisplayUrl() : null;
    }

    public String getFolderName() {
        return this.getActivity().getFolderName().concat(File.separator).concat(this.getName());
    }

    public String getId() {
        return this.activity.getId() + "/" + this.getName();
    }

    public int getIn() {
        return 0;
    }

    public String getLabel(Locale locale) {
        return this.activity.getDescription(locale);
    }

    public boolean isMandatory() {
        return true;
    }

    public String getName() {
        return this.task.getName();
    }

    public boolean isOpenNewWindow() {
        return false;
    }

    public boolean isReadOnly() {
        return this.task.isReadOnly();
    }

    public boolean isRepeatable() {
        return false;
    }

    public String getRtViewName() {
        return "";
    }

    public boolean isShowBrowserFullFunc() {
        return false;
    }

    public int getType() {
        return 10;
    }

    public boolean containsDocumentation(Locale locale) {
        return false;
    }

    public boolean hasLocalDocumentation() {
        return false;
    }

    public boolean hasPreview() {
        return false;
    }
}

