/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.Activity;
import fuego.papi.ArgumentSet;
import fuego.papi.Participant;
import fuego.papi.VarDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.collections.sets.StringSet;
import oracle.bpm.lang.Str;
import oracle.bpm.papi.ora.Constants;
import oracle.bpm.papi.ora.helper.OrganizationalUnitIdHelper;
import oracle.bpm.papi.ora.helper.ProcessIdHelper;
import oracle.bpm.papi.ora.helper.RoleIdHelper;
import oracle.bpm.papi.ora.metadata.ActivityAdapter;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.papi.ora.metadata.GlobalCreationActivityAdapter;
import oracle.bpm.papi.ora.metadata.MeasurementAdapter;
import oracle.bpm.papi.ora.metadata.VarDefinitionFactory;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.common.model.ComponentDNModel;
import oracle.bpm.services.internal.processmodel.model.IProcessModelPackage;
import org.jetbrains.annotations.NotNull;

public class ProcessAdapter
implements fuego.papi.Process {
    private Map<String, ActivityAdapter> activities;
    private boolean isActive;
    private String mdsLabel = null;
    private List<MeasurementAdapter> measurements;
    private IProcessModelPackage modelPackage;
    private ComponentDNModel processComponentDN;
    private List<VarDefinition> variables;

    public ProcessAdapter(@NotNull ComponentDNModel processComponentDN, @NotNull IProcessModelPackage modelPackage, @NotNull String mdsLabel) {
        this.modelPackage = modelPackage;
        this.processComponentDN = processComponentDN;
        this.mdsLabel = mdsLabel;
        this.loadActivities();
        this.loadMeasurements();
        this.loadVariables();
    }

    public String getMDSLabel() {
        return this.mdsLabel;
    }

    public Process getProjectModel() {
        return this.modelPackage.getProjectModel();
    }

    public Process getProcess() {
        return this.modelPackage.getProcessModel();
    }

    public Process getProcess(@NotNull String processName) {
        Process result = null;
        if (this.getProcess().getName().equals(processName)) {
            result = this.getProcess();
        } else {
            for (Process process : this.modelPackage.getCallees()) {
                if (!process.getName().equals(processName)) continue;
                result = process;
                break;
            }
        }
        return result;
    }

    public Locale getProjectDefaultLocale() {
        return this.modelPackage.getDefaultLanguage();
    }

    public Sequence<Process> getCallees() {
        return CollectionUtils.asSequence((Collection)this.modelPackage.getCallees());
    }

    public ComponentDNModel getProcessComponentDN() {
        return this.processComponentDN;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Activity[] getActivities() {
        return this.activities.values().toArray(new ActivityAdapter[this.activities.size()]);
    }

    public String[] getActivitiesForParticipant(Participant participant) {
        return this.getActivitiesForRoles(participant.getRoles());
    }

    public String[] getActivitiesForRoles(String[] roles) {
        StringList roleActivities = StringList.create();
        ActivityAdapter begin = null;
        boolean addBegin = false;
        block0: for (ActivityAdapter activity : this.activities.values()) {
            if (activity.hasType(8) && !activity.isAutoCompleteEnabled()) {
                addBegin = true;
            }
            for (String role : roles) {
                if (!activity.canBeSeenByRole(role)) continue;
                if (activity.hasType(33)) {
                    begin = activity;
                    continue block0;
                }
                roleActivities.add((Object)activity.getId());
                continue block0;
            }
        }
        if (addBegin && begin != null) {
            roleActivities.add((Object)begin.getId());
        }
        return roleActivities.toArray();
    }

    public Activity getActivity(String activity) {
        Activity result;
        block4: {
            Process callee;
            String calleeActivityName;
            String activityId;
            String processId;
            String activityName = Activity.getActivityName((String)activity);
            if (!activity.contains("#")) {
                activityName = AdapterUtils.ActivityId.buildName(this.getName(), activity);
            }
            if (Str.isEmpty((String)(processId = Activity.getProcessId((String)activity))) || ProcessIdHelper.isConsolidatedId(processId)) {
                processId = this.getId();
            }
            if ((result = (Activity)this.activities.get(activityId = Activity.makeId((String)processId, (String)activityName))) != null) break block4;
            int idx = activityName.indexOf(35);
            if (idx != -1) {
                activityName = activityName.substring(idx);
            }
            Sequence<Process> callees = this.getCallees();
            Iterator i$ = callees.iterator();
            while (i$.hasNext() && (result = (Activity)this.activities.get(activityId = Activity.makeId((String)processId, (String)(calleeActivityName = (callee = (Process)i$.next()).getId() + activityName)))) == null) {
            }
        }
        return result;
    }

    public String[] getApplicationRoles() {
        StringSet role = StringSet.create();
        if (this.activities != null) {
            for (ActivityAdapter activity : this.activities.values()) {
                if (Str.isEmpty((String)activity.getRole()) || !activity.hasType(4) || activity.hasInstanceAccess() || activity.hasType(1)) continue;
                role.add((Object)activity.getRole());
            }
        }
        return role.toArray();
    }

    public ArgumentSet[] getArgumentSets() {
        Activity _activity = this.getBeginActivity();
        if (_activity != null) {
            return _activity.getArgumentSets();
        }
        return new ArgumentSet[0];
    }

    public ArgumentSet[] getArgumentSets(String activity) {
        Activity _activity = this.getActivity(activity);
        return _activity.getArgumentSets();
    }

    public boolean isAutomatic() {
        if (this.activities != null) {
            for (ActivityAdapter activity : this.activities.values()) {
                if (!activity.hasType(2) && !activity.hasType(4)) continue;
                return false;
            }
        }
        return true;
    }

    public Activity getBeginActivity() {
        return this.getActivity(ProcessIdHelper.buildActivityId(this.getId(), Constants.BEGIN_ACTIVITY_NAME));
    }

    public String getProjectName() {
        return this.modelPackage.getProjectName();
    }

    public int getCatalogIn() {
        throw new UnsupportedOperationException("Method not supported: getCatalogIn");
    }

    public String getConsolidatedId() {
        return ProcessIdHelper.getConsolidatedId(this.getId());
    }

    public String getDeployedEngine() {
        throw new UnsupportedOperationException("Method not supported: getDeployedEngine");
    }

    public String getDescription(Locale locale) {
        LocaleStringMap descriptions = this.getProcess().getDescriptionMap();
        String description = descriptions == null ? null : descriptions.getString(locale);
        return description == null ? this.getName() : description;
    }

    public void setDocumentation(Locale locale, String html) {
        this.getDocumentationMap().put(locale, html);
    }

    public String getDocumentation(Locale locale) {
        return this.getDocumentationMap() != null ? this.getDocumentationMap().getString(locale) : null;
    }

    public LocaleStringMap getDocumentationMap() {
        return this.getProcess().getDocumentationMap();
    }

    public String getFolderName() {
        return this.getOrganizationUnit().concat(File.separator).concat(this.getName()).concat(File.separator).concat(this.getVersion());
    }

    public String[] getGlobalCreationRoles() {
        StringSet roles = StringSet.create();
        if (this.activities != null) {
            for (ActivityAdapter activity : this.activities.values()) {
                if (Str.isEmpty((String)activity.getRole()) || !activity.hasType(14) || activity.isAutoCompleteEnabled()) continue;
                roles.add((Object)activity.getRole());
            }
        }
        return roles.toArray();
    }

    public Activity[] getGrabActivitiesForActivity(String activityId) {
        HashSet<ActivityAdapter> grabActivities = new HashSet<ActivityAdapter>();
        Activity activity = this.getActivity(activityId);
        if (activity != null) {
            for (ActivityAdapter a : this.activities.values()) {
                if (!a.hasType(16) || !a.canGrab(activity.getName())) continue;
                grabActivities.add(a);
            }
        }
        return grabActivities.toArray(new Activity[grabActivities.size()]);
    }

    public String getId() {
        return this.getProcessComponentDN().getDNString();
    }

    public int getIn() {
        throw new UnsupportedOperationException("Method not supported: getIn");
    }

    public String[] getInteractiveRoles() {
        StringSet roles = StringSet.create();
        if (this.activities != null) {
            for (ActivityAdapter activity : this.activities.values()) {
                if (Str.isEmpty((String)activity.getRole()) || !activity.hasType(2) || activity.hasType(4)) continue;
                roles.add((Object)activity.getRole());
            }
        }
        return roles.toArray();
    }

    public String getLabel(Locale locale) {
        String compositeName = this.getProcessComponentDN().getCompositeDN().getCompositeName();
        String compositeRevision = this.getProcessComponentDN().getCompositeDN().getRevision();
        String project = (compositeName != null ? compositeName : "") + " v" + (compositeRevision != null ? compositeRevision : "");
        String label = this.getName();
        if (this.getLabels() != null && ((label = this.getLabels().getString(locale)) == null || label.trim().length() == 0)) {
            label = this.getProcess().getDefaultLabel();
        }
        return (project != null ? "[" + project + "] " : "") + (label != null && !"".equals(label.trim()) ? label : this.getName());
    }

    public String getLabelWithOU(Locale locale) {
        String label = this.getLabel(locale);
        String processOU = this.getOrganizationUnit();
        return OrganizationalUnitIdHelper.isRootId(processOU) ? label : label + "(" + processOU + ")";
    }

    public String getLabelWithOUForParticipant(Locale locale, Participant participant) {
        String label = this.getLabel(locale);
        String processOU = this.getOrganizationUnit() == null ? OrganizationalUnitIdHelper.getRootId() : this.getOrganizationUnit();
        String participantOU = participant.getOu() == null ? OrganizationalUnitIdHelper.getRootId() : participant.getOu();
        String ou = OrganizationalUnitIdHelper.getRootId();
        if (processOU.length() > participantOU.length()) {
            ou = processOU.substring(participantOU.length());
        }
        return OrganizationalUnitIdHelper.isRootId(ou) ? label : label + " (" + ou + ")";
    }

    public LocaleStringMap getLabels() {
        return this.getProcess().getLabelMap();
    }

    public void setLastNewsTimestamp(long lastNews) {
        throw new UnsupportedOperationException("Method not supported: setLastNewsTimestamp");
    }

    public long getLastNewsTimestamp() {
        throw new UnsupportedOperationException("Method not supported: getLastNewsTimestamp");
    }

    public Activity[] getMeasurements() {
        if (this.measurements == null || this.measurements.isEmpty()) {
            return new Activity[0];
        }
        return this.measurements.toArray(new Activity[this.measurements.size()]);
    }

    public String getName() {
        return this.getProcess().getName();
    }

    public boolean isOnline() {
        return true;
    }

    public String getOrganizationUnit() {
        return ProcessIdHelper.getOUFromID(this.getId());
    }

    public String[] getRoles() {
        StringSet roles = StringSet.createCaseInsensitive();
        for (ActivityAdapter activity : this.activities.values()) {
            String role = activity.getRole();
            if (Str.isEmpty((String)role)) continue;
            roles.add((Object)activity.getRole());
        }
        return (String[])roles.toArray((Object[])new String[roles.size()]);
    }

    public VarDefinition[] getVars() {
        return this.getVariables();
    }

    public VarDefinition[] getVariables() {
        return this.variables.toArray(new VarDefinition[this.variables.size()]);
    }

    public String getVersion() {
        return ProcessIdHelper.getProcessVersionFromID(this.getId());
    }

    public boolean isVisibleTo(Participant participant) {
        return this.getActivitiesForParticipant(participant).length != 0 && OrganizationalUnitIdHelper.areVisible(this.getOrganizationUnit(), participant.getOu());
    }

    public void activate() {
        throw new UnsupportedOperationException("Method not implemented yet: activate");
    }

    public boolean containsDocumentation(Locale locale) {
        return this.getDocumentationMap() != null && this.getDocumentationMap().containsKey(locale);
    }

    public void deprecate() {
        throw new UnsupportedOperationException("Method not implemented yet: deprecate");
    }

    public boolean hasApplicationRole(String roleId) {
        return this.findRole(RoleIdHelper.getRoleNameFromRoleId(roleId), this.getApplicationRoles());
    }

    public boolean hasGlobalCreationRole(String roleId) {
        return this.findRole(RoleIdHelper.getRoleNameFromRoleId(roleId), this.getGlobalCreationRoles());
    }

    public boolean hasInteractiveRole(String roleId) {
        return this.findRole(RoleIdHelper.getRoleNameFromRoleId(roleId), this.getInteractiveRoles());
    }

    public boolean hasLocalDocumentation() {
        return this.getDocumentationMap() != null && !this.getDocumentationMap().isEmpty();
    }

    public boolean hasRole(String role) {
        int index = role.indexOf(58);
        return this.findRole(index == -1 ? role : role.substring(0, index), this.getRoles());
    }

    public String toString() {
        StringBuilder toStringValue = new StringBuilder();
        toStringValue.append("id:").append(this.getId()).append(", name:").append(this.getName());
        toStringValue.append(", roles:").append(this.getRoles() != null ? Arrays.asList(this.getRoles()).toString() : "null");
        toStringValue.append(", vars:").append(this.getVariables() != null ? Arrays.asList(this.getVariables()) : "null");
        toStringValue.append(", activities:").append(this.getActivities() != null ? Arrays.asList(this.getActivities()) : "null");
        return toStringValue.toString();
    }

    public boolean hasProcessDiagram() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessAdapter that = (ProcessAdapter)o;
        return this.processComponentDN.equals((Object)that.processComponentDN);
    }

    public int hashCode() {
        return this.processComponentDN.hashCode();
    }

    private static boolean isGlobalCreationActivity(FlowNode flowNode) {
        if (flowNode.getBpmnType() != BpmnType.USER_TASK) {
            return false;
        }
        UserTaskFeature.ManualCreationFeature feature = (UserTaskFeature.ManualCreationFeature)flowNode.getFeature(UserTaskFeature.ManualCreationFeature.class);
        return feature != null && feature.getValue() != false;
    }

    private void loadActivities() {
        this.activities = new HashMap<String, ActivityAdapter>();
        for (FlowNode flowNode : this.selectAllFlowNodes()) {
            ActivityAdapter activityAdapter = new ActivityAdapter(this, flowNode);
            this.activities.put(activityAdapter.getId(), activityAdapter);
            if (!ProcessAdapter.isGlobalCreationActivity(flowNode)) continue;
            activityAdapter = new GlobalCreationActivityAdapter(this, flowNode);
            this.activities.put(activityAdapter.getId(), activityAdapter);
        }
    }

    private Sequence<FlowNode> selectAllFlowNodes() {
        ArrayList nodes = new ArrayList();
        ArrayList<Process> targetProcesses = new ArrayList<Process>();
        targetProcesses.add(this.getProcess());
        this.getCallees().addAllTo(targetProcesses);
        for (Process targetProcess : targetProcesses) {
            targetProcess.getChildrenByType(FlowNode.class).select(ModelUtils.ACTIVTY_LIKE_FLOWNODE_FILTER).flatten(AdapterUtils.SUB_PROCESS_TRAVERSAL_NOCALLABLE).addAllTo(nodes);
        }
        return CollectionUtils.asSequence(nodes);
    }

    private void loadVariables() {
        String project = this.processComponentDN.getCompositeDN().getCompositeName();
        this.variables = new ArrayList<VarDefinition>();
        this.variables.addAll(Arrays.asList(VarDefinition.createInstanceDefaults()));
        for (DataObject dataObject : this.getProjectModel().getLocalDeclarations(DataObject.class)) {
            this.variables.add(VarDefinitionFactory.create(project, dataObject));
        }
    }

    private void loadMeasurements() {
        this.measurements = new ArrayList<MeasurementAdapter>();
        ArrayList<Process> targetProcesses = new ArrayList<Process>();
        targetProcesses.add(this.getProcess());
        this.getCallees().addAllTo(targetProcesses);
        for (Process targetProcess : targetProcesses) {
            for (Measurement measurement : targetProcess.getChildrenByType(FlowElement.class).flatten(AdapterUtils.SUB_PROCESS_FLOW_ELEMENT_TRAVERSAL_NOCALLABLE).select(ModelUtils.MEASUREMENTS_FILTER).selectInstanceOf(Measurement.class)) {
                this.measurements.add(MeasurementAdapter.create(this, measurement));
            }
        }
    }

    private boolean findRole(String role, String[] roles) {
        for (String r : roles) {
            if (!r.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }
}

