/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.Activity;
import fuego.papi.ArgumentSet;
import fuego.papi.Participant;
import fuego.papi.Process;
import fuego.papi.Task;
import fuego.papi.VarDefinition;
import fuego.papi.exception.InvalidTaskNumberException;
import fuego.papi.exception.InvalidVariableIdException;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import org.jetbrains.annotations.NotNull;

public class MeasurementAdapter
extends Activity {
    private Measurement measurement;
    private ProcessAdapter process;

    private MeasurementAdapter(@NotNull ProcessAdapter process, @NotNull Measurement measurement) {
        this.process = process;
        this.measurement = measurement;
        this.name_d = measurement.getId();
        this.type_d = this.getPapiBPMNType();
    }

    public static MeasurementAdapter create(@NotNull ProcessAdapter process, @NotNull Measurement measurement) {
        return new MeasurementAdapter(process, measurement);
    }

    public boolean isAbortEnabled() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public boolean isAutoCompleteEnabled() {
        return true;
    }

    public String getDocumentation(Locale locale) {
        return this.measurement.getDocumentationMap().getString(locale);
    }

    public String getFolderName() {
        return null;
    }

    public String getId() {
        return this.process.getId() + "/" + this.getName();
    }

    public int getIn() {
        throw new UnsupportedOperationException("Methos not supported in 11g.");
    }

    public boolean isInstancePresentation() {
        return false;
    }

    public boolean isOnline() {
        return true;
    }

    public boolean isLoopActivity() {
        return false;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getProcessId() {
        return this.process.getId();
    }

    public boolean isResaignEnabled() {
        return false;
    }

    public boolean isReassignEnabled() {
        return false;
    }

    public boolean hasInstanceAccess() {
        return false;
    }

    public String getActivityName() {
        return this.getName();
    }

    public String getDescription(Locale locale) {
        return this.measurement.getDescriptionMap().getString(locale);
    }

    public String getLabel(Locale locale) {
        String label = this.measurement.getLabel(locale);
        if (label == null || "".equals(label.trim())) {
            label = this.measurement.getDefaultLabel();
        }
        return label != null && !"".equals(label.trim()) ? label : this.getName();
    }

    public ArgumentSet[] getArgumentSets() {
        return new ArgumentSet[0];
    }

    public LocaleStringMap getLabels() {
        return this.measurement.getLabelMap();
    }

    public String getRole() {
        Lane lane = this.measurement.getLane();
        if (lane == null) {
            return null;
        }
        if (!lane.isAutomatic()) {
            return lane.getRole();
        }
        return null;
    }

    public boolean isSelectEnabled() {
        return false;
    }

    public Activity[] getSourceActivitiesForGrab() {
        return new Activity[0];
    }

    public boolean isSuspendEnabled() {
        return false;
    }

    public Task getTask(int taskNumber) {
        throw new InvalidTaskNumberException(taskNumber, this.getId());
    }

    public Task getTask(String taskId) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public Task[] getTasks() {
        return new Task[0];
    }

    public boolean isUserSelectsTransitionEnabled() {
        return false;
    }

    public boolean hasLocalDocumentation() {
        return false;
    }

    public boolean hasOutgoingTransitions() {
        return true;
    }

    public boolean hasTransitionsToInteractiveActivities() {
        return false;
    }

    public void setDocumentation(Locale locale, String html) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public void setDocumentationMap(LocaleStringMap documentationMap) {
        throw new UnsupportedOperationException("Method not supported in 11g.");
    }

    public LocaleStringMap getDocumentationMap() {
        return this.measurement.getDocumentationMap();
    }

    public Object getVar(String variableId, Locale locale) throws InvalidVariableIdException {
        throw new InvalidVariableIdException(variableId, true, this.getId());
    }

    public VarDefinition[] getVars() {
        return new VarDefinition[0];
    }

    public boolean canBeGrabbedBy(Activity grabActivity) {
        return false;
    }

    public boolean canBeSeenByParticipant(Participant participant) {
        return false;
    }

    public boolean canBeSeenByRole(String role) {
        return false;
    }

    public boolean canGrab(String sourceActivity) {
        return false;
    }

    public boolean containsDocumentation(Locale locale) {
        return this.measurement.getDocumentationMap().containsKey(locale);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    private int getPapiBPMNType() {
        switch (this.measurement.getMeasurementType()) {
            case START: {
                return 8388627;
            }
            case STOP: {
                return 8388628;
            }
            case START_STOP: {
                return 8388629;
            }
        }
        return 8388629;
    }
}

