/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.ArgumentSet;
import fuego.papi.Task;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.papi.ora.metadata.ActivityAdapter;
import oracle.bpm.papi.ora.metadata.AdapterUtils;
import oracle.bpm.papi.ora.metadata.ProcessAdapter;
import oracle.bpm.project.model.processes.ApplicationInfo;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class GlobalCreationActivityAdapter
extends ActivityAdapter {
    private static final String GLOBAL_CREATION_SUFFIX = "_GLOBAL_CREATION";

    public GlobalCreationActivityAdapter(ProcessAdapter process, FlowNode flowNode) {
        super(process, flowNode);
        this.activityId = AdapterUtils.ActivityId.createActivityId(process.getProcessComponentDN(), flowNode.getProcess().getName(), GlobalCreationActivityAdapter.getGlobalActivityName(flowNode.getId()));
        this.name_d = this.activityId.getUnqualifiedActivityName();
        this.type_d = 14;
    }

    public static String getGlobalActivityName(@NotNull String name) {
        return name + GLOBAL_CREATION_SUFFIX;
    }

    @Override
    public Task getTask(int taskNumber) {
        return null;
    }

    @Override
    public Task getTask(String taskId) {
        return null;
    }

    @Override
    public Task[] getTasks() {
        return new Task[0];
    }

    @Override
    public ArgumentSet[] getArgumentSets() {
        return new ArgumentSet[0];
    }

    @Override
    public String getDescription(Locale locale) {
        return "";
    }

    @Override
    @Deprecated
    public String getDocumentation(Locale locale) {
        return null;
    }

    @Override
    public boolean hasLocalDocumentation() {
        return false;
    }

    @Override
    public boolean hasOutgoingTransitions() {
        return false;
    }

    @Override
    public boolean hasTransitionsToInteractiveActivities() {
        return false;
    }

    @Override
    public String getLabel(Locale locale) {
        String label = this.getProcess().getLabel(locale);
        String revision = ((ProcessAdapter)this.getProcess()).getProcessComponentDN().getCompositeDN().getRevision();
        return label + (revision != null ? " v" + revision : "");
    }

    @Override
    public LocaleStringMap getLabels() {
        return this.getProcess().getLabels();
    }

    public String getCategory(Locale locale) {
        ApplicationInfo applicationInfo;
        Process process;
        FlowNode flowNode = this.getFlowNode();
        if (flowNode != null && (process = flowNode.getProcess()) != null && (applicationInfo = process.getApplicationInfo()) != null) {
            return applicationInfo.getCategory(locale);
        }
        return "";
    }

    public String getApplicationLinkDisplayName(Locale locale) {
        ApplicationInfo applicationInfo;
        Process process;
        FlowNode flowNode = this.getFlowNode();
        if (flowNode != null && (process = flowNode.getProcess()) != null && (applicationInfo = process.getApplicationInfo()) != null) {
            return applicationInfo.getLinkName(locale);
        }
        return "";
    }

    @Override
    @Exclude
    public void setDocumentation(Locale locale, String html) {
    }

    @Override
    @Exclude
    public void setDocumentationMap(LocaleStringMap documentationMap) {
    }
}

