/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import fuego.papi.ArgumentSet;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public class ArgumentSetAdapter
implements ArgumentSet {
    private DataAssociationSet dataAssociationSet;

    public ArgumentSetAdapter(DataAssociationSet dataAssociationSet) {
        this.dataAssociationSet = dataAssociationSet;
    }

    public ArgumentAdapter[] getArguments() {
        Sequence arguments = this.dataAssociationSet.getArgumentsContainer().getDeclarations();
        ArgumentAdapter[] adapters = new ArgumentAdapter[arguments.toArray().length];
        int i = 0;
        for (DataDeclaration argument : arguments) {
            adapters[i++] = new ArgumentAdapter(argument);
        }
        return adapters;
    }

    public String getName() {
        return null;
    }

    public static class ArgumentAdapter
    implements ArgumentSet.Argument {
        private DataDeclaration argument;
        private Class javaClass;

        protected ArgumentAdapter(DataDeclaration argument) {
            this.argument = argument;
        }

        public Class getJavaClass() throws ClassNotFoundException {
            if (this.javaClass == null) {
                this.javaClass = Class.forName(this.getJavaType());
            }
            return this.javaClass;
        }

        public String getJavaType() {
            return this.argument.getType().getDelegate().getJavaType();
        }

        public String getType() {
            return this.argument.getType() != null ? this.argument.getType().getDelegate().getText() : null;
        }

        public String getName() {
            return this.argument.getName();
        }
    }
}

