/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.papi.ora.metadata;

import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.collections.Function;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.services.common.model.ComponentDNModel;
import org.jetbrains.annotations.NotNull;

public class AdapterUtils {
    static final Function<FlowNode, Iterator<FlowNode>> SUB_PROCESS_TRAVERSAL_NOCALLABLE = new Function<FlowNode, Iterator<FlowNode>>(){

        public Iterator<FlowNode> eval(FlowNode flowNode) {
            Activity activity;
            Iterator<FlowNode> result = flowNode.isActivity() ? ((activity = (Activity)flowNode.asAnyNode(Activity.class)).isSubprocess() ? this.subProcessIterator((Subprocess)flowNode.asAnyNode(Subprocess.class)) : null) : null;
            return result;
        }

        private Iterator<FlowNode> subProcessIterator(Subprocess subprocess) {
            assert (subprocess != null);
            return subprocess.getChildrenByType(FlowNode.class).iterator();
        }
    };
    static final Function<FlowElement, Iterator<FlowElement>> SUB_PROCESS_FLOW_ELEMENT_TRAVERSAL_NOCALLABLE = new Function<FlowElement, Iterator<FlowElement>>(){

        public Iterator<FlowElement> eval(FlowElement flowElement) {
            Activity activity;
            Iterator<FlowElement> result = flowElement instanceof Activity ? ((activity = (Activity)flowElement).isSubprocess() ? this.subProcessIterator((Subprocess)activity.asAnyNode(Subprocess.class)) : null) : null;
            return result;
        }

        private Iterator<FlowElement> subProcessIterator(Subprocess subprocess) {
            assert (subprocess != null);
            return subprocess.getChildrenByType(FlowElement.class).iterator();
        }
    };

    public static class ActivityId
    implements Serializable {
        private ComponentDNModel componentDN;
        private String id;
        private String processName;
        private String unqualifiedActivityName;
        private static final long serialVersionUID = 1979354388062081588L;
        private static final Pattern ACTIVITYID_PATTERN = Pattern.compile("(.+/.+!.+\\*.*/.+)\\/(.+)\\#(.+)");
        private static final Pattern ACTIVITYNAME_PATTERN = Pattern.compile("(.+)\\#(.+)");
        private static final String ACTIVITYNAME_SEPARATOR = "#";

        private ActivityId(@NotNull ComponentDNModel componentDN, @NotNull String processName, @NotNull String unqualifiedActivityName) {
            this.componentDN = componentDN;
            this.processName = processName;
            this.unqualifiedActivityName = unqualifiedActivityName;
            this.id = ActivityId.buildId(this.componentDN, this.processName, this.unqualifiedActivityName);
        }

        public static ActivityId parseActivityId(@NotNull String activityId) {
            Matcher matcher = ACTIVITYID_PATTERN.matcher(activityId);
            if (!matcher.matches() || matcher.groupCount() != 3) {
                throw new IllegalArgumentException("Activity id '" + activityId + "' is invalid!");
            }
            String componentDNString = matcher.group(1);
            String processName = matcher.group(2);
            String unqualifiedActivityName = matcher.group(3);
            return new ActivityId(ComponentDNModel.parseComponentDN((String)componentDNString), processName, unqualifiedActivityName);
        }

        public static ActivityId createActivityId(@NotNull ComponentDNModel componentDN, @NotNull String processName, @NotNull String unqualifiedActivityName) {
            return new ActivityId(componentDN, processName, unqualifiedActivityName);
        }

        public static String obtainProcessNameFromActivityName(@NotNull String activityName) {
            Matcher matcher = ACTIVITYNAME_PATTERN.matcher(activityName);
            if (!matcher.matches() || matcher.groupCount() != 2) {
                throw new IllegalArgumentException("Activity name '" + activityName + "' is invalid!");
            }
            String processName = matcher.group(1);
            return processName;
        }

        public static String obtainUnqualifiedActivityNameFromActivityName(@NotNull String activityName) {
            Matcher matcher = ACTIVITYNAME_PATTERN.matcher(activityName);
            if (!matcher.matches() || matcher.groupCount() != 2) {
                throw new IllegalArgumentException("Activity name '" + activityName + "' is invalid!");
            }
            String unqualifiedActivityName = matcher.group(2);
            return unqualifiedActivityName;
        }

        public static String buildId(@NotNull ComponentDNModel processComponentDN, @NotNull String processName, @NotNull String unqualifiedActivityName) {
            return processComponentDN.getDNString() + "/" + ActivityId.buildName(processName, unqualifiedActivityName);
        }

        public static String buildId(@NotNull ComponentDNModel processComponentDN, @NotNull String activityName) {
            return processComponentDN.getDNString() + "/" + activityName;
        }

        public static String buildName(@NotNull String processName, @NotNull String unqualifiedActivityName) {
            if (processName == null || processName.isEmpty() || "null".equalsIgnoreCase(processName)) {
                return unqualifiedActivityName;
            }
            return processName + ACTIVITYNAME_SEPARATOR + unqualifiedActivityName;
        }

        public String getIdString() {
            return this.id;
        }

        public String getProcessName() {
            return this.processName;
        }

        public String getActivityName() {
            return ActivityId.buildName(this.getProcessName(), this.getUnqualifiedActivityName());
        }

        public String getUnqualifiedActivityName() {
            return this.unqualifiedActivityName;
        }

        public String toString() {
            return this.getIdString();
        }
    }
}

